/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.multiblock;

import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import xyz.apex.forge.apexcore.lib.multiblock.MultiBlockPattern;
import xyz.apex.forge.apexcore.lib.util.reflection.FieldHelper;

public class MultiBlock
extends Block {
    protected final MultiBlockPattern pattern;

    public MultiBlock(BlockBehaviour.Properties properties, MultiBlockPattern pattern) {
        super(properties);
        this.pattern = pattern;
        MultiBlock.replaceStateContainer(this);
    }

    @Nullable
    public final BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState defaultBlockState = this.m_49966_();
        BlockState placementState = this.pattern.getStateForPlacement(ctx, defaultBlockState);
        if (placementState != null) {
            placementState = this.getPlacementState(ctx, placementState);
        }
        return placementState;
    }

    public final boolean m_7898_(BlockState blockState, LevelReader level, BlockPos pos) {
        return this.pattern.canSurvive(level, pos, blockState) && this.canSurviveAdditional(level, pos, blockState);
    }

    protected boolean canSurviveAdditional(LevelReader level, BlockPos pos, BlockState blockState) {
        return true;
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext ctx, BlockState defaultBlockState) {
        return defaultBlockState;
    }

    @OverridingMethodsMustInvokeSuper
    public void m_6807_(BlockState blockState, Level level, BlockPos pos, BlockState oldBlockState, boolean isMoving) {
        this.pattern.onPlace(blockState, level, pos, oldBlockState, isMoving);
    }

    @OverridingMethodsMustInvokeSuper
    public void m_6810_(BlockState blockState, Level level, BlockPos pos, BlockState oldBlockState, boolean isMoving) {
        if (!blockState.m_60713_(oldBlockState.m_60734_())) {
            this.pattern.onRemove(blockState, level, pos, oldBlockState, isMoving);
        }
        super.m_6810_(blockState, level, pos, oldBlockState, isMoving);
    }

    public final MultiBlockPattern getMultiBlockPattern() {
        return this.pattern;
    }

    public static void replaceStateContainer(MultiBlock block) {
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)block);
        block.m_7926_(builder);
        block.pattern.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder);
        StateDefinition stateDefinition = builder.m_61101_(Block::m_49966_, BlockState::new);
        block.m_49959_(block.pattern.registerDefaultState((BlockState)stateDefinition.m_61090_()));
        FieldHelper.setPrivateValue(Block.class, (Object)block, stateDefinition, "f_49792_");
    }
}

