/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.support;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;
import xyz.apex.forge.apexcore.core.ApexCore;
import xyz.apex.forge.apexcore.core.net.ClientSyncSupportersPacket;
import xyz.apex.forge.apexcore.lib.net.AbstractPacket;
import xyz.apex.forge.apexcore.lib.util.ProfileHelper;
import xyz.apex.forge.apexcore.lib.util.SkinHelper;
import xyz.apex.java.utility.nullness.NonnullConsumer;
import xyz.apex.java.utility.tuple.Pair;

public final class SupporterManager {
    public static final Gson GSON = new GsonBuilder().setLenient().create();
    public static final String SUPPORTER_URL = "https://raw.githubusercontent.com/ApexStudios-Dev/Version/master/supporters.json";
    private static final Set<SupporterInfo> supporterInfos = Sets.newHashSet();
    private static final Map<UUID, SupporterInfo> supporterInfoMap = Maps.newHashMap();

    public static void precacheSupporterSkins() {
        ApexCore.LOGGER.info("Precaching Supporter Profile & Skins...");
        for (SupporterInfo info : supporterInfos) {
            ApexCore.LOGGER.info("Precaching Supporter '{}' Profile & Skins...", (Object)info.username);
            ProfileHelper.getGameProfile(info.playerId, info.username);
            for (UUID alias : info.aliases) {
                ProfileHelper.getGameProfile(alias, null);
            }
            SkinHelper.getSkins(info.playerId, info.username, (Consumer<ResourceLocation>)NonnullConsumer.noop());
        }
    }

    public static Set<SupporterInfo> getSupporters() {
        return ImmutableSet.copyOf(supporterInfoMap.values());
    }

    public static boolean isSupporter(Player player) {
        UUID playerId = player.m_36316_().getId();
        return supporterInfoMap.containsKey(playerId);
    }

    @Nullable
    public static SupporterInfo getSupporterInfo(Player player) {
        return SupporterManager.findSupporterInfo(player).orElse(null);
    }

    public static Optional<SupporterInfo> findSupporterInfo(Player player) {
        UUID playerId = player.m_36316_().getId();
        return Optional.ofNullable(supporterInfoMap.get(playerId));
    }

    public static void loadSupporters() {
        ApexCore.LOGGER.info("Loading Supporter Data...");
        supporterInfoMap.clear();
        supporterInfos.clear();
        new ReloadThread().start();
    }

    public static void loadSupportersFromNetwork(ClientSyncSupportersPacket packet) {
        ApexCore.LOGGER.info("Loading Supporter Data (From Network)...");
        supporterInfoMap.clear();
        supporterInfos.clear();
        ReloadThread.finalizeParsing(packet.networkInfos);
        ApexCore.LOGGER.info("Loaded {} Supporters (From Network)!", (Object)packet.networkInfos.size());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SupporterManager::precacheSupporterSkins);
    }

    @Nullable
    private static SupporterInfo parseInfo(JsonElement element) {
        if (element.isJsonPrimitive()) {
            UUID playerId = SupporterManager.parseUUID(element);
            if (playerId != null) {
                return new SupporterInfo(playerId, SupporterLevel.DEFAULT, Collections.emptyList(), "Unknown");
            }
        } else if (element.isJsonObject()) {
            JsonObject json = element.getAsJsonObject();
            if (!json.has("uuid")) {
                return null;
            }
            UUID playerId = SupporterManager.parseUUID(json.get("uuid"));
            if (playerId != null) {
                HashSet aliases = Sets.newHashSet();
                SupporterLevel level = SupporterLevel.DEFAULT;
                String username = "Unknown";
                if (json.has("level")) {
                    level = SupporterManager.parseLevel(json.get("level"));
                }
                if (json.has("aliases")) {
                    SupporterManager.parseAliases(json.get("aliases"), aliases);
                }
                if (json.has("name")) {
                    username = json.get("name").getAsString();
                }
                return new SupporterInfo(playerId, level, aliases, username);
            }
        }
        return null;
    }

    private static void parseAliases(JsonElement element, Set<UUID> aliases) {
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            int bound = array.size();
            IntStream.range(0, bound).mapToObj(i -> SupporterManager.parseUUID(array.get(i))).filter(Objects::nonNull).forEach(aliases::add);
        }
    }

    private static SupporterLevel parseLevel(JsonElement element) {
        if (element.isJsonPrimitive()) {
            String str = element.getAsString();
            for (SupporterLevel level : SupporterLevel.values()) {
                if (!level.serializedName.equals(str)) continue;
                return level;
            }
        }
        return SupporterLevel.DEFAULT;
    }

    @Nullable
    private static UUID parseUUID(JsonElement element) {
        if (element.isJsonPrimitive()) {
            try {
                return UUID.fromString(element.getAsString());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public static final class SupporterInfo {
        private final UUID playerId;
        private final Set<UUID> aliases;
        private final SupporterLevel level;
        private final String username;

        public SupporterInfo(UUID playerId, SupporterLevel level, Collection<UUID> aliases, String username) {
            this.playerId = playerId;
            this.level = level;
            this.aliases = ImmutableSet.copyOf(aliases);
            this.username = username;
        }

        public UUID getPlayerId() {
            return this.playerId;
        }

        public SupporterLevel getLevel() {
            return this.level;
        }

        public String getUsername() {
            return this.username;
        }

        public Set<UUID> getAliases() {
            return this.aliases;
        }

        public boolean isFor(UUID playerId) {
            if (this.playerId.equals(playerId)) {
                return true;
            }
            return this.aliases.contains(playerId);
        }

        public boolean isFor(Player player) {
            UUID playerId = player.m_36316_().getId();
            return this.isFor(playerId);
        }

        @Nullable
        public Player getPlayer(Function<UUID, Player> playerIdToPlayerFunction) {
            Player player = playerIdToPlayerFunction.apply(this.playerId);
            if (player != null) {
                return player;
            }
            for (UUID alias : this.aliases) {
                player = playerIdToPlayerFunction.apply(alias);
                if (player == null) continue;
                return player;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            Object object = obj;
            if (object instanceof SupporterInfo) {
                SupporterInfo other = (SupporterInfo)object;
                return this.playerId.equals(other.playerId) && this.level.equals((Object)other.level) && this.aliases.containsAll(other.aliases) && this.username.equals(other.username);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.playerId, this.level, this.aliases, this.username});
        }

        public String toString() {
            StringBuilder str = new StringBuilder("SupporterInfo{ '" + this.playerId + "', '" + this.level.serializedName + "'', '" + this.username + "'");
            if (!this.aliases.isEmpty()) {
                str.append(", [");
                int counter = 0;
                for (UUID alias : this.aliases) {
                    str.append('\'').append(alias).append('\'');
                    if (counter < this.aliases.size() - 1) {
                        str.append(',');
                    }
                    ++counter;
                }
                str.append(']');
            }
            return str.append(" }").toString();
        }

        public JsonElement toJson() {
            if (!this.level.isDefault() || !this.aliases.isEmpty()) {
                JsonObject json = new JsonObject();
                json.addProperty("uuid", this.playerId.toString());
                if (!this.level.isDefault()) {
                    json.addProperty("level", this.level.serializedName);
                }
                if (!this.aliases.isEmpty()) {
                    JsonArray array = new JsonArray();
                    this.aliases.stream().map(UUID::toString).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                    json.add("aliases", (JsonElement)array);
                }
                return json;
            }
            return (JsonElement)GSON.fromJson(GSON.toJson((Object)this.playerId.toString()), JsonElement.class);
        }
    }

    public static final class ReloadThread
    extends Thread {
        private ReloadThread() {
            this.setName("ApexCore Supporter Reload Thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Set<SupporterInfo> infos = this.parseJson();
            ReloadThread.finalizeParsing(infos);
            ApexCore.LOGGER.info("Loaded {} Supporters!", (Object)infos.size());
            if (ServerLifecycleHooks.getCurrentServer() != null) {
                ApexCore.NETWORK.sendTo((AbstractPacket)new ClientSyncSupportersPacket(infos), PacketDistributor.ALL.noArg());
            }
        }

        private Set<SupporterInfo> parseJson() {
            HashSet infos = Sets.newHashSet();
            ArrayList unknownElements = Lists.newArrayList();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(SupporterManager.SUPPORTER_URL).openStream()));){
                JsonArray json = (JsonArray)GSON.fromJson((Reader)reader, JsonArray.class);
                for (int i = 0; i < json.size(); ++i) {
                    JsonElement element = json.get(i);
                    SupporterInfo info = SupporterManager.parseInfo(element);
                    if (info == null) {
                        unknownElements.add(Pair.createImmutable((Object)i, (Object)element));
                        continue;
                    }
                    infos.add(info);
                }
            }
            catch (IOException e) {
                ApexCore.LOGGER.fatal("Fatal Error occurred while parsing Supporter Json!", (Throwable)e);
            }
            if (!unknownElements.isEmpty()) {
                int longest = 0;
                ArrayList lines = Lists.newArrayList();
                for (Pair pair : unknownElements) {
                    Integer index = (Integer)pair.getKey();
                    JsonElement element = (JsonElement)pair.getValue();
                    String elementStr = GSON.toJson(element);
                    String line = "* \t#" + index + "\t=>\t`" + elementStr + "`";
                    int length = line.length();
                    lines.add(line);
                    longest = Math.max(longest, length);
                }
                String warn = "* Found Unknown Supporter Json Elements:";
                String report = "* Please Report this to the Author (https://discord.apexmods.xyz/ | https://github.com/ApexStudios-Dev/ApexCore/issues)";
                longest = Math.max(longest, warn.length());
                longest = Math.max(longest, report.length());
                String header = Strings.repeat((String)"*", (int)longest);
                ApexCore.LOGGER.warn(header);
                ApexCore.LOGGER.warn(warn);
                lines.forEach(arg_0 -> ((Logger)ApexCore.LOGGER).warn(arg_0));
                ApexCore.LOGGER.warn("* ");
                ApexCore.LOGGER.warn(report);
                ApexCore.LOGGER.warn(header);
            }
            return infos;
        }

        private static void finalizeParsing(Set<SupporterInfo> infos) {
            supporterInfos.addAll(infos);
            infos.forEach(ReloadThread::finalizeInfo);
        }

        private static void finalizeInfo(SupporterInfo info) {
            if (!supporterInfoMap.containsKey(info.playerId)) {
                supporterInfoMap.put(info.playerId, info);
            }
            for (UUID alias : info.aliases) {
                if (supporterInfoMap.containsKey(alias)) continue;
                supporterInfoMap.put(alias, info);
            }
        }
    }

    public static enum SupporterLevel implements StringRepresentable
    {
        OWNER("owner", 4),
        DEVELOPER("developer", 3),
        ARTIST("artist", 2),
        CONTRIBUTOR("contributor", 1),
        SUPPORTER("supporter", 0);

        public static final SupporterLevel DEFAULT;
        private final String serializedName;
        private final int level;

        private SupporterLevel(String serializedName, int level) {
            this.serializedName = serializedName;
            this.level = level;
        }

        public String m_7912_() {
            return this.serializedName;
        }

        public int getLevel() {
            return this.level;
        }

        public boolean isBetterThan(SupporterLevel other) {
            return this.level > other.level;
        }

        public boolean isDefault() {
            return this == DEFAULT;
        }

        static {
            DEFAULT = SUPPORTER;
        }
    }
}

