/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;
import net.minecraftforge.fmlserverevents.FMLServerAboutToStartEvent;
import org.apache.commons.lang3.Validate;
import xyz.apex.forge.apexcore.lib.util.EventBusHelper;

public final class ProfileHelper {
    private static final UUID UUID_EXAMPLE = UUID.randomUUID();
    private static final ProfileHelper INSTANCE = new ProfileHelper();
    public static final GameProfile DUMMY_PROFILE = new GameProfile(UUID_EXAMPLE, "steve");
    private final Map<String, GameProfile> gameProfileCache = Collections.synchronizedMap(Maps.newHashMap());
    private final Map<UUID, GameProfile> gameProfileCacheUUID = Collections.synchronizedMap(Maps.newHashMap());
    @Nullable
    private GameProfileCache profileCache;
    @Nullable
    private MinecraftSessionService sessionService;

    private GameProfile getGameProfile0(@Nullable UUID playerId, @Nullable String playerName) {
        Validate.isTrue((playerId != null || playerName != null ? 1 : 0) != 0);
        if (playerName != null && this.gameProfileCache.containsKey(playerName)) {
            return this.gameProfileCache.get(playerName);
        }
        if (playerId != null && this.gameProfileCacheUUID.containsKey(playerId)) {
            return this.gameProfileCacheUUID.get(playerId);
        }
        if (this.profileCache == null || this.sessionService == null) {
            if (FMLEnvironment.dist.isDedicatedServer()) {
                MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
                this.sessionService = currentServer.m_129925_();
                this.profileCache = currentServer.m_129927_();
            } else {
                this.setClientProfileLookupObjects();
            }
        }
        Validate.notNull((Object)this.profileCache);
        Validate.notNull((Object)this.sessionService);
        GameProfile profile = (playerId != null ? this.profileCache.m_11002_(playerId) : this.profileCache.m_10996_(playerName)).orElseGet(() -> this.sessionService.fillProfileProperties(new GameProfile(playerId, playerName), true));
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        if (property == null) {
            profile = this.sessionService.fillProfileProperties(profile, true);
        }
        this.gameProfileCache.put(profile.getName(), profile);
        this.gameProfileCacheUUID.put(profile.getId(), profile);
        return profile;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setClientProfileLookupObjects() {
        Minecraft mc = Minecraft.m_91087_();
        YggdrasilAuthenticationService authenticationService = new YggdrasilAuthenticationService(mc.m_91096_(), UUID.randomUUID().toString());
        GameProfileRepository profileRepository = authenticationService.createProfileRepository();
        this.sessionService = authenticationService.createMinecraftSessionService();
        this.profileCache = new GameProfileCache(profileRepository, new File(mc.f_91069_, MinecraftServer.f_129742_.getName()));
    }

    public static GameProfile getGameProfile(@Nullable UUID playerId, @Nullable String playerName) {
        return INSTANCE.getGameProfile0(playerId, playerName);
    }

    public static void setup() {
        Validate.isTrue((boolean)ModLoadingContext.get().getActiveContainer().getModId().equals("apexcore"));
        EventBusHelper.addEnqueuedListener(FMLClientSetupEvent.class, event -> INSTANCE.setClientProfileLookupObjects());
        EventBusHelper.addListener(FMLServerAboutToStartEvent.class, event -> {
            MinecraftServer server = event.getServer();
            ProfileHelper.INSTANCE.profileCache = server.m_129927_();
            ProfileHelper.INSTANCE.sessionService = server.m_129925_();
        });
    }
}

