/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.revamp.block;

import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import xyz.apex.forge.apexcore.lib.util.ContainerHelper;
import xyz.apex.forge.apexcore.lib.util.NameableMutable;
import xyz.apex.java.utility.nullness.NonnullConsumer;

public class BaseBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING_4_WAY = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public BaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.postBlockConstructor();
    }

    protected void registerProperties(NonnullConsumer<Property<?>> consumer) {
    }

    private void postBlockConstructor() {
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.registerProperties(xva$0 -> builder.m_61104_(new Property[]{xva$0}));
        StateDefinition stateDefinition = builder.m_61101_(Block::m_49966_, BlockState::new);
        this.m_49959_((BlockState)stateDefinition.m_61090_());
        ObfuscationReflectionHelper.setPrivateValue(Block.class, (Object)((Object)this), (Object)stateDefinition, (String)"f_49792_");
    }

    public final BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = this.m_49966_();
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        if (blockState.m_61138_((Property)WATERLOGGED)) {
            FluidState fluidState = level.m_6425_(pos);
            boolean waterLogged = fluidState.m_76153_((Tag)FluidTags.f_13131_);
            blockState = (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterLogged));
        }
        if (blockState.m_61138_((Property)FACING_4_WAY)) {
            blockState = (BlockState)blockState.m_61124_((Property)FACING_4_WAY, (Comparable)this.getFourWayFacing(ctx));
        }
        return blockState;
    }

    public BlockState m_7417_(BlockState blockState, Direction facing, BlockState facingBlockState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (blockState.m_61138_((Property)WATERLOGGED) && ((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_6217_().m_5945_(pos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(blockState, facing, facingBlockState, level, pos, facingPos);
    }

    protected final void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
    }

    public final BlockState m_6843_(BlockState blockState, Rotation rotation) {
        if (blockState.m_61138_((Property)FACING_4_WAY)) {
            return (BlockState)blockState.m_61124_((Property)FACING_4_WAY, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING_4_WAY)));
        }
        return blockState;
    }

    public final BlockState m_6943_(BlockState blockState, Mirror mirror) {
        if (blockState.m_61138_((Property)FACING_4_WAY)) {
            return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING_4_WAY)));
        }
        return blockState;
    }

    public boolean m_7420_(BlockState blockState, BlockGetter level, BlockPos pos) {
        if (blockState.m_61138_((Property)WATERLOGGED)) {
            return (Boolean)blockState.m_61143_((Property)WATERLOGGED) == false;
        }
        return super.m_7420_(blockState, level, pos);
    }

    public final FluidState m_5888_(BlockState blockState) {
        return blockState.m_61138_((Property)WATERLOGGED) && (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public final boolean m_6044_(BlockGetter level, BlockPos pos, BlockState blockState, Fluid fluid) {
        return blockState.m_61138_((Property)WATERLOGGED) && super.m_6044_(level, pos, blockState, fluid);
    }

    public final boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState blockState, FluidState fluidState) {
        return blockState.m_61138_((Property)WATERLOGGED) && super.m_7361_(level, pos, blockState, fluidState);
    }

    public final ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState blockState) {
        return !blockState.m_61138_((Property)WATERLOGGED) ? ItemStack.f_41583_ : super.m_142598_(level, pos, blockState);
    }

    protected Direction getFourWayFacing(BlockPlaceContext ctx) {
        return ctx.m_8125_().m_122424_();
    }

    public static abstract class WithContainer<BLOCK_ENTITY extends BlockEntity, CONTAINER extends AbstractContainerMenu>
    extends WithBlockEntity<BLOCK_ENTITY> {
        public WithContainer(BlockBehaviour.Properties properties) {
            super(properties);
        }

        protected abstract MenuType<CONTAINER> getContainerType();

        protected final InteractionResult tryOpenContainerScreen(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            MenuProvider provider = this.m_7246_(blockState, level, pos);
            if (provider != null) {
                if (level.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                Player player2 = player;
                if (player2 instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player2;
                    NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)provider, buffer -> buffer.m_130064_(pos));
                    return InteractionResult.CONSUME;
                }
            }
            return InteractionResult.PASS;
        }

        public final boolean m_7278_(BlockState blockState) {
            return true;
        }

        public final int m_6782_(BlockState blockState, Level level, BlockPos pos) {
            return ContainerHelper.getRedstoneSignalFromContainer((LevelAccessor)level, pos);
        }

        public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            return this.tryOpenContainerScreen(blockState, level, pos, player, hand, rayTraceResult);
        }

        @OverridingMethodsMustInvokeSuper
        public void m_6402_(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
            Object blockEntity;
            super.m_6402_(level, pos, blockState, placer, stack);
            Object BLOCK_ENTITY = blockEntity = this.getBlockEntity((BlockGetter)level, pos);
            if (BLOCK_ENTITY instanceof NameableMutable) {
                NameableMutable nameable = (NameableMutable)BLOCK_ENTITY;
                if (stack.m_41788_()) {
                    Component customName = stack.m_41786_();
                    nameable.setCustomName(customName);
                }
            }
        }

        @OverridingMethodsMustInvokeSuper
        public void m_6810_(BlockState blockState, Level level, BlockPos pos, BlockState newBlockState, boolean isMoving) {
            Object blockEntity;
            if (!blockState.m_60713_(newBlockState.m_60734_()) && (blockEntity = this.getBlockEntity((BlockGetter)level, pos)) != null) {
                blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        ItemStack stack = itemHandler.getStackInSlot(i);
                        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
                    }
                });
            }
            super.m_6810_(blockState, level, pos, newBlockState, isMoving);
        }

        @Nullable
        public final MenuProvider m_7246_(BlockState blockState, Level level, BlockPos pos) {
            Object blockEntity = this.getBlockEntity((BlockGetter)level, pos);
            if (blockEntity != null) {
                TranslatableComponent containerName = new TranslatableComponent(this.m_7705_());
                Object BLOCK_ENTITY = blockEntity;
                if (BLOCK_ENTITY instanceof Nameable) {
                    Nameable nameable = (Nameable)BLOCK_ENTITY;
                    containerName = nameable.m_5446_();
                }
                return new SimpleMenuProvider((windowId, playerInventory, player) -> {
                    FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                    buffer.m_130064_(pos);
                    return this.getContainerType().create(windowId, playerInventory, buffer);
                }, (Component)containerName);
            }
            return null;
        }
    }

    public static abstract class WithBlockEntity<BLOCK_ENTITY extends BlockEntity>
    extends BaseBlock
    implements EntityBlock {
        public WithBlockEntity(BlockBehaviour.Properties properties) {
            super(properties);
        }

        protected abstract BlockEntityType<BLOCK_ENTITY> getBlockEntityType();

        @Nullable
        protected BlockEntityTicker<BLOCK_ENTITY> getBlockEntityTicker(boolean clientSide) {
            return null;
        }

        @Nullable
        protected final BLOCK_ENTITY getBlockEntity(BlockGetter level, BlockPos pos) {
            return (BLOCK_ENTITY)this.getBlockEntityType().m_58949_(level, pos);
        }

        public final boolean m_8133_(BlockState blockState, Level level, BlockPos pos, int event, int param) {
            BLOCK_ENTITY blockEntity = this.getBlockEntity((BlockGetter)level, pos);
            return blockEntity != null && blockEntity.m_7531_(event, param);
        }

        @Nullable
        public final BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
            return this.getBlockEntityType().m_155264_(pos, blockState);
        }

        @Nullable
        public final <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
            BlockEntityTicker<BLOCK_ENTITY> blockEntityTicker = this.getBlockEntityTicker(level.f_46443_);
            return blockEntityTicker != null ? WithBlockEntity.createTickerHelper(blockEntityType, this.getBlockEntityType(), blockEntityTicker) : null;
        }

        @Nullable
        public final <T extends BlockEntity> GameEventListener m_142226_(Level level, T blockEntity) {
            GameEventListener gameEventListener;
            T t = blockEntity;
            return t instanceof GameEventListener ? (gameEventListener = (GameEventListener)t) : null;
        }

        @Nullable
        protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> blockEntityType, BlockEntityType<E> otherBlockEntityType, BlockEntityTicker<? super E> blockEntityTicker) {
            return otherBlockEntityType == blockEntityType ? blockEntityTicker : null;
        }
    }
}

