/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.revamp.net.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import xyz.apex.forge.apexcore.core.ApexCore;
import xyz.apex.forge.apexcore.lib.net.AbstractPacket;
import xyz.apex.forge.apexcore.lib.net.NetworkManager;
import xyz.apex.forge.apexcore.revamp.block.entity.InventoryBlockEntity;

public final class SyncContainerPacket
extends AbstractPacket {
    private final BlockPos pos;
    private final FriendlyByteBuf buffer;

    private SyncContainerPacket(BlockPos pos, FriendlyByteBuf buffer) {
        this.pos = pos;
        this.buffer = buffer;
    }

    public SyncContainerPacket(FriendlyByteBuf buffer) {
        super(buffer);
        this.pos = buffer.m_130135_();
        this.buffer = buffer;
    }

    @Override
    protected void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeBytes((ByteBuf)this.buffer);
    }

    @Override
    protected void process(NetworkManager network, NetworkEvent.Context ctx) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::processClient);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void processClient() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        BlockEntity tileEntity = mc.f_91073_.m_7702_(this.pos);
        BlockEntity blockEntity = tileEntity;
        if (blockEntity instanceof InventoryBlockEntity) {
            InventoryBlockEntity inventory = (InventoryBlockEntity)blockEntity;
            inventory.readContainerSyncData(this.buffer);
        }
    }

    public static void sendToClient(InventoryBlockEntity blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level == null || level.f_46443_) {
            return;
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        blockEntity.writeContainerSyncData(buffer);
        BlockPos blockPos = blockEntity.m_58899_();
        ApexCore.NETWORK.sendTo((AbstractPacket)new SyncContainerPacket(blockPos, buffer), PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (double)192.0, (ResourceKey)level.m_46472_())));
    }
}

