/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.infusedfoods.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xyz.apex.forge.apexcore.lib.block.VoxelShaper;
import xyz.apex.forge.apexcore.revamp.block.BaseBlock;
import xyz.apex.forge.infusedfoods.InfusedFoods;
import xyz.apex.forge.infusedfoods.block.entity.InfusionStationBlockEntity;
import xyz.apex.forge.infusedfoods.container.InfusionStationMenu;
import xyz.apex.forge.infusedfoods.init.IFElements;
import xyz.apex.java.utility.nullness.NonnullConsumer;

public final class InfusionStationBlock
extends BaseBlock.WithContainer<InfusionStationBlockEntity, InfusionStationMenu> {
    public static final VoxelShape SHAPE = VoxelShaper.or((VoxelShape[])new VoxelShape[]{InfusionStationBlock.m_49796_((double)1.0, (double)0.0, (double)5.0, (double)13.0, (double)1.0, (double)11.0), InfusionStationBlock.m_49796_((double)13.0, (double)0.0, (double)7.0, (double)15.0, (double)14.0, (double)9.0)});
    public static final VoxelShaper SHAPER = VoxelShaper.forHorizontal((VoxelShape)SHAPE, (Direction)Direction.NORTH);

    public InfusionStationBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING_4_WAY, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void registerProperties(NonnullConsumer<Property<?>> consumer) {
        consumer.accept((Object)FACING_4_WAY);
        consumer.accept((Object)WATERLOGGED);
    }

    public void m_7100_(BlockState blockState, Level level, BlockPos pos, Random rng) {
        if (blockState.m_61138_((Property)WATERLOGGED) && !((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            Direction facing = blockState.m_61145_((Property)FACING_4_WAY).orElse(Direction.NORTH).m_122427_();
            double x = (double)pos.m_123341_() + 0.4 + (double)rng.nextFloat() * 0.2 + (double)facing.m_122429_() * 0.4;
            double y = (double)pos.m_123342_() + 0.7 + (double)rng.nextFloat() * 0.3;
            double z = (double)pos.m_123343_() + 0.4 + (double)rng.nextFloat() * 0.2 + (double)facing.m_122431_() * 0.4;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, blockState, placer, stack);
        InfusionStationBlockEntity blockEntity = (InfusionStationBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        CompoundTag apexTag = stack.m_41737_("ApexData");
        if (blockEntity != null && apexTag != null) {
            blockEntity.deserializeData(apexTag);
        }
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (blockState.m_61138_((Property)FACING_4_WAY)) {
            Direction facing = (Direction)blockState.m_61143_((Property)FACING_4_WAY);
            return SHAPER.get(facing);
        }
        return Shapes.m_83144_();
    }

    public boolean m_7357_(BlockState blockState, BlockGetter level, BlockPos pos, PathComputationType pathType) {
        return false;
    }

    protected BlockEntityType<InfusionStationBlockEntity> getBlockEntityType() {
        return IFElements.INFUSION_STATION_BLOCK_ENTITY.asBlockEntityType();
    }

    protected MenuType<InfusionStationMenu> getContainerType() {
        return IFElements.INFUSION_STATION_MENU.asMenuType();
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        InfusedFoods.appendPotionEffectTooltips(stack, tooltip);
    }

    @Nullable
    protected BlockEntityTicker<InfusionStationBlockEntity> getBlockEntityTicker(boolean clientSide) {
        return !clientSide ? InfusionStationBlockEntity::tick : null;
    }
}

