/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.infusedfoods.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import xyz.apex.forge.infusedfoods.block.InfusionStationBlock;
import xyz.apex.forge.infusedfoods.block.entity.InfusionStationBlockEntity;
import xyz.apex.forge.infusedfoods.client.renderer.model.InfusionStationModel;
import xyz.apex.forge.infusedfoods.init.IFElements;

public final class InfusionStationBlockEntityRenderer
implements BlockEntityRenderer<InfusionStationBlockEntity> {
    private final InfusionStationModel model;

    public InfusionStationBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new InfusionStationModel(ctx);
    }

    public void render(InfusionStationBlockEntity blockEntity, float partialTick, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        IItemHandler inventory = blockEntity.getItemHandler();
        MobEffect effect = blockEntity.getEffect();
        int effectAmount = blockEntity.getEffectAmount();
        boolean hasBottle = !inventory.getStackInSlot(4).m_41619_();
        boolean hasPotion = !inventory.getStackInSlot(0).m_41619_();
        boolean hasFluid = effect != null && effectAmount > 0;
        boolean hasFood = !inventory.getStackInSlot(2).m_41619_();
        int color = InfusionStationBlockEntity.getColor(effect, blockEntity.getEffectAmplifier());
        this.model.setUpForRender(hasPotion, hasBottle, hasFluid, hasFood, color);
        pose.m_85836_();
        BlockState blockState = blockEntity.m_58900_();
        Direction facing = (Direction)blockState.m_61143_((Property)InfusionStationBlock.FACING_4_WAY);
        pose.m_85837_(0.5, 0.5, 0.5);
        pose.m_85845_(Vector3f.f_122225_.m_122240_(-facing.m_122435_()));
        pose.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        pose.m_85837_(0.0, -1.0, 0.0);
        RenderType renderType = RenderType.m_110470_((ResourceLocation)IFElements.INFUSION_STATION_BLOCK_TEXTURE);
        VertexConsumer modelBuffer = buffer.m_6299_(renderType);
        this.model.m_7695_(pose, modelBuffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.m_85836_();
        pose.m_85837_(0.0, 1.0, 0.0);
        renderType = RenderType.m_110470_((ResourceLocation)IFElements.INFUSION_STATION_BLOCK_TEXTURE_TINT);
        modelBuffer = buffer.m_6299_(renderType);
        this.model.renderToBufferTint(pose, modelBuffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f, true);
        pose.m_85849_();
        pose.m_85849_();
    }

    public void renderForGUI(ItemStack stack, InfusionStationBlockEntity blockEntity, float partialTick, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay, ItemTransforms.TransformType transformType) {
        if (transformType == ItemTransforms.TransformType.NONE) {
            return;
        }
        boolean hasPotion = false;
        int potionColor = 7474959;
        MobEffect effect = blockEntity.getEffect();
        int effectAmount = blockEntity.getEffectAmount();
        if (effect != null && effectAmount > 0) {
            hasPotion = true;
            potionColor = InfusionStationBlockEntity.getColor(effect, blockEntity.getEffectAmplifier());
        }
        this.model.setUpForRender(hasPotion, hasPotion, hasPotion, true, potionColor);
        pose.m_85836_();
        if (transformType == ItemTransforms.TransformType.GUI) {
            pose.m_85845_(Vector3f.f_122223_.m_122240_(30.0f));
            pose.m_85845_(Vector3f.f_122225_.m_122240_(225.0f));
            pose.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            pose.m_85837_(0.55, -1.5, -0.15);
            pose.m_85841_(0.85f, 0.95f, 0.9f);
        } else if (transformType == ItemTransforms.TransformType.HEAD) {
            pose.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            pose.m_85837_(-0.5, -2.45, 0.5);
        } else if (transformType == ItemTransforms.TransformType.GROUND) {
            pose.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            pose.m_85837_(-0.5, -1.0, 0.5);
            pose.m_85841_(0.45f, 0.45f, 0.45f);
        } else if (transformType == ItemTransforms.TransformType.FIXED) {
            pose.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            pose.m_85837_(-0.5, -1.65, 0.5);
        } else if (transformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
            pose.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            pose.m_85837_(0.25, -1.0, -0.25);
            pose.m_85841_(0.45f, 0.45f, 0.45f);
            pose.m_85845_(Vector3f.f_122224_.m_122240_(25.0f));
        } else if (transformType == ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
            pose.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            pose.m_85837_(-0.6, -1.0, 0.25);
            pose.m_85841_(0.45f, 0.45f, 0.45f);
            pose.m_85845_(Vector3f.f_122225_.m_122240_(25.0f));
        } else if (transformType == ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
            pose.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            pose.m_85837_(0.5, -1.0, -0.4);
            pose.m_85841_(0.45f, 0.45f, 0.45f);
        } else if (transformType == ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
            pose.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            pose.m_85837_(-0.5, -1.0, 0.4);
            pose.m_85841_(0.45f, 0.45f, 0.45f);
        }
        RenderType renderType = RenderType.m_110470_((ResourceLocation)IFElements.INFUSION_STATION_BLOCK_TEXTURE);
        VertexConsumer modelBuffer = buffer.m_6299_(renderType);
        this.model.m_7695_(pose, modelBuffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.m_85836_();
        pose.m_85837_(0.0, 1.0, 0.0);
        renderType = RenderType.m_110470_((ResourceLocation)IFElements.INFUSION_STATION_BLOCK_TEXTURE_TINT);
        modelBuffer = buffer.m_6299_(renderType);
        this.model.renderToBufferTint(pose, modelBuffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f, true);
        pose.m_85849_();
        pose.m_85849_();
    }
}

