/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.infusedfoods.container;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import xyz.apex.forge.apexcore.revamp.block.entity.InventoryBlockEntity;
import xyz.apex.forge.apexcore.revamp.net.packet.SyncContainerPacket;
import xyz.apex.forge.infusedfoods.block.entity.InfusionStationBlockEntity;
import xyz.apex.forge.infusedfoods.init.IFElements;

public final class InfusionStationMenu
extends AbstractContainerMenu {
    public final Player player;
    public final IItemHandler itemHandler;
    private final BlockPos pos;
    public final InfusionStationBlockEntity blockEntity;

    public InfusionStationMenu(MenuType<?> menuType, int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        super(menuType, windowId);
        int i;
        this.pos = buffer.m_130135_();
        this.blockEntity = Objects.requireNonNull((InfusionStationBlockEntity)IFElements.INFUSION_STATION_BLOCK_ENTITY.getBlockEntity((BlockGetter)playerInventory.f_35978_.f_19853_, this.pos));
        this.itemHandler = (IItemHandler)this.blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseGet(() -> ((InfusionStationBlockEntity)this.blockEntity).getItemHandler());
        this.player = playerInventory.f_35978_;
        this.m_38897_((Slot)new PotionSlot());
        this.m_38897_((Slot)new BlazeSlot());
        this.m_38897_((Slot)new FoodSlot());
        this.m_38897_((Slot)new ResultSlot());
        this.m_38897_((Slot)new BottleSlot());
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public boolean m_6875_(Player player) {
        return player.m_6084_() && player.f_36096_ == this;
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot.m_6657_()) {
            ItemStack stack1 = slot.m_7993_();
            stack = stack1.m_41777_();
            int maxIndex = this.itemHandler.getSlots();
            if (slotIndex < maxIndex ? !this.m_38903_(stack1, maxIndex, this.f_38839_.size(), true) : !this.m_38903_(stack1, 0, maxIndex, false)) {
                return ItemStack.f_41583_;
            }
            if (stack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return stack;
    }

    public void m_38946_() {
        super.m_38946_();
        SyncContainerPacket.sendToClient((InventoryBlockEntity)this.blockEntity);
    }

    private final class PotionSlot
    extends SlotItemHandler {
        private PotionSlot() {
            super(InfusionStationMenu.this.itemHandler, 0, 27, 8);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            if (stack.m_41720_() != Items.f_42589_) {
                return false;
            }
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            return potion.m_43488_().size() == 1;
        }
    }

    private final class BlazeSlot
    extends SlotItemHandler {
        private BlazeSlot() {
            super(InfusionStationMenu.this.itemHandler, 1, 46, 8);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return stack.m_41720_() == Items.f_42593_;
        }
    }

    private final class FoodSlot
    extends SlotItemHandler {
        private FoodSlot() {
            super(InfusionStationMenu.this.itemHandler, 2, 90, 22);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            if (!stack.m_41614_()) {
                return false;
            }
            List customEffects = PotionUtils.m_43571_((ItemStack)stack);
            return customEffects.isEmpty();
        }
    }

    private final class ResultSlot
    extends SlotItemHandler {
        private ResultSlot() {
            super(InfusionStationMenu.this.itemHandler, 3, 134, 22);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return false;
        }
    }

    private final class BottleSlot
    extends SlotItemHandler {
        private BottleSlot() {
            super(InfusionStationMenu.this.itemHandler, 4, 8, 51);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return false;
        }
    }
}

