/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.builder;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Registry;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.PlayMessages;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.ItemBuilder;
import xyz.apex.forge.utility.registrator.builder.RegistratorBuilder;
import xyz.apex.forge.utility.registrator.entry.EntityEntry;
import xyz.apex.forge.utility.registrator.factory.EntityFactory;
import xyz.apex.forge.utility.registrator.factory.item.SpawnEggItemFactory;
import xyz.apex.forge.utility.registrator.helper.ForgeSpawnEggItem;
import xyz.apex.java.utility.nullness.NonnullBiConsumer;
import xyz.apex.java.utility.nullness.NonnullBiFunction;
import xyz.apex.java.utility.nullness.NonnullFunction;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.java.utility.nullness.NonnullUnaryOperator;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.loot.RegistrateEntityLootTables;
import xyz.apex.repack.com.tterrag.registrate.providers.loot.RegistrateLootTableProvider;
import xyz.apex.repack.com.tterrag.registrate.util.OneTimeEventReceiver;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public final class EntityBuilder<OWNER extends AbstractRegistrator<OWNER>, ENTITY extends Entity, PARENT>
extends RegistratorBuilder<OWNER, EntityType<?>, EntityType<ENTITY>, PARENT, EntityBuilder<OWNER, ENTITY, PARENT>, EntityEntry<ENTITY>> {
    public static final String SPAWN_EGG_SUFFIX = "_spawn_egg";
    private final MobCategory mobCategory;
    private final EntityFactory<ENTITY> entityFactory;
    private NonnullUnaryOperator<EntityType.Builder<ENTITY>> propertiesModifier = NonnullUnaryOperator.identity();
    @Nullable
    private NonnullSupplier<NonnullFunction<EntityRendererProvider.Context, EntityRenderer<? super ENTITY>>> renderer = null;
    @Nullable
    private NonnullSupplier<AttributeSupplier.Builder> attributes = null;
    @Nullable
    private SpawnPlacements.Type placementType = null;
    @Nullable
    private Heightmap.Types heightMapType = null;
    @Nullable
    private SpawnPlacements.SpawnPredicate<ENTITY> placementPredicate;
    @Nullable
    private ItemBuilder<OWNER, ?, EntityBuilder<OWNER, ENTITY, PARENT>> spawnEggBuilder = null;

    public EntityBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback, MobCategory mobCategory, EntityFactory<ENTITY> entityFactory) {
        super(owner, parent, registryName, callback, EntityType.class, EntityEntry::new, EntityEntry::cast);
        this.mobCategory = mobCategory;
        this.entityFactory = entityFactory;
        this.onRegister(this::onRegister);
        this.defaultLang();
    }

    @Override
    private void onRegister(EntityType<ENTITY> entityType) {
        if (this.renderer != null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> OneTimeEventReceiver.addModListener(EntityRenderersEvent.RegisterRenderers.class, event -> {
                try {
                    event.registerEntityRenderer(entityType, this.renderer.get()::apply);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to register renderer for Entity " + entityType.getRegistryName(), e);
                }
            }));
        }
        if (this.attributes != null) {
            OneTimeEventReceiver.addModListener(EntityAttributeCreationEvent.class, event -> event.put(entityType, this.attributes.get().m_22265_()));
        }
        if (this.placementType != null && this.heightMapType != null && this.placementPredicate != null) {
            EntityBuilder.registerSpawnPlacement(entityType, this.placementType, this.heightMapType, this.placementPredicate);
        }
    }

    @Override
    @NonnullType
    protected EntityType<ENTITY> createEntry() {
        if (this.spawnEggBuilder != null) {
            this.copyMappingsTo(this.spawnEggBuilder);
        }
        EntityType.Builder builder = EntityType.Builder.m_20704_(this.entityFactory::create, (MobCategory)this.mobCategory);
        builder = (EntityType.Builder)this.propertiesModifier.apply(builder);
        return builder.m_20712_(this.getRegistryNameFull());
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> properties(NonnullUnaryOperator<EntityType.Builder<ENTITY>> propertiesModifier) {
        this.propertiesModifier = this.propertiesModifier.andThen(propertiesModifier);
        return this;
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> sized(float width, float height) {
        return this.properties(properties -> properties.m_20699_(width, height));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> noSummon() {
        return this.properties(EntityType.Builder::m_20698_);
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> noSave() {
        return this.properties(EntityType.Builder::m_20716_);
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> fireImmune() {
        return this.properties(EntityType.Builder::m_20719_);
    }

    @Deprecated
    public EntityBuilder<OWNER, ENTITY, PARENT> immuneTo(Block ... blocks) {
        return this.properties(properties -> properties.m_20714_(blocks));
    }

    @SafeVarargs
    public final EntityBuilder<OWNER, ENTITY, PARENT> immuneTo(NonnullSupplier<? extends Block> ... blocks) {
        return this.properties(properties -> properties.m_20714_((Block[])Arrays.stream(blocks).map(Supplier::get).toArray(Block[]::new)));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> canSpawnFarFromPlayer() {
        return this.properties(EntityType.Builder::m_20720_);
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> clientTrackingRange(int clientTrackingRange) {
        return this.properties(properties -> properties.m_20702_(clientTrackingRange));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> updateInterval(int updateInterval) {
        return this.properties(properties -> properties.m_20717_(updateInterval));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> setUpdateInterval(int updateInterval) {
        return this.properties(properties -> properties.setUpdateInterval(updateInterval));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> setTrackingRange(int trackingRange) {
        return this.properties(properties -> properties.setTrackingRange(trackingRange));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> setShouldReceiveVelocityUpdates(boolean shouldReceiveVelocityUpdates) {
        return this.properties(properties -> properties.setShouldReceiveVelocityUpdates(shouldReceiveVelocityUpdates));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> setCustomClientFactory(NonnullBiFunction<PlayMessages.SpawnEntity, Level, ENTITY> customClientFactory) {
        return this.properties(properties -> properties.setCustomClientFactory((BiFunction)customClientFactory));
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> renderer(NonnullSupplier<NonnullFunction<EntityRendererProvider.Context, EntityRenderer<? super ENTITY>>> renderer) {
        this.renderer = renderer;
        return this;
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> attributes(NonnullSupplier<AttributeSupplier.Builder> attributes) {
        this.attributes = attributes;
        return this;
    }

    public <ITEM extends ForgeSpawnEggItem<ENTITY>> EntityBuilder<OWNER, ENTITY, PARENT> simpleSpawnEgg(int backgroundColor, int highlightColor, SpawnEggItemFactory<ENTITY, ITEM> itemFactory) {
        return (EntityBuilder)this.spawnEgg(backgroundColor, highlightColor, itemFactory).build();
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> simpleSpawnEgg(int backgroundColor, int highlightColor) {
        return this.simpleSpawnEgg(backgroundColor, highlightColor, SpawnEggItemFactory.forEntity());
    }

    public <ITEM extends ForgeSpawnEggItem<ENTITY>> ItemBuilder<OWNER, ITEM, EntityBuilder<OWNER, ENTITY, PARENT>> spawnEgg(int backgroundColor, int highlightColor, SpawnEggItemFactory<ENTITY, ITEM> itemFactory) {
        if (this.spawnEggBuilder == null) {
            this.spawnEggBuilder = this.owner.spawnEggItem(this.getRegistryName() + SPAWN_EGG_SUFFIX, this, this.toSupplier(), backgroundColor, highlightColor, itemFactory);
        }
        return this.spawnEggBuilder;
    }

    public ItemBuilder<OWNER, ForgeSpawnEggItem<ENTITY>, EntityBuilder<OWNER, ENTITY, PARENT>> spawnEgg(int backgroundColor, int highlightColor) {
        return this.spawnEgg(backgroundColor, highlightColor, SpawnEggItemFactory.forEntity());
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> spawnPlacement(SpawnPlacements.Type placementType, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<ENTITY> placementPredicate) {
        this.placementType = placementType;
        this.heightMapType = heightmapType;
        this.placementPredicate = placementPredicate;
        return this;
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> defaultLang() {
        return (EntityBuilder)this.lang(EntityType::m_20675_);
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> lang(String localizedValue) {
        return (EntityBuilder)this.lang(EntityType::m_20675_, localizedValue);
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> lang(String languageKey, String localizedValue) {
        return (EntityBuilder)this.lang(languageKey, EntityType::m_20675_, localizedValue);
    }

    public EntityBuilder<OWNER, ENTITY, PARENT> loot(NonnullBiConsumer<RegistrateEntityLootTables, EntityType<ENTITY>> consumer) {
        return (EntityBuilder)this.setDataGenerator(ProviderType.LOOT, (ctx, provider) -> provider.addLootAction(RegistrateLootTableProvider.LootType.ENTITY, lootTables -> consumer.accept((RegistrateEntityLootTables)lootTables, (EntityType)((EntityType)ctx.getEntry()))));
    }

    @SafeVarargs
    public final EntityBuilder<OWNER, ENTITY, PARENT> tag(Tag.Named<EntityType<?>> ... tags) {
        return (EntityBuilder)this.tag(ProviderType.ENTITY_TAGS, tags);
    }

    @SafeVarargs
    public final EntityBuilder<OWNER, ENTITY, PARENT> removeTag(Tag.Named<EntityType<?>> ... tags) {
        return (EntityBuilder)this.removeTags(ProviderType.ENTITY_TAGS, tags);
    }

    public static <ENTITY extends Entity> void registerSpawnPlacement(EntityType<ENTITY> entityType, SpawnPlacements.Type placementType, Heightmap.Types heightMapType, SpawnPlacements.SpawnPredicate<ENTITY> placementPredicate) {
        SpawnPlacements.Data entitySpawnPlacementRegistryEntry = SpawnPlacements.f_21750_.put(entityType, new SpawnPlacements.Data(heightMapType, placementType, placementPredicate));
        if (entitySpawnPlacementRegistryEntry != null) {
            throw new IllegalStateException("Duplicate registration for type " + Registry.f_122826_.m_7981_(entityType));
        }
    }
}

