/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.builder;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.data.SoundDefinition;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.RegistratorBuilder;
import xyz.apex.forge.utility.registrator.entry.SoundEntry;
import xyz.apex.java.utility.nullness.NonnullUnaryOperator;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public final class SoundBuilder<OWNER extends AbstractRegistrator<OWNER>, PARENT>
extends RegistratorBuilder<OWNER, SoundEvent, SoundEvent, PARENT, SoundBuilder<OWNER, PARENT>, SoundEntry> {
    private NonnullUnaryOperator<SoundDefinition> definitionModifier = NonnullUnaryOperator.identity();

    public SoundBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback) {
        super(owner, parent, registryName, callback, SoundEvent.class, SoundEntry::new, SoundEntry::cast);
        ((AbstractRegistrator)owner).addSoundGenerator(provider -> provider.add(this.getRegistryNameFull(), (SoundDefinition)this.definitionModifier.apply(SoundDefinition.definition())));
    }

    public SoundBuilder<OWNER, PARENT> properties(NonnullUnaryOperator<SoundDefinition> definitionModifier) {
        this.definitionModifier = this.definitionModifier.andThen(definitionModifier);
        return this;
    }

    public SoundBuilder<OWNER, PARENT> replace(boolean replace) {
        return this.properties(properties -> properties.replace(replace));
    }

    public SoundBuilder<OWNER, PARENT> subtitle(String subtitle) {
        return this.properties(properties -> properties.subtitle(subtitle));
    }

    public SoundBuilder<OWNER, PARENT> withSound(SoundDefinition.Sound sound) {
        return this.properties(properties -> properties.with(sound));
    }

    public SoundBuilder<OWNER, PARENT> withSound(SoundDefinition.Sound ... sounds) {
        return this.properties(properties -> properties.with(sounds));
    }

    public SoundBuilder<OWNER, PARENT> withSound(ResourceLocation soundName, SoundDefinition.SoundType soundType, NonnullUnaryOperator<SoundDefinition.Sound> soundModifier) {
        return this.withSound((SoundDefinition.Sound)soundModifier.apply(SoundDefinition.Sound.sound((ResourceLocation)soundName, (SoundDefinition.SoundType)soundType)));
    }

    public SoundBuilder<OWNER, PARENT> withSound(ResourceLocation soundName, NonnullUnaryOperator<SoundDefinition.Sound> soundModifier) {
        return this.withSound(soundName, SoundDefinition.SoundType.SOUND, soundModifier);
    }

    public SoundBuilder<OWNER, PARENT> withSimpleSound(ResourceLocation soundName, SoundDefinition.SoundType soundType) {
        return this.withSound(soundName, soundType, sound -> sound.volume(1.0f).pitch(1.0f).weight(1).stream(false).preload(false).attenuationDistance(16));
    }

    public SoundBuilder<OWNER, PARENT> withSimpleSound(ResourceLocation soundName) {
        return this.withSimpleSound(soundName, SoundDefinition.SoundType.SOUND);
    }

    public SoundBuilder<OWNER, PARENT> withSound(String soundName, SoundDefinition.SoundType soundType, NonnullUnaryOperator<SoundDefinition.Sound> soundModifier) {
        return this.withSound(this.owner.id(soundName), soundType, soundModifier);
    }

    public SoundBuilder<OWNER, PARENT> withSound(String soundName, NonnullUnaryOperator<SoundDefinition.Sound> soundModifier) {
        return this.withSound(this.owner.id(soundName), soundModifier);
    }

    public SoundBuilder<OWNER, PARENT> withSimpleSound(String soundName, SoundDefinition.SoundType soundType) {
        return this.withSimpleSound(this.owner.id(soundName), soundType);
    }

    public SoundBuilder<OWNER, PARENT> withSimpleSound(String soundName) {
        return this.withSimpleSound(this.owner.id(soundName));
    }

    @Override
    @NonnullType
    protected SoundEvent createEntry() {
        return new SoundEvent(this.owner.id(this.getRegistryName()));
    }
}

