/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.helper;

import java.lang.reflect.Field;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import xyz.apex.java.utility.nullness.NonnullSupplier;

public class ForgeSpawnEggItem<ENTITY extends Entity>
extends SpawnEggItem {
    private static final Field EGGS = ObfuscationReflectionHelper.findField(SpawnEggItem.class, (String)"BY_ID");
    private static final DispenseItemBehavior DEFAULT_DISPENSE_BEHAVIOR = (source, stack) -> {
        Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
        EntityType entityType = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
        try {
            entityType.m_20592_(source.m_7727_(), stack, null, source.m_7961_().m_142300_(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
        }
        catch (Exception e) {
            LogManager.getLogger().error("Error while dispensing spawn egg from dispenser at {}", (Object)source.m_7961_(), (Object)e);
            return ItemStack.f_41583_;
        }
        stack.m_41774_(1);
        source.m_7727_().m_151555_(GameEvent.f_157810_, source.m_7961_());
        return stack;
    };
    private boolean registered = false;
    private final NonnullSupplier<EntityType<ENTITY>> entityTypeSupplier;

    public ForgeSpawnEggItem(NonnullSupplier<EntityType<ENTITY>> entityTypeSupplier, int backgroundColor, int highlightColor, Item.Properties properties) {
        super(null, backgroundColor, highlightColor, properties);
        this.entityTypeSupplier = entityTypeSupplier;
    }

    public EntityType<?> m_43228_(@Nullable CompoundTag tag) {
        EntityType<ENTITY> entityType = super.m_43228_(tag);
        return entityType == null ? this.entityTypeSupplier.get() : entityType;
    }

    @Nullable
    protected DispenseItemBehavior getDispenserBehavior() {
        return DEFAULT_DISPENSE_BEHAVIOR;
    }

    @Deprecated
    public final void registerSpawnEggProperties() {
        if (this.registered) {
            return;
        }
        try {
            Map eggs = (Map)EGGS.get((Object)this);
            eggs.put(this.entityTypeSupplier.get(), this);
            this.registered = true;
            DispenseItemBehavior dispenserBehavior = this.getDispenserBehavior();
            if (dispenserBehavior != null) {
                DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)dispenserBehavior);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getSpawnEggColor(ItemStack stack, int tintIndex) {
        int n;
        Item item = stack.m_41720_();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem spawnegg = (SpawnEggItem)item;
            n = spawnegg.m_43211_(tintIndex);
        } else {
            n = 0;
        }
        return n;
    }
}

