/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.EffectRenderer;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.RenderProperties;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.Validate;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.apex.forge.apexcore.lib.item.ItemGroupCategory;
import xyz.apex.forge.apexcore.lib.item.ItemGroupCategoryManager;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="apexcore", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class CreativeScreenHandler {
    private static final ResourceLocation CATEGORY_TABS_TEXTURE = new ResourceLocation("apexcore", "textures/gui/container/creative_inventory/category_tabs.png");
    private static final int MAX_CATEGORY_TAB = 4;
    private static final int CATEGORY_TAB_U_SIZE = 32;
    private static final int CATEGORY_TAB_V_SIZE = 28;
    private static final int CATEGORY_TABS_TEXTURE_WIDTH = 64;
    private static final int CATEGORY_TABS_TEXTURE_HEIGHT = 28;
    private static int categoryTabPage = 0;
    private static int maxCategoryTabPages = 0;
    @Nullable
    private static Button buttonPreviousCategoryPage;
    @Nullable
    private static Button buttonNextCategoryPage;

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.InitScreenEvent event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen screen2 = (CreativeModeInventoryScreen)screen;
            buttonNextCategoryPage = new Button(0, 0, 1, 1, (Component)new TextComponent("V"), b -> {
                categoryTabPage = Math.min(categoryTabPage + 1, maxCategoryTabPages);
            });
            CreativeScreenHandler.buttonNextCategoryPage.f_93623_ = false;
            CreativeScreenHandler.buttonNextCategoryPage.f_93624_ = false;
            event.addListener((GuiEventListener)buttonNextCategoryPage);
            buttonPreviousCategoryPage = new Button(0, 0, 1, 1, (Component)new TextComponent("^"), b -> {
                categoryTabPage = Math.max(categoryTabPage - 1, 0);
            });
            CreativeScreenHandler.buttonPreviousCategoryPage.f_93623_ = false;
            CreativeScreenHandler.buttonPreviousCategoryPage.f_93624_ = false;
            event.addListener((GuiEventListener)buttonPreviousCategoryPage);
            CreativeModeTab selectedTab = CreativeScreenHandler.getSelectedTab(screen2);
            CreativeScreenHandler.updatePages(screen2, selectedTab);
        }
    }

    private static void updatePages(CreativeModeInventoryScreen screen, @Nullable CreativeModeTab itemGroup) {
        ItemGroupCategoryManager manager;
        Set<ItemGroupCategory> categories;
        int tabCount;
        Validate.notNull((Object)buttonPreviousCategoryPage);
        Validate.notNull((Object)buttonNextCategoryPage);
        int leftPos = screen.getGuiLeft();
        int topPos = screen.getGuiTop();
        int buttonSize = 20;
        CreativeScreenHandler.buttonPreviousCategoryPage.f_93620_ = leftPos - 64 + 7;
        CreativeScreenHandler.buttonPreviousCategoryPage.f_93621_ = topPos + 2;
        buttonPreviousCategoryPage.m_93674_(buttonSize);
        buttonPreviousCategoryPage.setHeight(buttonSize);
        CreativeScreenHandler.buttonNextCategoryPage.f_93620_ = CreativeScreenHandler.buttonPreviousCategoryPage.f_93620_;
        CreativeScreenHandler.buttonNextCategoryPage.f_93621_ = CreativeScreenHandler.buttonPreviousCategoryPage.f_93621_ + 96;
        buttonNextCategoryPage.m_93674_(buttonSize);
        buttonNextCategoryPage.setHeight(buttonSize);
        maxCategoryTabPages = 0;
        if (CreativeScreenHandler.isSupportedTab(itemGroup) && (tabCount = (categories = (manager = ItemGroupCategoryManager.getInstance(itemGroup)).getCategories()).size()) > 4) {
            maxCategoryTabPages = (int)Math.ceil((double)(tabCount - 4) / 2.0);
        }
    }

    public static void selectTab_FilterItems(CreativeModeInventoryScreen screen, CreativeModeTab itemGroup) {
        if (CreativeScreenHandler.isSupportedTab(itemGroup)) {
            ItemGroupCategoryManager.getInstance(itemGroup).applyFilter((NonNullList<ItemStack>)((CreativeModeInventoryScreen.ItemPickerMenu)screen.m_6262_()).f_98639_);
        }
    }

    public static void selectTab_Head(CreativeModeInventoryScreen screen, CreativeModeTab itemGroup) {
        CreativeModeTab selectedTab = CreativeScreenHandler.getSelectedTab(screen);
        if (CreativeScreenHandler.isSupportedTab(selectedTab)) {
            ItemGroupCategoryManager.getInstance(selectedTab).disableCategories();
            categoryTabPage = 0;
        }
        CreativeScreenHandler.updatePages(screen, itemGroup);
    }

    public static void renderBg(CreativeModeInventoryScreen screen, PoseStack pose) {
        CreativeModeTab selectedTab = CreativeScreenHandler.getSelectedTab(screen);
        if (!CreativeScreenHandler.isSupportedTab(selectedTab)) {
            return;
        }
        CreativeScreenHandler.renderTabButton(screen, pose, selectedTab, false);
        CreativeScreenHandler.renderTabButton(screen, pose, selectedTab, true);
    }

    public static void render(CreativeModeInventoryScreen screen, PoseStack pose) {
        if (maxCategoryTabPages == 0) {
            return;
        }
        CreativeModeTab selectedTab = CreativeScreenHandler.getSelectedTab(screen);
        if (!CreativeScreenHandler.isSupportedTab(selectedTab)) {
            return;
        }
        if (buttonPreviousCategoryPage == null || buttonNextCategoryPage == null) {
            return;
        }
        if (!CreativeScreenHandler.buttonPreviousCategoryPage.f_93624_) {
            return;
        }
        Minecraft minecraft = screen.getMinecraft();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        Font font = minecraft.f_91062_;
        screen.m_93250_(300);
        itemRenderer.f_115093_ = 300.0f;
        int maxLineWidth = 6;
        int x = CreativeScreenHandler.buttonPreviousCategoryPage.f_93620_ + (buttonPreviousCategoryPage.m_5711_() / 2 - maxLineWidth / 2);
        int fontColor = buttonPreviousCategoryPage.getFGColor();
        int nextY = CreativeScreenHandler.buttonNextCategoryPage.f_93621_;
        int nextHeight = buttonNextCategoryPage.m_93694_();
        int previousY = CreativeScreenHandler.buttonPreviousCategoryPage.f_93621_;
        int previousHeight = buttonPreviousCategoryPage.m_93694_();
        int yTop = previousY + previousHeight;
        int yBottom = nextY;
        int yDist = yBottom - yTop;
        float f = yTop;
        Objects.requireNonNull(font);
        float y = f - 9.0f / 2.0f + (float)yDist / 2.0f;
        String string = "" + (categoryTabPage + 1);
        float f2 = x;
        Objects.requireNonNull(font);
        font.m_92750_(pose, string, f2, y - 9.0f, fontColor);
        font.m_92750_(pose, "/", (float)x, y, fontColor);
        String string2 = "" + (maxCategoryTabPages + 1);
        float f3 = x;
        Objects.requireNonNull(font);
        font.m_92750_(pose, string2, f3, y + 9.0f, fontColor);
        screen.m_93250_(0);
        itemRenderer.f_115093_ = 0.0f;
    }

    private static void renderTabButton(CreativeModeInventoryScreen screen, PoseStack pose, CreativeModeTab itemGroup, boolean enabled) {
        if (!CreativeScreenHandler.isSupportedTab(itemGroup)) {
            return;
        }
        if (!CreativeScreenHandler.isSelectedTab(screen, itemGroup)) {
            return;
        }
        ItemGroupCategoryManager manager = ItemGroupCategoryManager.getInstance(itemGroup);
        Minecraft minecraft = screen.getMinecraft();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        TextureManager textureManager = minecraft.m_91097_();
        int tabIndex = 0;
        int tabsInteracted = 0;
        for (ItemGroupCategory category : manager.getCategories()) {
            if (tabsInteracted >= 4) break;
            if (manager.isCategoryEnabled(category)) {
                if (!enabled) {
                    ++tabIndex;
                    continue;
                }
            } else if (enabled) {
                ++tabIndex;
                continue;
            }
            if (categoryTabPage == CreativeScreenHandler.getTabPage(tabIndex)) {
                int u = CreativeScreenHandler.getTabU(manager, category);
                int x = CreativeScreenHandler.getTabX(screen);
                int y = CreativeScreenHandler.getTabY(screen, tabIndex);
                RenderSystem.m_157456_((int)0, (ResourceLocation)CATEGORY_TABS_TEXTURE);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_69478_();
                GuiComponent.m_93143_((PoseStack)pose, (int)x, (int)y, (int)screen.m_93252_(), (float)u, (float)0.0f, (int)32, (int)28, (int)28, (int)64);
                itemRenderer.f_115093_ = 100.0f;
                int iconX = x + 8;
                int iconY = y + 6;
                ItemStack icon = category.getCategoryIcon(itemGroup);
                itemRenderer.m_115203_(icon, iconX, iconY);
                itemRenderer.m_115169_(minecraft.f_91062_, icon, iconX, iconY);
                itemRenderer.f_115093_ = 0.0f;
                ++tabsInteracted;
            }
            ++tabIndex;
        }
    }

    public static void mouseClicked(CreativeModeInventoryScreen screen, double mouseX, double mouseY, int mouseButton, CallbackInfoReturnable<Boolean> cir) {
        CreativeModeTab selectedTab = CreativeScreenHandler.getSelectedTab(screen);
        if (!CreativeScreenHandler.isSupportedTab(selectedTab)) {
            return;
        }
        if (!CreativeScreenHandler.isSelectedTab(screen, selectedTab)) {
            return;
        }
        if (mouseButton != 0) {
            return;
        }
        Set<ItemGroupCategory> categories = ItemGroupCategoryManager.getInstance(selectedTab).getCategories();
        int tabsInteracted = 0;
        for (int tabIndex = 0; tabIndex < categories.size() && tabsInteracted < 4; ++tabIndex) {
            if (categoryTabPage != CreativeScreenHandler.getTabPage(tabIndex)) continue;
            int x = CreativeScreenHandler.getTabX(screen);
            int y = CreativeScreenHandler.getTabY(screen, tabIndex);
            if (mouseX >= (double)x && mouseX <= (double)(x + 32) && mouseY >= (double)y && mouseY <= (double)(y + 28)) {
                cir.setReturnValue((Object)true);
                return;
            }
            ++tabsInteracted;
        }
    }

    public static void mouseReleased(CreativeModeInventoryScreen screen, double mouseX, double mouseY, int mouseButton, Consumer<Float> scrollOffsModifier, CallbackInfoReturnable<Boolean> cir) {
        CreativeModeTab selectedTab = CreativeScreenHandler.getSelectedTab(screen);
        if (!CreativeScreenHandler.isSupportedTab(selectedTab)) {
            return;
        }
        if (mouseButton != 0) {
            return;
        }
        ItemGroupCategoryManager manager = ItemGroupCategoryManager.getInstance(selectedTab);
        int tabIndex = 0;
        int tabsInteracted = 0;
        for (ItemGroupCategory category : manager.getCategories()) {
            if (tabsInteracted >= 4) break;
            if (categoryTabPage == CreativeScreenHandler.getTabPage(tabIndex)) {
                int tabX = CreativeScreenHandler.getTabX(screen);
                int tabY = CreativeScreenHandler.getTabY(screen, tabIndex);
                if (mouseX >= (double)tabX && mouseX <= (double)(tabX + 32) && mouseY >= (double)tabY && mouseY <= (double)(tabY + 28)) {
                    CreativeModeInventoryScreen.ItemPickerMenu menu = (CreativeModeInventoryScreen.ItemPickerMenu)screen.m_6262_();
                    manager.toggleCategory(category);
                    manager.applyFilter((NonNullList<ItemStack>)menu.f_98639_);
                    menu.m_98642_(0.0f);
                    scrollOffsModifier.accept(Float.valueOf(0.0f));
                    cir.setReturnValue((Object)true);
                    return;
                }
                ++tabsInteracted;
            }
            ++tabIndex;
        }
    }

    public static void checkTabHovering(CreativeModeInventoryScreen screen, PoseStack pose, CreativeModeTab itemGroup, int mouseX, int mouseY, CallbackInfoReturnable<Boolean> cir) {
        if (!CreativeScreenHandler.isSupportedTab(itemGroup)) {
            return;
        }
        if (!CreativeScreenHandler.isSelectedTab(screen, itemGroup)) {
            return;
        }
        ItemGroupCategoryManager manager = ItemGroupCategoryManager.getInstance(itemGroup);
        int tabIndex = 0;
        int tabsInteracted = 0;
        for (ItemGroupCategory category : manager.getCategories()) {
            if (tabsInteracted >= 4) break;
            if (categoryTabPage == CreativeScreenHandler.getTabPage(tabIndex)) {
                int tabX = CreativeScreenHandler.getTabX(screen);
                int tabY = CreativeScreenHandler.getTabY(screen, tabIndex);
                if (mouseX >= tabX && mouseX <= tabX + 32 && mouseY >= tabY && mouseY <= tabY + 28) {
                    Component categoryName = category.getCategoryName();
                    screen.m_96602_(pose, categoryName, mouseX, mouseY);
                    cir.setReturnValue((Object)true);
                    return;
                }
                ++tabsInteracted;
            }
            ++tabIndex;
        }
    }

    public static void tick(CreativeModeInventoryScreen screen, int tabPage) {
        if (screen.getMinecraft().f_91072_ != null && !screen.getMinecraft().f_91072_.m_105290_()) {
            return;
        }
        CreativeModeTab selectedTab = CreativeScreenHandler.getSelectedTab(screen);
        CreativeScreenHandler.updateButtonState(screen, selectedTab, tabPage, true);
        CreativeScreenHandler.updateButtonState(screen, selectedTab, tabPage, false);
        if (!CreativeScreenHandler.isSupportedTab(selectedTab)) {
            return;
        }
        if (!CreativeScreenHandler.isSelectedTab(screen, selectedTab)) {
            return;
        }
        boolean cycleIcons = !Screen.m_96638_();
        ItemGroupCategoryManager.getInstance(selectedTab).getCategories().forEach(c -> c.tick(cycleIcons));
    }

    public static boolean checkEffectRendering(CreativeModeInventoryScreen screen, PoseStack pose, int leftPos) {
        ItemGroupCategoryManager manager;
        CreativeModeTab itemGroup;
        Minecraft mc = screen.getMinecraft();
        if (mc.f_91074_ != null && CreativeScreenHandler.isSupportedTab(itemGroup = CreativeScreenHandler.getSelectedTab(screen)) && !(manager = ItemGroupCategoryManager.getInstance(itemGroup)).getCategories().isEmpty()) {
            Collection effects = mc.f_91074_.m_21220_();
            if (!effects.isEmpty()) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int effectCount = effects.size();
                int renderX = leftPos - 150;
                int renderY = 33;
                if (effectCount > 5) {
                    renderY = 132 / (effectCount - 1);
                }
                List<MobEffectInstance> effectsToRender = effects.stream().filter(ForgeHooksClient::shouldRenderEffect).sorted().collect(Collectors.toList());
                CreativeScreenHandler.renderEffectBackgrounds(screen, pose, renderX, renderY, effectsToRender);
                CreativeScreenHandler.renderEffectIcons(screen, pose, renderX, renderY, effectsToRender);
                CreativeScreenHandler.renderEffectLabels(screen, pose, renderX, renderY, effectsToRender);
            }
            return true;
        }
        return false;
    }

    private static void updateButtonState(CreativeModeInventoryScreen screen, @Nullable CreativeModeTab selectedTab, int tabPage, boolean isNext) {
        boolean isVisible = false;
        boolean isActive = false;
        if (maxCategoryTabPages > 0 && CreativeScreenHandler.isSupportedTab(selectedTab) && CreativeScreenHandler.isSelectedTab(screen, selectedTab) && tabPage == selectedTab.getTabPage()) {
            isVisible = true;
            if (isNext) {
                if (categoryTabPage <= maxCategoryTabPages - 1) {
                    isActive = true;
                }
            } else if (categoryTabPage - 1 >= 0) {
                isActive = true;
            }
        }
        if (!isVisible) {
            isActive = false;
        }
        if (isActive) {
            isVisible = true;
        }
        if (isNext) {
            if (buttonNextCategoryPage != null) {
                CreativeScreenHandler.buttonNextCategoryPage.f_93624_ = isVisible;
                CreativeScreenHandler.buttonNextCategoryPage.f_93623_ = isActive;
            }
        } else if (buttonPreviousCategoryPage != null) {
            CreativeScreenHandler.buttonPreviousCategoryPage.f_93624_ = isVisible;
            CreativeScreenHandler.buttonPreviousCategoryPage.f_93623_ = isActive;
        }
    }

    private static int getTabPage(int tabIndex) {
        if (tabIndex < 4) {
            return 0;
        }
        return (tabIndex - 4) / 2 + 1;
    }

    private static int getTabU(ItemGroupCategoryManager manager, ItemGroupCategory category) {
        return manager.isCategoryEnabled(category) ? 32 : 0;
    }

    private static int getTabX(CreativeModeInventoryScreen screen) {
        return screen.getGuiLeft() - 32 + 4;
    }

    private static int getTabY(CreativeModeInventoryScreen screen, int tabIndex) {
        int offset = tabIndex % 4 * 28;
        return screen.getGuiTop() + offset + 12;
    }

    @Nullable
    private static CreativeModeTab getSelectedTab(CreativeModeInventoryScreen screen) {
        int selectedTab = screen.m_98628_();
        if (selectedTab == -1) {
            return null;
        }
        return CreativeModeTab.f_40748_[selectedTab];
    }

    private static boolean isSelectedTab(CreativeModeInventoryScreen screen, CreativeModeTab itemGroup) {
        return screen.m_98628_() == itemGroup.m_40775_();
    }

    private static boolean isSupportedTab(@Nullable CreativeModeTab itemGroup) {
        if (itemGroup == null) {
            return false;
        }
        if (CreativeScreenHandler.matches(itemGroup, CreativeModeTab.f_40761_)) {
            return false;
        }
        if (CreativeScreenHandler.matches(itemGroup, CreativeModeTab.f_40760_)) {
            return false;
        }
        if (CreativeScreenHandler.matches(itemGroup, CreativeModeTab.f_40754_)) {
            return false;
        }
        return !ItemGroupCategoryManager.getInstance(itemGroup).getCategories().isEmpty();
    }

    private static boolean matches(CreativeModeTab a, CreativeModeTab b) {
        return a.m_40775_() == b.m_40775_();
    }

    private static void renderEffectBackgrounds(CreativeModeInventoryScreen screen, PoseStack pose, int renderX, int renderY, Iterable<MobEffectInstance> effects) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractContainerScreen.f_97725_);
        int i = screen.getGuiTop();
        for (MobEffectInstance effect : effects) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            screen.m_93228_(pose, renderX, i, 0, 166, 140, 32);
            i += renderY;
        }
    }

    private static void renderEffectIcons(CreativeModeInventoryScreen screen, PoseStack pose, int renderX, int renderY, Iterable<MobEffectInstance> effects) {
        Minecraft mc = screen.getMinecraft();
        MobEffectTextureManager spriteUploader = mc.m_91306_();
        int i = screen.getGuiTop();
        int blitOffset = screen.m_93252_();
        for (MobEffectInstance instance : effects) {
            MobEffect effect = instance.m_19544_();
            TextureAtlasSprite sprite = spriteUploader.m_118732_(effect);
            RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.m_118414_().m_118330_());
            GuiComponent.m_93200_((PoseStack)pose, (int)(renderX + 6), (int)(i + 7), (int)blitOffset, (int)18, (int)18, (TextureAtlasSprite)sprite);
            i += renderY;
        }
    }

    private static void renderEffectLabels(CreativeModeInventoryScreen screen, PoseStack pose, int renderX, int renderY, Iterable<MobEffectInstance> effects) {
        Minecraft mc = screen.getMinecraft();
        int i = screen.getGuiTop();
        int blitOffset = screen.m_93252_();
        for (MobEffectInstance effect : effects) {
            EffectRenderer effectRenderer = RenderProperties.getEffectRenderer((MobEffectInstance)effect);
            effectRenderer.renderInventoryEffect(effect, (EffectRenderingInventoryScreen)screen, pose, renderX, i, (float)blitOffset);
            if (effectRenderer.shouldRenderInvText(effect)) {
                Object s = I18n.m_118938_((String)effect.m_19544_().m_19481_(), (Object[])new Object[0]);
                int amplifier = effect.m_19564_();
                if (amplifier >= 1 && amplifier <= 9) {
                    s = (String)s + " " + I18n.m_118938_((String)("enchantment.level." + (amplifier + 1)), (Object[])new Object[0]);
                }
                mc.f_91062_.m_92750_(pose, (String)s, (float)(renderX + 10 + 18), (float)(i + 6), 0xFFFFFF);
                s = MobEffectUtil.m_19581_((MobEffectInstance)effect, (float)1.0f);
                mc.f_91062_.m_92750_(pose, (String)s, (float)(renderX + 10 + 18), (float)(i + 6 + 10), 0x7F7F7F);
            }
            i += renderY;
        }
    }
}

