/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.client.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import xyz.apex.forge.apexcore.core.block.entity.PlayerPlushieBlockEntity;
import xyz.apex.forge.apexcore.core.client.renderer.PlayerPlushieBlockEntityRenderer;
import xyz.apex.forge.apexcore.core.init.PlayerPlushie;
import xyz.apex.forge.apexcore.lib.support.SupporterManager;

public final class ApexCoreItemStackBlockEntityRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final Lazy<BlockEntityWithoutLevelRenderer> INSTANCE = Lazy.of(() -> new ApexCoreItemStackBlockEntityRenderer(Minecraft.m_91087_()));
    private final PlayerPlushieBlockEntityRenderer playerPlushieBlockEntityRenderer;
    private final Map<UUID, PlayerPlushieBlockEntity> playerPlushieBlockEntityMap = Maps.newHashMap();

    private ApexCoreItemStackBlockEntityRenderer(Minecraft mc) {
        super(mc.m_167982_(), mc.m_167973_());
        BlockEntityRendererProvider.Context ctx = new BlockEntityRendererProvider.Context(mc.m_167982_(), mc.m_91289_(), mc.m_167973_(), mc.f_91062_);
        this.playerPlushieBlockEntityRenderer = new PlayerPlushieBlockEntityRenderer(ctx);
    }

    public void m_108829_(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack pose, MultiBufferSource renderTypeBuffer, int light, int overlay) {
        PlayerPlushieBlockEntity blockEntity;
        SupporterManager.SupporterInfo supporterInfo;
        float partialTick = Minecraft.m_91087_().m_91297_();
        if (PlayerPlushie.PLAYER_PLUSHIE_BLOCK.isInStack(stack) && (supporterInfo = PlayerPlushie.getSupporterInfo(stack)) != null && (blockEntity = this.getPlayerPlushieBlockEntity(supporterInfo)) != null) {
            this.playerPlushieBlockEntityRenderer.renderLayers = false;
            this.playerPlushieBlockEntityRenderer.render(blockEntity, partialTick, pose, renderTypeBuffer, light, overlay);
            return;
        }
        super.m_108829_(stack, transformType, pose, renderTypeBuffer, light, overlay);
    }

    @Nullable
    private PlayerPlushieBlockEntity getPlayerPlushieBlockEntity(SupporterManager.SupporterInfo supporterInfo) {
        UUID playerId = supporterInfo.getPlayerId();
        if (this.playerPlushieBlockEntityMap.containsKey(playerId)) {
            return this.playerPlushieBlockEntityMap.get(playerId);
        }
        BlockState blockState = PlayerPlushie.PLAYER_PLUSHIE_BLOCK.defaultBlockState();
        PlayerPlushieBlockEntity blockEntity = (PlayerPlushieBlockEntity)PlayerPlushie.PLAYER_PLUSHIE_BLOCK_ENTITY.createBlockEntity(BlockPos.f_121853_, blockState);
        if (blockEntity != null) {
            blockEntity.setSupporterInfo(supporterInfo);
            this.playerPlushieBlockEntityMap.put(playerId, blockEntity);
            return blockEntity;
        }
        return null;
    }

    public static BlockEntityWithoutLevelRenderer getInstance() {
        return (BlockEntityWithoutLevelRenderer)INSTANCE.get();
    }
}

