/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.client.renderer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xyz.apex.forge.apexcore.core.block.PlayerPlushieBlock;
import xyz.apex.forge.apexcore.core.block.entity.PlayerPlushieBlockEntity;
import xyz.apex.forge.apexcore.lib.support.SupporterManager;
import xyz.apex.forge.apexcore.lib.util.ProfileHelper;
import xyz.apex.forge.apexcore.lib.util.SkinHelper;
import xyz.apex.forge.apexcore.lib.util.reflection.MethodHelper;

public class PlayerPlushieBlockEntityRenderer
implements BlockEntityRenderer<PlayerPlushieBlockEntity> {
    private final PlayerModel<Player> playerModelSlim;
    private final Iterable<ModelPart> headPartsSlim;
    private final Iterable<ModelPart> bodyPartsSlim;
    private final PlayerModel<Player> playerModelThick;
    private final Iterable<ModelPart> headPartsThick;
    private final Iterable<ModelPart> bodyPartsThick;
    private final Map<UUID, ResourceLocation> playerSkins = Maps.newHashMap();
    public boolean renderLayers = true;

    public PlayerPlushieBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.playerModelSlim = this.bakePlayerModel(ctx, true);
        this.playerModelThick = this.bakePlayerModel(ctx, false);
        this.headPartsSlim = PlayerPlushieBlockEntityRenderer.getHeadParts(this.playerModelSlim);
        this.headPartsThick = PlayerPlushieBlockEntityRenderer.getHeadParts(this.playerModelThick);
        this.bodyPartsSlim = PlayerPlushieBlockEntityRenderer.getBodyParts(this.playerModelSlim);
        this.bodyPartsThick = PlayerPlushieBlockEntityRenderer.getBodyParts(this.playerModelThick);
    }

    private PlayerModel<Player> bakePlayerModel(BlockEntityRendererProvider.Context ctx, boolean slim) {
        return new PlayerModel(ctx.m_173582_(slim ? ModelLayers.f_171166_ : ModelLayers.f_171162_), slim);
    }

    public void render(PlayerPlushieBlockEntity blockEntity, float partialTick, PoseStack pose, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay) {
        Iterable<ModelPart> bodyParts;
        Iterable<ModelPart> headParts;
        PlayerModel<Player> playerModel;
        String playerName;
        UUID playerId;
        SupporterManager.SupporterInfo supporterInfo = blockEntity.getSupporterInfo();
        if (supporterInfo == null) {
            playerId = ProfileHelper.DUMMY_PROFILE.getId();
            playerName = ProfileHelper.DUMMY_PROFILE.getName();
        } else {
            playerId = supporterInfo.getPlayerId();
            playerName = supporterInfo.getUsername();
        }
        SkinHelper.getSkins(playerId, playerName, texture -> this.playerSkins.put(playerId, (ResourceLocation)texture));
        if (SkinHelper.isSlim(playerId, playerName)) {
            playerModel = this.playerModelSlim;
            headParts = this.headPartsSlim;
            bodyParts = this.bodyPartsSlim;
        } else {
            playerModel = this.playerModelThick;
            headParts = this.headPartsThick;
            bodyParts = this.bodyPartsThick;
        }
        ResourceLocation skin = this.playerSkins.containsKey(playerId) ? this.playerSkins.get(playerId) : DefaultPlayerSkin.m_118627_((UUID)playerId);
        RenderType renderType = RenderType.m_110473_((ResourceLocation)skin);
        VertexConsumer buffer = renderTypeBuffer.m_6299_(renderType);
        pose.m_85836_();
        PlayerPlushieBlockEntityRenderer.setupPlayerModel(playerModel, this.renderLayers);
        PlayerPlushieBlockEntityRenderer.renderPlayerModel(blockEntity, playerModel, headParts, bodyParts, pose, buffer, combinedLight, combinedOverlay);
        pose.m_85849_();
    }

    private static void poseForPlushie(PlayerModel<Player> playerModel) {
        playerModel.f_102808_.f_104203_ = 0.0f;
        playerModel.f_102808_.f_104204_ = 0.0f;
        playerModel.f_102808_.f_104205_ = 0.0f;
        playerModel.f_102810_.f_104203_ = -0.4f;
        playerModel.f_102810_.f_104204_ = 0.0f;
        playerModel.f_102810_.f_104205_ = 0.0f;
        playerModel.f_102812_.f_104203_ = 0.0f;
        playerModel.f_102812_.f_104204_ = 0.0f;
        playerModel.f_102812_.f_104205_ = -0.5f;
        playerModel.f_102811_.f_104203_ = 0.0f;
        playerModel.f_102811_.f_104204_ = 0.0f;
        playerModel.f_102811_.f_104205_ = 0.5f;
        playerModel.f_102814_.f_104203_ = -1.6f;
        playerModel.f_102814_.f_104204_ = -0.5f;
        playerModel.f_102814_.f_104205_ = 0.0f;
        playerModel.f_102813_.f_104203_ = -1.6f;
        playerModel.f_102813_.f_104204_ = 0.5f;
        playerModel.f_102813_.f_104205_ = 0.0f;
        playerModel.f_102808_.f_104200_ = 0.0f;
        playerModel.f_102808_.f_104201_ = 0.0f;
        playerModel.f_102808_.f_104202_ = 0.0f;
        playerModel.f_102810_.f_104200_ = 0.0f;
        playerModel.f_102810_.f_104201_ = 0.0f;
        playerModel.f_102810_.f_104202_ = 0.0f;
        playerModel.f_102812_.f_104200_ = 4.1f;
        playerModel.f_102812_.f_104201_ = 2.0f;
        playerModel.f_102812_.f_104202_ = 0.0f;
        playerModel.f_102811_.f_104200_ = -4.2f;
        playerModel.f_102811_.f_104201_ = 2.0f;
        playerModel.f_102811_.f_104202_ = 0.0f;
        playerModel.f_102814_.f_104200_ = 1.0f;
        playerModel.f_102814_.f_104201_ = 12.0f;
        playerModel.f_102814_.f_104202_ = -3.5f;
        playerModel.f_102813_.f_104200_ = -1.0f;
        playerModel.f_102813_.f_104201_ = 12.0f;
        playerModel.f_102813_.f_104202_ = -3.0f;
    }

    private static void setupPlayerModel(PlayerModel<Player> playerModel, boolean renderLayers) {
        playerModel.m_8009_(true);
        playerModel.f_102817_ = false;
        playerModel.f_102610_ = true;
        PlayerPlushieBlockEntityRenderer.poseForPlushie(playerModel);
        playerModel.f_103376_.m_104315_(playerModel.f_102814_);
        playerModel.f_103377_.m_104315_(playerModel.f_102813_);
        playerModel.f_103374_.m_104315_(playerModel.f_102812_);
        playerModel.f_103375_.m_104315_(playerModel.f_102811_);
        playerModel.f_103378_.m_104315_(playerModel.f_102810_);
        playerModel.f_102809_.m_104315_(playerModel.f_102808_);
        playerModel.f_103376_.f_104207_ = renderLayers;
        playerModel.f_103377_.f_104207_ = renderLayers;
        playerModel.f_103374_.f_104207_ = renderLayers;
        playerModel.f_103375_.f_104207_ = renderLayers;
        playerModel.f_103378_.f_104207_ = renderLayers;
        playerModel.f_102809_.f_104207_ = renderLayers;
    }

    private static void renderPlayerModel(PlayerPlushieBlockEntity blockEntity, PlayerModel<Player> playerModel, Iterable<ModelPart> headParts, Iterable<ModelPart> bodyParts, PoseStack pose, VertexConsumer buffer, int combinedLight, int combinedOverlay) {
        if (blockEntity.m_58898_()) {
            pose.m_85837_(0.5, 0.5, 0.5);
            BlockState blockState = blockEntity.m_58900_();
            Direction facing = (Direction)blockState.m_61143_((Property)PlayerPlushieBlock.FACING);
            pose.m_85845_(Vector3f.f_122225_.m_122240_(-facing.m_122435_()));
            pose.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            pose.m_85837_(0.0, 0.0, 0.2);
        } else {
            pose.m_85837_(0.5, 0.5, 0.5);
            pose.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        }
        double yOffset = -0.35;
        if (playerModel.f_102610_) {
            yOffset = -0.65;
        }
        pose.m_85837_(0.0, yOffset, 0.0);
        if (playerModel.f_102610_) {
            pose.m_85836_();
            boolean scaleHead = true;
            float babyHeadScale = 2.0f;
            float babyBodyScale = 2.0f;
            float yHeadOffset = 16.0f;
            float zHeadOffset = 0.0f;
            float bodyYOffset = 24.0f;
            if (scaleHead) {
                float f = 1.5f / babyHeadScale;
                pose.m_85841_(f, f, f);
            }
            pose.m_85837_(0.0, (double)(yHeadOffset / 16.0f), (double)(zHeadOffset / 16.0f));
            headParts.forEach(renderer -> renderer.m_104306_(pose, buffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f));
            playerModel.f_102809_.m_104306_(pose, buffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            pose.m_85849_();
            pose.m_85836_();
            float f1 = 1.0f / babyBodyScale;
            pose.m_85841_(f1, f1, f1);
            pose.m_85837_(0.0, (double)(bodyYOffset / 16.0f), 0.0);
            bodyParts.forEach(renderer -> renderer.m_104306_(pose, buffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f));
            pose.m_85849_();
        } else {
            headParts.forEach(renderer -> renderer.m_104306_(pose, buffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f));
            bodyParts.forEach(renderer -> renderer.m_104306_(pose, buffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f));
        }
    }

    private static Iterable<ModelPart> getHeadParts(PlayerModel<Player> playerModel) {
        try {
            return (Iterable)MethodHelper.invokeMethod(AgeableListModel.class, playerModel, "headParts", new Class[0], new Object[0]);
        }
        catch (Exception e) {
            return ImmutableList.of((Object)playerModel.f_102808_);
        }
    }

    private static Iterable<ModelPart> getBodyParts(PlayerModel<Player> playerModel) {
        try {
            return (Iterable)MethodHelper.invokeMethod(AgeableListModel.class, playerModel, "bodyParts", new Class[0], new Object[0]);
        }
        catch (Exception e) {
            return ImmutableList.of((Object)playerModel.f_103376_, (Object)playerModel.f_103377_, (Object)playerModel.f_103374_, (Object)playerModel.f_103375_, (Object)playerModel.f_103378_, (Object)playerModel.f_102810_, (Object)playerModel.f_102811_, (Object)playerModel.f_102812_, (Object)playerModel.f_102813_, (Object)playerModel.f_102814_, (Object)playerModel.f_102809_);
        }
    }
}

