/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import xyz.apex.forge.apexcore.lib.support.SupporterManager;

public final class CommandApex {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"apexcore").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"supporters").then(Commands.m_82127_((String)"arethey").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(CommandApex::onAreTheySupporting)))).then(Commands.m_82127_((String)"ami").executes(CommandApex::onAmISupporting))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(CommandApex::requiresOp)).executes(CommandApex::onReloadSupporters))));
    }

    private static boolean requiresOp(CommandSourceStack src) {
        return src.m_6761_(2);
    }

    private static int onReloadSupporters(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        src.m_81354_((Component)new TextComponent("Reloading ").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN)).m_7220_((Component)new TextComponent("ApexCore").m_130938_(style -> style.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.AQUA))).m_7220_((Component)new TextComponent(" Supporters..").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN))), true);
        SupporterManager.loadSupporters();
        src.m_81354_((Component)new TextComponent("Reloaded ").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN)).m_7220_((Component)new TextComponent("ApexCore").m_130938_(style -> style.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.AQUA))).m_7220_((Component)new TextComponent(" Supporters!").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN))), true);
        return 1;
    }

    private static int onAreTheySupporting(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Player other;
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        Entity entity = src.m_81373_();
        if (entity instanceof Player && CommandApex.areSamePlayers((Player)player, other = (Player)entity)) {
            return CommandApex.onAmISupporting((CommandContext<CommandSourceStack>)ctx.copyFor((Object)src.m_81329_((Entity)player)));
        }
        src.m_81354_(CommandApex.buildSupporterComponent(player, false), true);
        return 1;
    }

    private static int onAmISupporting(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = src.m_81375_();
        src.m_81354_(CommandApex.buildSupporterComponent(player, true), true);
        return 1;
    }

    private static Component buildSupporterComponent(ServerPlayer player, boolean you) {
        MutableComponent supporting;
        Optional<SupporterManager.SupporterInfo> infoOpt = SupporterManager.findSupporterInfo((Player)player);
        MutableComponent playerName = (you ? new TextComponent("You") : new TextComponent(player.m_5446_().getString())).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true)));
        MutableComponent apexStudios = new TextComponent("ApexStudios").m_130938_(style -> style.m_131140_(ChatFormatting.AQUA).m_131155_(Boolean.valueOf(true)).m_131136_(Boolean.valueOf(true)));
        if (infoOpt.isPresent()) {
            SupporterManager.SupporterInfo info = infoOpt.get();
            supporting = you ? new TextComponent(" are Supporting ") : new TextComponent(" is Supporting ");
            MutableComponent level = new TextComponent(" (").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true))).m_7220_((Component)new TextComponent(info.getLevel().m_7912_()).m_130938_(style -> style.m_131140_(ChatFormatting.DARK_AQUA).m_131155_(Boolean.valueOf(true)).m_131136_(Boolean.valueOf(true)))).m_7220_((Component)new TextComponent(")"));
            apexStudios.m_7220_((Component)level);
        } else {
            supporting = (you ? new TextComponent(" are Not Supporting ") : new TextComponent(" is Not Supporting ")).m_130938_(style -> style.m_131140_(ChatFormatting.RED));
        }
        return playerName.m_7220_((Component)supporting).m_7220_((Component)apexStudios);
    }

    private static boolean areSamePlayers(Player left, Player right) {
        return left.m_36316_().getId().equals(right.m_36316_().getId());
    }
}

