/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.init;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import xyz.apex.forge.apexcore.core.block.PlayerPlushieBlock;
import xyz.apex.forge.apexcore.core.block.entity.PlayerPlushieBlockEntity;
import xyz.apex.forge.apexcore.core.client.renderer.PlayerPlushieBlockEntityRenderer;
import xyz.apex.forge.apexcore.core.init.ACRegistry;
import xyz.apex.forge.apexcore.core.item.PlayerPlushieBlockItem;
import xyz.apex.forge.apexcore.lib.block.BlockHelper;
import xyz.apex.forge.apexcore.lib.support.SupporterManager;
import xyz.apex.forge.utility.registrator.builder.BlockBuilder;
import xyz.apex.forge.utility.registrator.entry.BlockEntityEntry;
import xyz.apex.forge.utility.registrator.entry.BlockEntry;
import xyz.apex.forge.utility.registrator.entry.ItemEntry;
import xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry;

public final class PlayerPlushie {
    private static final ACRegistry REGISTRY = ACRegistry.getRegistry();
    public static final BlockEntry<PlayerPlushieBlock> PLAYER_PLUSHIE_BLOCK = PlayerPlushie.playerPlushie();
    public static final ItemEntry<BlockItem> PLAYER_PLUSHIE_BLOCK_ITEM = ItemEntry.cast((RegistryEntry)PLAYER_PLUSHIE_BLOCK.getSibling(Item.class));
    public static final BlockEntityEntry<PlayerPlushieBlockEntity> PLAYER_PLUSHIE_BLOCK_ENTITY = BlockEntityEntry.cast((RegistryEntry)PLAYER_PLUSHIE_BLOCK.getSibling(BlockEntityType.class));
    public static final String NBT_SUPPORTER_DATA = "SupporterData";
    private static final String NBT_PLAYER_ID = "UUID";
    private static final String NBT_PLAYER_ALIASES = "Aliases";
    private static final String NBT_SUPPORTER_LEVEL = "Level";
    private static final String NBT_USERNAME = "Username";

    static void bootstrap() {
    }

    private static BlockEntry<PlayerPlushieBlock> playerPlushie() {
        return (BlockEntry)((BlockBuilder)((BlockBuilder)REGISTRY.block("player_plushie", PlayerPlushieBlock::new).lang("Player Plushie").lang("en_gb", "Player Plushie").initialProperties(Material.f_76272_).strength(0.8f).sound(SoundType.f_56745_).noOcclusion().blockState((ctx, provider) -> provider.getVariantBuilder((Block)ctx.get()).forAllStates(blockState -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)provider.models().getBuilder(ctx.getName())).texture("particle", "minecraft:block/white_wool")).build())).loot((lootTables, block) -> lootTables.m_124165_((Block)block, LootTable.m_79147_().m_79161_((LootPool.Builder)BlockLoot.m_124134_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_(NBT_SUPPORTER_DATA, NBT_SUPPORTER_DATA)))))).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::m_110463_).item(PlayerPlushieBlockItem::new).model((ctx, provider) -> {
            ModelFile.UncheckedModelFile builtInEntity = new ModelFile.UncheckedModelFile("minecraft:builtin/entity");
            ((ItemModelBuilder)((ItemModelBuilder)provider.getBuilder(ctx.getName())).parent((ModelFile)builtInEntity)).transforms().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(0.0f, 135.0f, 0.0f).translation(0.0f, 4.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(0.0f, 135.0f, 0.0f).translation(0.0f, 4.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ModelBuilder.Perspective.HEAD).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 14.5f, 0.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ModelBuilder.Perspective.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ModelBuilder.Perspective.FIXED).rotation(-90.0f, 0.0f, 0.0f).translation(0.0f, 0.0f, -8.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ModelBuilder.Perspective.GUI).rotation(30.0f, -135.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.625f, 0.625f, 0.625f).end().end();
        }).tab(() -> CreativeModeTab.f_40753_).build()).blockEntity(PlayerPlushieBlockEntity::new).renderer(() -> PlayerPlushieBlockEntityRenderer::new).build()).register();
    }

    public static List<ItemStack> getPlushieItems() {
        return SupporterManager.getSupporters().stream().map(PlayerPlushie::getPlushieItem).collect(Collectors.toList());
    }

    public static ItemStack getPlushieItem(SupporterManager.SupporterInfo info, int stackSize) {
        ItemStack stack = PLAYER_PLUSHIE_BLOCK.asItemStack(stackSize);
        CompoundTag stackTag = stack.m_41784_();
        CompoundTag supporterTag = PlayerPlushie.writeSupporterInfoTag(info);
        stackTag.m_128365_(NBT_SUPPORTER_DATA, (Tag)supporterTag);
        return stack;
    }

    public static ItemStack getPlushieItem(SupporterManager.SupporterInfo info) {
        return PlayerPlushie.getPlushieItem(info, 1);
    }

    @Nullable
    public static SupporterManager.SupporterInfo getSupporterInfo(ItemStack stack) {
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag != null && stackTag.m_128425_(NBT_SUPPORTER_DATA, 10)) {
            CompoundTag supporterTag = stackTag.m_128469_(NBT_SUPPORTER_DATA);
            return PlayerPlushie.getSupporterInfo(supporterTag);
        }
        return null;
    }

    @Nullable
    public static SupporterManager.SupporterInfo getSupporterInfo(CompoundTag supporterTag) {
        Set<SupporterManager.SupporterInfo> supporters = SupporterManager.getSupporters();
        if (supporterTag.m_128425_(NBT_PLAYER_ID, 11)) {
            UUID playerId = supporterTag.m_128342_(NBT_PLAYER_ID);
            for (SupporterManager.SupporterInfo info : supporters) {
                if (!info.isFor(playerId)) continue;
                return info;
            }
        }
        if (supporterTag.m_128425_(NBT_PLAYER_ALIASES, 9)) {
            ListTag aliasesTag = supporterTag.m_128437_(NBT_PLAYER_ALIASES, 11);
            for (Tag inbt : aliasesTag) {
                UUID playerId = NbtUtils.m_129233_((Tag)inbt);
                for (SupporterManager.SupporterInfo info : supporters) {
                    if (!info.isFor(playerId)) continue;
                    return info;
                }
            }
        }
        return null;
    }

    public static CompoundTag writeSupporterInfoTag(SupporterManager.SupporterInfo info) {
        Set<UUID> aliases = info.getAliases();
        SupporterManager.SupporterLevel level = info.getLevel();
        CompoundTag supporterTag = new CompoundTag();
        supporterTag.m_128362_(NBT_PLAYER_ID, info.getPlayerId());
        supporterTag.m_128359_(NBT_SUPPORTER_LEVEL, level.m_7912_());
        supporterTag.m_128359_(NBT_USERNAME, info.getUsername());
        if (!aliases.isEmpty()) {
            ListTag aliasesTag = new ListTag();
            aliases.forEach(alias -> aliasesTag.add((Object)NbtUtils.m_129226_((UUID)alias)));
            supporterTag.m_128365_(NBT_PLAYER_ALIASES, (Tag)aliasesTag);
        }
        return supporterTag;
    }
}

