/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.net;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import xyz.apex.forge.apexcore.lib.net.AbstractPacket;
import xyz.apex.forge.apexcore.lib.net.NetworkManager;
import xyz.apex.forge.apexcore.lib.support.SupporterManager;
import xyz.apex.java.utility.Apex;

public final class ClientSyncSupportersPacket
extends AbstractPacket {
    public final Set<SupporterManager.SupporterInfo> networkInfos;

    public ClientSyncSupportersPacket(Set<SupporterManager.SupporterInfo> networkInfos) {
        this.networkInfos = ImmutableSet.copyOf(networkInfos);
    }

    public ClientSyncSupportersPacket(FriendlyByteBuf buffer) {
        super(buffer);
        int count = buffer.m_130242_();
        this.networkInfos = Apex.makeImmutableSet(builder -> {
            for (int i = 0; i < count; ++i) {
                SupporterManager.SupporterLevel level = SupporterManager.SupporterLevel.DEFAULT;
                HashSet aliases = Sets.newHashSet();
                UUID playerId = buffer.m_130259_();
                String username = buffer.m_130277_();
                if (buffer.readBoolean()) {
                    level = (SupporterManager.SupporterLevel)buffer.m_130066_(SupporterManager.SupporterLevel.class);
                }
                if (buffer.readBoolean()) {
                    int aliasCount = buffer.m_130242_();
                    IntStream.range(0, aliasCount).mapToObj(j -> buffer.m_130259_()).forEach(aliases::add);
                }
                builder.add((Object)new SupporterManager.SupporterInfo(playerId, level, aliases, username));
            }
            return builder;
        });
    }

    @Override
    protected void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.networkInfos.size());
        for (SupporterManager.SupporterInfo info : this.networkInfos) {
            SupporterManager.SupporterLevel level = info.getLevel();
            Set<UUID> aliases = info.getAliases();
            buffer.m_130077_(info.getPlayerId());
            buffer.m_130070_(info.getUsername());
            if (level.isDefault()) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                buffer.m_130068_((Enum)level);
            }
            if (aliases.isEmpty()) {
                buffer.writeBoolean(false);
                continue;
            }
            buffer.writeBoolean(true);
            buffer.m_130130_(aliases.size());
            aliases.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130077_(arg_0));
        }
    }

    @Override
    protected void process(NetworkManager network, NetworkEvent.Context ctx) {
        SupporterManager.loadSupportersFromNetwork(this);
    }
}

