/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.block;

import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public final class BlockHelper {
    public static ToIntFunction<BlockState> litBlockEmission(int lightEmission) {
        return blockState -> (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightEmission : 0;
    }

    public static Boolean never(BlockState blockState, BlockGetter level, BlockPos pos, EntityType<?> entityType) {
        return false;
    }

    public static Boolean always(BlockState blockState, BlockGetter level, BlockPos pos, EntityType<?> entityType) {
        return true;
    }

    public static Boolean ocelotOrParrot(BlockState blockState, BlockGetter level, BlockPos pos, EntityType<?> entityType) {
        return entityType == EntityType.f_20505_ || entityType == EntityType.f_20508_;
    }

    public static boolean always(BlockState blockState, BlockGetter level, BlockPos pos) {
        return true;
    }

    public static boolean never(BlockState blockState, BlockGetter level, BlockPos pos) {
        return false;
    }

    public static void playBreakSound(Level level, BlockPos pos, @Nullable Entity entity) {
        BlockState blockState = level.m_8055_(pos);
        SoundType soundType = blockState.getSoundType((LevelReader)level, pos, entity);
        level.m_5594_(null, pos, soundType.m_56775_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
    }

    public static void playPlaceSound(Level level, BlockPos pos, @Nullable Entity entity) {
        BlockState blockState = level.m_8055_(pos);
        SoundType soundType = blockState.getSoundType((LevelReader)level, pos, entity);
        level.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
    }

    public static void playStepSound(Level level, BlockPos pos, @Nullable Entity entity) {
        BlockState blockState = level.m_8055_(pos);
        SoundType soundType = blockState.getSoundType((LevelReader)level, pos, entity);
        level.m_5594_(null, pos, soundType.m_56776_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
    }

    public static void playFallSound(Level level, BlockPos pos, @Nullable Entity entity) {
        BlockState blockState = level.m_8055_(pos);
        SoundType soundType = blockState.getSoundType((LevelReader)level, pos, entity);
        level.m_5594_(null, pos, soundType.m_56779_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
    }

    public static void playHitSound(Level level, BlockPos pos, @Nullable Entity entity) {
        BlockState blockState = level.m_8055_(pos);
        SoundType soundType = blockState.getSoundType((LevelReader)level, pos, entity);
        level.m_5594_(null, pos, soundType.m_56778_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
    }

    public static BlockState copyBlockProperties(BlockState from, BlockState to) {
        for (Property property : from.m_61147_()) {
            to = BlockHelper.copyBlockProperty(from, to, property);
        }
        return to;
    }

    public static <T extends Comparable<T>> BlockState copyBlockProperty(BlockState from, BlockState to, Property<T> property) {
        if (from.m_61138_(property) && to.m_61138_(property)) {
            return (BlockState)to.m_61124_(property, from.m_61143_(property));
        }
        return to;
    }
}

