/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.multiblock;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.DistExecutor;
import xyz.apex.forge.apexcore.lib.multiblock.MultiBlock;
import xyz.apex.forge.apexcore.lib.multiblock.MultiBlockFactory;
import xyz.apex.forge.apexcore.lib.multiblock.MultiBlockPattern;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.BlockEntityBuilder;
import xyz.apex.forge.utility.registrator.builder.ItemBuilder;
import xyz.apex.forge.utility.registrator.builder.LegacyRegistratorBuilder;
import xyz.apex.forge.utility.registrator.builder.RegistratorBuilder;
import xyz.apex.forge.utility.registrator.entry.BlockEntry;
import xyz.apex.forge.utility.registrator.factory.BlockEntityFactory;
import xyz.apex.forge.utility.registrator.factory.item.BlockItemFactory;
import xyz.apex.java.utility.nullness.NonnullBiConsumer;
import xyz.apex.java.utility.nullness.NonnullFunction;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.java.utility.nullness.NonnullUnaryOperator;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.providers.DataGenContext;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateRecipeProvider;
import xyz.apex.repack.com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import xyz.apex.repack.com.tterrag.registrate.providers.loot.RegistrateLootTableProvider;
import xyz.apex.repack.com.tterrag.registrate.util.OneTimeEventReceiver;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public class MultiBlockBuilder<OWNER extends AbstractRegistrator<OWNER>, BLOCK extends MultiBlock, PARENT>
extends RegistratorBuilder<OWNER, Block, BLOCK, PARENT, MultiBlockBuilder<OWNER, BLOCK, PARENT>, BlockEntry<BLOCK>> {
    private final MultiBlockFactory<BLOCK> blockFactory;
    private NonnullSupplier<BlockBehaviour.Properties> initialProperties;
    private NonnullUnaryOperator<BlockBehaviour.Properties> propertiesModifier = NonnullUnaryOperator.identity();
    private final List<NonnullSupplier<NonnullSupplier<RenderType>>> renderTypes = Lists.newArrayList();
    @Nullable
    private NonnullSupplier<NonnullSupplier<BlockColor>> colorHandler = null;
    @Nullable
    private ItemBuilder<OWNER, ?, MultiBlockBuilder<OWNER, BLOCK, PARENT>> itemBuilder = null;
    @Nullable
    private BlockEntityBuilder<OWNER, ?, MultiBlockBuilder<OWNER, BLOCK, PARENT>> blockEntityBuilder = null;
    private final MultiBlockPattern pattern;

    public MultiBlockBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback, MultiBlockFactory<BLOCK> blockFactory, NonnullSupplier<BlockBehaviour.Properties> initialProperties, MultiBlockPattern pattern) {
        super(owner, parent, registryName, callback, Block.class, BlockEntry::new, BlockEntry::cast);
        this.pattern = pattern;
        this.blockFactory = blockFactory;
        this.initialProperties = initialProperties;
        this.onRegister(this::onRegister);
        this.defaultBlockState().defaultLoot().defaultLang();
    }

    private void onRegister(BLOCK block) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            OneTimeEventReceiver.addModListener(ColorHandlerEvent.Block.class, event -> this.registerBlockColor((ColorHandlerEvent.Block)event, (BLOCK)((Object)block)));
            this.registerRenderTypes(block);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerBlockColor(ColorHandlerEvent.Block event, BLOCK block) {
        if (this.colorHandler != null) {
            event.getBlockColors().m_92589_((BlockColor)((NonnullSupplier)this.colorHandler.get()).get(), new Block[]{block});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderTypes(BLOCK block) {
        if (this.renderTypes.size() == 1) {
            RenderType renderType = (RenderType)((NonnullSupplier)this.renderTypes.get(0).get()).get();
            ItemBlockRenderTypes.setRenderLayer(block, (RenderType)renderType);
        } else if (this.renderTypes.size() > 1) {
            ImmutableSet renderTypes = (ImmutableSet)this.renderTypes.stream().map(NonnullSupplier::get).map(NonnullSupplier::get).collect(ImmutableSet.toImmutableSet());
            ItemBlockRenderTypes.setRenderLayer(block, arg_0 -> ((ImmutableSet)renderTypes).contains(arg_0));
        }
    }

    @NonnullType
    protected BLOCK createEntry() {
        if (this.itemBuilder != null) {
            this.copyMappingsTo((LegacyRegistratorBuilder)this.itemBuilder);
        }
        if (this.blockEntityBuilder != null) {
            this.copyMappingsTo((LegacyRegistratorBuilder)this.blockEntityBuilder);
        }
        BlockBehaviour.Properties properties = (BlockBehaviour.Properties)this.initialProperties.get();
        properties = (BlockBehaviour.Properties)this.propertiesModifier.apply((Object)properties);
        return this.blockFactory.create(properties, this.pattern);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> properties(NonnullUnaryOperator<BlockBehaviour.Properties> propertiesModifier) {
        this.propertiesModifier = this.propertiesModifier.andThen(propertiesModifier);
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60939_((Material)material);
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material, DyeColor materialColor) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60941_((Material)material, (DyeColor)materialColor);
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material, MaterialColor materialColor) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)materialColor);
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material, NonnullFunction<BlockState, MaterialColor> materialColorFactory) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60947_((Material)material, (Function)materialColorFactory);
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> initialProperties(NonnullSupplier<? extends Block> block) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)block.get()));
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> noCollission() {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)BlockBehaviour.Properties::m_60910_));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> noOcclusion() {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)BlockBehaviour.Properties::m_60955_));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> friction(float friction) {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)properties -> properties.m_60911_(friction)));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> speedFactor(float speedFactor) {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)properties -> properties.m_60956_(speedFactor)));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> jumpFactor(float jumpFactor) {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)properties -> properties.m_60967_(jumpFactor)));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> sound(SoundType soundType) {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)properties -> properties.m_60918_(soundType)));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> lightLevel(ToIntFunction<BlockState> lightLevelFunction) {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)properties -> properties.m_60953_(lightLevelFunction)));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> strength(float destroyTime, float explosionResistance) {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)properties -> properties.m_60913_(destroyTime, explosionResistance)));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> instabreak() {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)BlockBehaviour.Properties::m_60966_));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> strength(float strength) {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)properties -> properties.m_60978_(strength)));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> randomTicks() {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)BlockBehaviour.Properties::m_60977_));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> dynamicShape() {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)BlockBehaviour.Properties::m_60988_));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> noDrops() {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)BlockBehaviour.Properties::m_60993_));
    }

    @Deprecated
    public MultiBlockBuilder<OWNER, BLOCK, PARENT> dropsLike(Block block) {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)properties -> properties.m_60916_(block)));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> dropsLike(NonnullSupplier<? extends Block> block) {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)properties -> properties.lootFrom((Supplier)block)));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> air() {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)BlockBehaviour.Properties::m_60996_));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> isValidSpawn(BlockBehaviour.StateArgumentPredicate<EntityType<?>> extendedPositionPredicate) {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)properties -> properties.m_60922_(extendedPositionPredicate)));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> isRedstoneConductor(BlockBehaviour.StatePredicate positionPredicate) {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)properties -> properties.m_60924_(positionPredicate)));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> isSuffocating(BlockBehaviour.StatePredicate positionPredicate) {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)properties -> properties.m_60960_(positionPredicate)));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> isViewBlocking(BlockBehaviour.StatePredicate positionPredicate) {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)properties -> properties.m_60971_(positionPredicate)));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> hasPostProcess(BlockBehaviour.StatePredicate positionPredicate) {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)properties -> properties.m_60982_(positionPredicate)));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> emissiveRendering(BlockBehaviour.StatePredicate positionPredicate) {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)properties -> properties.m_60991_(positionPredicate)));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> requiresCorrectToolForDrops() {
        return this.properties((NonnullUnaryOperator<BlockBehaviour.Properties>)((NonnullUnaryOperator)BlockBehaviour.Properties::m_60999_));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> addRenderType(NonnullSupplier<NonnullSupplier<RenderType>> renderType) {
        this.renderTypes.add(renderType);
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> simpleItem() {
        return this.simpleItem(BlockItemFactory.forBlock());
    }

    public <ITEM extends BlockItem> MultiBlockBuilder<OWNER, BLOCK, PARENT> simpleItem(BlockItemFactory<BLOCK, ITEM> blockItemFactory) {
        return (MultiBlockBuilder)((Object)this.item(blockItemFactory).build());
    }

    public ItemBuilder<OWNER, BlockItem, MultiBlockBuilder<OWNER, BLOCK, PARENT>> item() {
        return this.item(BlockItemFactory.forBlock());
    }

    public <ITEM extends BlockItem> ItemBuilder<OWNER, ITEM, MultiBlockBuilder<OWNER, BLOCK, PARENT>> item(BlockItemFactory<BLOCK, ITEM> blockItemFactory) {
        if (this.itemBuilder == null) {
            this.itemBuilder = this.owner.blockItem(this.getName(), (Object)this, this.toSupplier(), blockItemFactory);
        }
        return this.itemBuilder;
    }

    public <BLOCK_ENTITY extends BlockEntity> MultiBlockBuilder<OWNER, BLOCK, PARENT> simpleBlockEntity(BlockEntityFactory<BLOCK_ENTITY> blockEntityFactory) {
        return (MultiBlockBuilder)((Object)this.blockEntity(blockEntityFactory).build());
    }

    public <BLOCK_ENTITY extends BlockEntity> BlockEntityBuilder<OWNER, BLOCK_ENTITY, MultiBlockBuilder<OWNER, BLOCK, PARENT>> blockEntity(BlockEntityFactory<BLOCK_ENTITY> blockEntityFactory) {
        if (this.blockEntityBuilder == null) {
            this.blockEntityBuilder = this.owner.blockEntity(this.getName(), (Object)this, blockEntityFactory).validBlock(() -> (Block)this.asSupplier().get());
        }
        return this.blockEntityBuilder;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> color(NonnullSupplier<NonnullSupplier<BlockColor>> colorHandler) {
        this.colorHandler = colorHandler;
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> defaultBlockState() {
        return this.blockState((ctx, provider) -> provider.simpleBlock((Block)ctx.getEntry()));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> blockState(NonnullBiConsumer<DataGenContext<Block, BLOCK>, RegistrateBlockstateProvider> consumer) {
        return (MultiBlockBuilder)this.setDataGenerator(ProviderType.BLOCKSTATE, consumer);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> defaultLang() {
        return (MultiBlockBuilder)this.lang(Block::m_7705_);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> lang(String name) {
        return (MultiBlockBuilder)this.lang(Block::m_7705_, name);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> defaultLoot() {
        return this.loot(BlockLoot::m_124288_);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> loot(NonnullBiConsumer<RegistrateBlockLootTables, BLOCK> consumer) {
        return (MultiBlockBuilder)this.setDataGenerator(ProviderType.LOOT, (ctx, provider) -> provider.addLootAction(RegistrateLootTableProvider.LootType.BLOCK, lootTables -> consumer.accept(lootTables, (Object)((MultiBlock)((Object)((Object)((Object)ctx.getEntry())))))));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> recipe(NonnullBiConsumer<DataGenContext<Block, BLOCK>, RegistrateRecipeProvider> consumer) {
        return (MultiBlockBuilder)this.setDataGenerator(ProviderType.RECIPE, consumer);
    }

    @SafeVarargs
    public final MultiBlockBuilder<OWNER, BLOCK, PARENT> tag(Tag.Named<Block> ... tags) {
        return (MultiBlockBuilder)((Object)this.tag(ProviderType.BLOCK_TAGS, tags));
    }

    @SafeVarargs
    public final MultiBlockBuilder<OWNER, BLOCK, PARENT> removeTag(Tag.Named<Block> ... tags) {
        return (MultiBlockBuilder)((Object)this.removeTag(ProviderType.BLOCK_TAGS, tags));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> lang(String languageKey, String localizedValue) {
        return (MultiBlockBuilder)this.lang(languageKey, Block::m_7705_, localizedValue);
    }
}

