/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.multiblock;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import xyz.apex.forge.apexcore.lib.multiblock.MultiBlockFourWay;
import xyz.apex.java.utility.nullness.NonnullBiFunction;
import xyz.apex.java.utility.nullness.NonnullQuadFunction;
import xyz.apex.java.utility.nullness.NonnullTriPredicate;

public final class MultiBlockPattern {
    public static final int INDEX_ORIGIN = 0;
    private final List<BlockPos> localPositions;
    private final IntegerProperty blockProperty;
    @Nullable
    private final NonnullBiFunction<BlockState, BlockPos, BlockPos> worldSpaceFromLocalSpace;
    @Nullable
    private final NonnullBiFunction<BlockState, BlockPos, BlockPos> originFromWorldSpace;
    @Nullable
    private final NonnullQuadFunction<MultiBlockPattern, BlockPos, BlockState, Integer, BlockState> placementStateModifier;
    @Nullable
    private final NonnullTriPredicate<LevelReader, BlockPos, BlockState> placementPredicate;
    private final boolean placeSoundPerBlock;

    private MultiBlockPattern(Builder builder) {
        this.worldSpaceFromLocalSpace = builder.worldSpaceFromLocalSpace;
        this.originFromWorldSpace = builder.originFromWorldSpace;
        this.placementPredicate = builder.placementPredicate;
        this.placeSoundPerBlock = builder.placeSoundPerBlock;
        this.placementStateModifier = builder.placementStateModifier;
        ImmutableList.Builder list = ImmutableList.builder();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int y = 0; y < builder.layers.size(); ++y) {
            String[] patterns = builder.layers.get(y);
            pos.m_142448_(y);
            for (int x = 0; x < patterns.length; ++x) {
                String pattern = patterns[x];
                pos.m_142451_(x);
                for (int z = 0; z < pattern.length(); ++z) {
                    char token = pattern.charAt(z);
                    pos.m_142443_(z);
                    if (Character.isWhitespace(token)) continue;
                    list.add((Object)pos.m_7949_());
                }
            }
        }
        this.localPositions = list.build();
        this.blockProperty = IntegerProperty.m_61631_((String)"multi_block_index", (int)0, (int)this.localPositions.size());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx, BlockState defaultBlockState) {
        Level level = ctx.m_43725_();
        BlockPos origin = ctx.m_8083_();
        for (BlockPos localSpace : this.localPositions) {
            BlockState blockState;
            BlockPos worldSpace = this.getWorldSpaceFromLocalSpace(defaultBlockState, origin, localSpace);
            if (!this.passesPlacementTests((LevelReader)level, worldSpace, blockState = level.m_8055_(worldSpace))) continue;
            return defaultBlockState;
        }
        return null;
    }

    public boolean canSurvive(LevelReader level, BlockPos pos, BlockState blockState) {
        int index = this.getIndex(blockState);
        BlockPos origin = this.getOriginFromWorldSpace(blockState, pos, this.localPositions.get(index));
        for (BlockPos localSpace : this.localPositions) {
            BlockState testBlockState;
            BlockPos worldSpace = this.getWorldSpaceFromLocalSpace(blockState, origin, localSpace);
            if (this.passesPlacementTests(level, worldSpace, testBlockState = level.m_8055_(worldSpace))) continue;
            return false;
        }
        return true;
    }

    public void onPlace(BlockState blockState, Level level, BlockPos origin, BlockState oldBlockState, boolean isMoving) {
        if (!oldBlockState.m_60713_(blockState.m_60734_()) && (Integer)blockState.m_61143_((Property)this.blockProperty) == 0) {
            SoundType soundType = blockState.getSoundType((LevelReader)level, origin, null);
            SoundEvent placeSound = soundType.m_56777_();
            for (int i = 1; i < this.localPositions.size(); ++i) {
                BlockPos localSpace = this.localPositions.get(i);
                BlockPos worldSpace = this.getWorldSpaceFromLocalSpace(blockState, origin, localSpace);
                BlockState placementBlockState = (BlockState)blockState.m_61124_((Property)this.blockProperty, (Comparable)Integer.valueOf(i));
                placementBlockState = this.getPlacementState(worldSpace, placementBlockState, i);
                level.m_7731_(worldSpace, placementBlockState, 11);
                if (!this.placeSoundPerBlock) continue;
                level.m_5594_(null, worldSpace, placeSound, SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
            }
        }
    }

    public void onRemove(BlockState blockState, Level level, BlockPos pos, BlockState newBlockState, boolean isMoving) {
        Block block = blockState.m_60734_();
        Integer index = (Integer)blockState.m_61143_((Property)this.blockProperty);
        BlockPos origin = this.getOriginFromWorldSpace(blockState, pos, this.localPositions.get(index));
        for (BlockPos localSpace : this.localPositions) {
            BlockPos worldSpace = this.getWorldSpaceFromLocalSpace(blockState, origin, localSpace);
            if (worldSpace.equals((Object)pos) || !level.m_8055_(worldSpace).m_60713_(block)) continue;
            level.m_46961_(worldSpace, false);
        }
    }

    public void rotate(BlockState blockState, LevelAccessor level, BlockPos origin, Rotation rotation, BlockState rotatedBlockState) {
        Integer index = (Integer)blockState.m_61143_((Property)this.blockProperty);
        if (index != 0) {
            for (int i = 1; i < this.localPositions.size(); ++i) {
                BlockPos localSpace = this.localPositions.get(i);
                BlockPos worldSpace = this.getWorldSpaceFromLocalSpace(rotatedBlockState, origin, localSpace);
                level.m_7731_(worldSpace, (BlockState)rotatedBlockState.m_61124_((Property)this.blockProperty, (Comparable)Integer.valueOf(i)), 3);
            }
        }
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.blockProperty});
    }

    private boolean passesPlacementTests(LevelReader level, BlockPos pos, BlockState blockState) {
        if (!blockState.m_60767_().m_76336_()) {
            return false;
        }
        if (this.placementPredicate != null) {
            return this.placementPredicate.test((Object)level, (Object)pos, (Object)blockState);
        }
        return true;
    }

    BlockState registerDefaultState(BlockState state) {
        return (BlockState)state.m_61124_((Property)this.blockProperty, (Comparable)Integer.valueOf(0));
    }

    public int getIndex(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)this.blockProperty);
    }

    public boolean isOrigin(BlockState blockState) {
        return blockState.m_61145_((Property)this.blockProperty).map(index -> index == 0).orElse(false);
    }

    public BlockPos getWorldSpaceFromLocalSpace(BlockState blockState, BlockPos origin, BlockPos localSpace) {
        if (this.worldSpaceFromLocalSpace != null) {
            BlockPos newLocalSpace = (BlockPos)this.worldSpaceFromLocalSpace.apply((Object)blockState, (Object)localSpace);
            return origin.m_141952_((Vec3i)newLocalSpace);
        }
        return origin.m_141952_((Vec3i)localSpace);
    }

    public BlockPos getOriginFromWorldSpace(BlockState blockState, BlockPos worldSpace, BlockPos localSpace) {
        if (this.originFromWorldSpace != null) {
            BlockPos newLocalSpace = (BlockPos)this.originFromWorldSpace.apply((Object)blockState, (Object)localSpace);
            return worldSpace.m_141950_((Vec3i)newLocalSpace);
        }
        return worldSpace.m_141950_((Vec3i)localSpace);
    }

    public List<BlockPos> getLocalPositions() {
        return this.localPositions;
    }

    private BlockState getPlacementState(BlockPos pos, BlockState blockState, int index) {
        if (this.placementStateModifier != null) {
            return (BlockState)this.placementStateModifier.apply((Object)this, (Object)pos, (Object)blockState, (Object)index);
        }
        return blockState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<String[]> layers = Lists.newArrayList();
        @Nullable
        private NonnullBiFunction<BlockState, BlockPos, BlockPos> worldSpaceFromLocalSpace;
        @Nullable
        private NonnullBiFunction<BlockState, BlockPos, BlockPos> originFromWorldSpace;
        @Nullable
        private NonnullQuadFunction<MultiBlockPattern, BlockPos, BlockState, Integer, BlockState> placementStateModifier;
        @Nullable
        private NonnullTriPredicate<LevelReader, BlockPos, BlockState> placementPredicate;
        private boolean placeSoundPerBlock = false;

        private Builder() {
        }

        public Builder layer(String ... layers) {
            Collections.addAll(this.layers, new String[][]{layers});
            return this;
        }

        public Builder worldSpaceFromLocalSpace(NonnullBiFunction<BlockState, BlockPos, BlockPos> worldSpaceFromLocalSpace) {
            this.worldSpaceFromLocalSpace = worldSpaceFromLocalSpace;
            return this;
        }

        public Builder originFromWorldSpace(NonnullBiFunction<BlockState, BlockPos, BlockPos> originFromWorldSpace) {
            this.originFromWorldSpace = originFromWorldSpace;
            return this;
        }

        public Builder setSpacesFor4Way() {
            return this.worldSpaceFromLocalSpace((NonnullBiFunction<BlockState, BlockPos, BlockPos>)((NonnullBiFunction)(blockState, pos) -> {
                Direction facing = (Direction)blockState.m_61143_((Property)MultiBlockFourWay.FACING);
                if (facing == Direction.NORTH) {
                    return pos.m_7954_(Rotation.CLOCKWISE_90);
                }
                if (facing == Direction.SOUTH) {
                    return pos.m_7954_(Rotation.COUNTERCLOCKWISE_90);
                }
                if (facing == Direction.EAST) {
                    return pos.m_7954_(Rotation.CLOCKWISE_180);
                }
                return pos;
            })).originFromWorldSpace((NonnullBiFunction<BlockState, BlockPos, BlockPos>)((NonnullBiFunction)(blockState, pos) -> {
                Direction facing = (Direction)blockState.m_61143_((Property)MultiBlockFourWay.FACING);
                if (facing == Direction.NORTH) {
                    return pos.m_7954_(Rotation.CLOCKWISE_90);
                }
                if (facing == Direction.SOUTH) {
                    return pos.m_7954_(Rotation.COUNTERCLOCKWISE_90);
                }
                if (facing == Direction.EAST) {
                    return pos.m_7954_(Rotation.CLOCKWISE_180);
                }
                return pos;
            }));
        }

        public Builder placementStateModifier(NonnullQuadFunction<MultiBlockPattern, BlockPos, BlockState, Integer, BlockState> placementStateModifier) {
            this.placementStateModifier = placementStateModifier;
            return this;
        }

        public Builder placementPredicate(NonnullTriPredicate<LevelReader, BlockPos, BlockState> placementPredicate) {
            this.placementPredicate = placementPredicate;
            return this;
        }

        public Builder placeSoundPerBlock() {
            this.placeSoundPerBlock = true;
            return this;
        }

        public MultiBlockPattern build() {
            return new MultiBlockPattern(this);
        }
    }
}

