/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.net;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.Validate;
import xyz.apex.forge.apexcore.core.ApexCore;
import xyz.apex.forge.apexcore.lib.net.AbstractPacket;
import xyz.apex.forge.apexcore.lib.net.PacketHolder;
import xyz.apex.java.utility.nullness.NonnullPredicate;
import xyz.apex.java.utility.nullness.NonnullSupplier;

public final class NetworkManager {
    public static final PacketDistributor<ServerPlayer> ALL_EXCEPT = new PacketDistributor(NetworkManager::allExcept, NetworkDirection.PLAY_TO_CLIENT);
    private final SimpleChannel instance;
    private final BiMap<Class<? extends AbstractPacket>, Integer> packetIdMap = HashBiMap.create();
    private int packetIdCounter = 0;

    public NetworkManager(String modId, String channelName, String channelVersion) {
        this(modId, channelName, (NonnullSupplier<String>)((NonnullSupplier)() -> channelVersion), (NonnullPredicate<String>)((NonnullPredicate)channelVersion::equals), (NonnullPredicate<String>)((NonnullPredicate)channelVersion::equals));
    }

    public NetworkManager(String modId, String channelName, NonnullSupplier<String> channelVersionSupplier, NonnullPredicate<String> clientAcceptedVersions, NonnullPredicate<String> serverAcceptedVersions) {
        this.instance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modId, channelName)).clientAcceptedVersions(clientAcceptedVersions).serverAcceptedVersions(serverAcceptedVersions).networkProtocolVersion(channelVersionSupplier).simpleChannel();
        this.instance.registerMessage(0, PacketHolder.class, this::encodePacket, this::decodePacket, this::consumePacket);
    }

    public void registerPacket(Class<? extends AbstractPacket> packetType) {
        int packetId = this.packetIdCounter++;
        this.packetIdMap.put(packetType, (Object)packetId);
    }

    public void registerPackets(Class<? extends AbstractPacket> ... packetTypes) {
        Arrays.stream(packetTypes).forEach(this::registerPacket);
    }

    public void sendToServer(AbstractPacket packet) {
        this.instance.sendToServer((Object)new PacketHolder(packet));
    }

    public void sendTo(AbstractPacket packet, ServerPlayer player) {
        this.instance.sendTo((Object)new PacketHolder(packet), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendTo(AbstractPacket packet, PacketDistributor.PacketTarget packetTarget) {
        this.instance.send(packetTarget, (Object)new PacketHolder(packet));
    }

    public void reply(AbstractPacket packet, NetworkEvent.Context ctx) {
        this.instance.reply((Object)new PacketHolder(packet), ctx);
    }

    private void encodePacket(PacketHolder packet, FriendlyByteBuf buffer) {
        Class<?> packetType = packet.packet.getClass();
        Validate.isTrue((boolean)this.packetIdMap.containsKey(packetType), (String)"Attempt to encode unregistered PacketType: '%s'", (Object[])new Object[]{packetType});
        Integer packetId = (Integer)this.packetIdMap.get(packetType);
        buffer.writeInt(packetId.intValue());
        packet.packet.encode(buffer);
    }

    private PacketHolder decodePacket(FriendlyByteBuf buffer) {
        int packetId = buffer.readInt();
        Class packetType = (Class)this.packetIdMap.inverse().get((Object)packetId);
        AbstractPacket packet = null;
        try {
            packet = (AbstractPacket)packetType.getConstructor(FriendlyByteBuf.class).newInstance(buffer);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            ApexCore.LOGGER.error("Failed to decode PacketType: '{}'", (Object)packetType, (Object)e);
        }
        Validate.notNull(packet);
        return new PacketHolder(packet);
    }

    private void consumePacket(PacketHolder packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        packet.packet.process(this, ctx);
        ctx.setPacketHandled(true);
    }

    private static Consumer<Packet<?>> allExcept(PacketDistributor<ServerPlayer> packetDistributor, Supplier<ServerPlayer> playerSupplier) {
        return packet -> {
            ServerPlayer player = (ServerPlayer)playerSupplier.get();
            for (ServerPlayer otherPlayer : player.f_8924_.m_6846_().m_11314_()) {
                if (player.m_142081_().equals(otherPlayer.m_142081_())) continue;
                otherPlayer.f_8906_.m_141995_(packet);
            }
        };
    }
}

