/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.util.reflection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import xyz.apex.forge.apexcore.core.ApexCore;
import xyz.apex.forge.apexcore.lib.util.reflection.Methods;

public class MethodHelper {
    private static final Marker MARKER = MarkerManager.getMarker((String)"MethodReflection");
    private static final Cache<String, Method> methodsCache = CacheBuilder.newBuilder().weakValues().build();

    public static Method findMethod(Methods method) {
        Validate.notNull((Object)((Object)method), (String)"Method to find cannot be null", (Object[])new Object[0]);
        return MethodHelper.findMethod(method.getClassToAccess(), method.getMethodName(), method.getParameterTypes());
    }

    public static Method findMethod(Class<?> classToAccess, String methodName, @Nullable Class<?>[] parameterTypes) {
        Validate.notNull(classToAccess, (String)"Class to find method cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)methodName, (String)"Name of method to find cannot be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)methodName, (String)"Name of method to find cannot be empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)methodName, (String)"Name of method to find cannot be blank.", (Object[])new Object[0]);
        try {
            return (Method)methodsCache.get((Object)methodName, () -> MethodHelper.cacheMethod(classToAccess, methodName, parameterTypes));
        }
        catch (ExecutionException e) {
            throw new UnableToFindMethodException(e);
        }
    }

    private static Method cacheMethod(Class<?> classToAccess, String methodName, @Nullable Class<?>[] parameterTypes) {
        Validate.notNull(classToAccess, (String)"Class to find method cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)methodName, (String)"Name of method to find cannot be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)methodName, (String)"Name of method to find cannot be empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)methodName, (String)"Name of method to find cannot be blank", (Object[])new Object[0]);
        try {
            Method method = parameterTypes != null && parameterTypes.length > 0 ? classToAccess.getDeclaredMethod(methodName, parameterTypes) : classToAccess.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new UnableToFindMethodException(e);
        }
    }

    @Nullable
    public static <E> E invokeMethod(Methods method, @Nullable Object instance, Object ... parameters) {
        Validate.notNull((Object)((Object)method), (String)"Method to find cannot be null", (Object[])new Object[0]);
        return MethodHelper.invokeMethod(method.getClassToAccess(), instance, method.getMethodName(), method.getParameterTypes(), parameters);
    }

    @Nullable
    public static <E> E invokeMethod(Class<?> classToAccess, @Nullable Object instance, String methodName, @Nullable Class<?>[] parameterTypes, Object ... parameters) {
        Validate.notNull(classToAccess, (String)"Class to find method cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)methodName, (String)"Name of method to find cannot be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)methodName, (String)"Name of method to find cannot be empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)methodName, (String)"Name of method to find cannot be blank.", (Object[])new Object[0]);
        try {
            Method method = MethodHelper.findMethod(classToAccess, methodName, parameterTypes);
            if (parameters != null && parameters.length > 0) {
                Validate.notNull(parameterTypes, (String)"Parameters passed with no ParameterTypes", (Object[])new Object[0]);
                Validate.isTrue((parameterTypes.length == parameters.length ? 1 : 0) != 0, (String)"Parameters and ParameterTypes length must match", (Object[])new Object[0]);
                return (E)method.invoke(instance, parameters);
            }
            return (E)method.invoke(instance, new Object[0]);
        }
        catch (UnableToFindMethodException e) {
            ApexCore.LOGGER.error(MARKER, "Unable to locate method {} on type {}", (Object)methodName, (Object)classToAccess.getName(), (Object)e);
            throw e;
        }
        catch (InvocationTargetException e) {
            ApexCore.LOGGER.error(MARKER, "Unable to invoke method {} on type {}", (Object)methodName, (Object)classToAccess.getName(), (Object)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            ApexCore.LOGGER.error(MARKER, "Unable to locate method {} on type {}", (Object)methodName, (Object)classToAccess.getName(), (Object)e);
            throw new UnableToFindMethodException(e);
        }
    }

    public static String getObfuscatedMethodName(Methods method) {
        Validate.notNull((Object)((Object)method), (String)"Method cannot be null", (Object[])new Object[0]);
        String methodName = method.getMethodNameRaw();
        if (method.isObfuscated()) {
            return MethodHelper.getObfuscatedMethodName(methodName);
        }
        return methodName;
    }

    public static String getObfuscatedMethodName(String methodName) {
        Validate.notNull((Object)methodName, (String)"Name of method cannot be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)methodName, (String)"Name of method cannot be empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)methodName, (String)"Name of method cannot be blank.", (Object[])new Object[0]);
        return ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)methodName);
    }

    public static class UnableToFindMethodException
    extends RuntimeException {
        public UnableToFindMethodException(Throwable failed) {
            super(failed);
        }
    }
}

