/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.revamp.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xyz.apex.forge.apexcore.lib.util.NameableMutable;
import xyz.apex.forge.apexcore.revamp.block.entity.BaseBlockEntity;

public abstract class InventoryBlockEntity
extends BaseBlockEntity
implements NameableMutable {
    public static final String NBT_CUSTOM_NAME = "CustomName";
    public static final String NBT_INVENTORY = "Inventory";
    @Nullable
    private Component customName;
    protected final ItemStackHandler itemHandler;
    private final LazyOptional<IItemHandler> itemHandlerCapability = LazyOptional.of(this::getItemHandler);

    protected InventoryBlockEntity(BlockEntityType<? extends InventoryBlockEntity> blockEntityType, BlockPos pos, BlockState blockState, int slotCount) {
        super(blockEntityType, pos, blockState);
        this.itemHandler = new ItemStackHandler(slotCount);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public CompoundTag serializeData() {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.m_128365_(NBT_INVENTORY, (Tag)this.serializeInventory());
        if (this.customName != null) {
            tagCompound.m_128359_(NBT_CUSTOM_NAME, Component.Serializer.m_130703_((Component)this.customName));
        }
        return tagCompound;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void deserializeData(CompoundTag tagCompound) {
        if (tagCompound.m_128425_(NBT_INVENTORY, 10)) {
            this.deserializeInventory(tagCompound.m_128469_(NBT_INVENTORY));
        }
        if (tagCompound.m_128425_(NBT_CUSTOM_NAME, 8)) {
            this.setCustomName((Component)Component.Serializer.m_130701_((String)tagCompound.m_128461_(NBT_CUSTOM_NAME)));
        }
    }

    @OverridingMethodsMustInvokeSuper
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    @OverridingMethodsMustInvokeSuper
    public void m_7651_() {
        this.itemHandlerCapability.invalidate();
        super.m_7651_();
    }

    public final IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    private CompoundTag serializeInventory() {
        return this.itemHandler.serializeNBT();
    }

    private void deserializeInventory(CompoundTag tagCompound) {
        this.itemHandler.deserializeNBT(tagCompound);
        this.m_6596_();
    }

    public void writeContainerSyncData(FriendlyByteBuf buffer) {
    }

    public void readContainerSyncData(FriendlyByteBuf buffer) {
    }

    public final Component m_7755_() {
        return new TranslatableComponent(this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public final Component m_7770_() {
        return this.customName;
    }

    @Override
    public final void setCustomName(@Nullable Component customName) {
        this.customName = customName;
        this.m_6596_();
    }

    public final boolean m_8077_() {
        return this.customName != null;
    }

    public final Component m_5446_() {
        return this.customName == null ? this.m_7755_() : this.customName;
    }
}

