/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.block;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import xyz.apex.forge.apexcore.core.entity.SeatEntity;

public interface ISeatBlock {
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;

    default public String getOccupiedTranslationKey() {
        return "%s.occupied".formatted(((Block)this).m_7705_());
    }

    default public MutableComponent getOccupiedTranslation() {
        return new TranslatableComponent(this.getOccupiedTranslationKey());
    }

    default public InteractionResult useSeatBlock(BlockState blockState, Level level, BlockPos pos, Player player) {
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        BlockPos sitPos = this.getSeatSitPos(blockState, pos);
        if (ISeatBlock.isSeatOccupied(level, sitPos, player, this)) {
            player.m_5661_((Component)this.getOccupiedTranslation(), true);
            return InteractionResult.SUCCESS;
        }
        return this.trySitInSeat(level, pos, player);
    }

    default public double getSeatYOffset(BlockState blockState) {
        return 0.0;
    }

    default public BlockPos getSeatSitPos(BlockState blockState, BlockPos pos) {
        return pos;
    }

    default public InteractionResult trySitInSeat(Level level, BlockPos pos, Player player) {
        BlockState blockState = level.m_8055_(pos);
        BlockPos sitPos = this.getSeatSitPos(blockState, pos);
        if (SeatEntity.create(level, sitPos, this, player)) {
            ISeatBlock.setSeatOccupied(level, pos, true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    default public void setSeatOccupied(Level level, BlockPos pos, BlockState blockState, boolean occupied) {
        if (blockState.m_61138_((Property)OCCUPIED)) {
            level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(occupied)), 3);
        }
    }

    public static void setSeatOccupied(Level level, BlockPos pos, boolean occupied) {
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (block instanceof ISeatBlock) {
            ISeatBlock seat = (ISeatBlock)block;
            seat.setSeatOccupied(level, pos, blockState, occupied);
        }
    }

    public static boolean isSeatOccupied(Level level, BlockPos pos, Player sitter, ISeatBlock seatBlock) {
        BlockState blockState = level.m_8055_(pos);
        BlockPos seatPos = seatBlock.getSeatSitPos(blockState, pos);
        return level.m_8055_(seatPos).m_61145_((Property)OCCUPIED).orElse(false);
    }
}

