/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SingleItemRecipe
implements Recipe<Container> {
    public static final String JSON_GROUP = "group";
    public static final String JSON_INGREDIENT = "ingredient";
    public static final String JSON_RESULT = "result";
    public static final String JSON_COUNT = "count";
    protected final Ingredient recipeIngredient;
    protected final ItemStack recipeResult;
    protected final ResourceLocation recipeId;
    protected final String recipeGroup;
    private final RecipeType<?> recipeType;
    private final RecipeSerializer<?> recipeSerializer;

    public SingleItemRecipe(RecipeType<?> recipeType, RecipeSerializer<?> recipeSerializer, ResourceLocation recipeId, String recipeGroup, Ingredient recipeIngredient, ItemStack recipeResult) {
        this.recipeType = recipeType;
        this.recipeSerializer = recipeSerializer;
        this.recipeId = recipeId;
        this.recipeGroup = recipeGroup;
        this.recipeIngredient = recipeIngredient;
        this.recipeResult = recipeResult;
    }

    public final RecipeType<?> m_6671_() {
        return this.recipeType;
    }

    public final RecipeSerializer<?> m_7707_() {
        return this.recipeSerializer;
    }

    public final ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public final String m_6076_() {
        return this.recipeGroup;
    }

    public final ItemStack m_8043_() {
        return this.recipeResult;
    }

    public final NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)this.recipeIngredient);
        return ingredients;
    }

    public final boolean m_8004_(int width, int height) {
        return width + height >= 1;
    }

    public ItemStack m_5874_(Container inventory) {
        return this.recipeResult.m_41777_();
    }

    public boolean m_5818_(Container inventory, Level level) {
        return this.recipeIngredient.test(inventory.m_8020_(0));
    }

    public static final class Serializer<T extends SingleItemRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        private final IRecipeFactory<T> recipeFactory;

        public Serializer(IRecipeFactory<T> recipeFactory) {
            this.recipeFactory = recipeFactory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            String recipeGroup = GsonHelper.m_13851_((JsonObject)json, (String)SingleItemRecipe.JSON_GROUP, (String)"");
            Ingredient recipeIngredient = GsonHelper.m_13885_((JsonObject)json, (String)SingleItemRecipe.JSON_INGREDIENT) ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)SingleItemRecipe.JSON_INGREDIENT)) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)SingleItemRecipe.JSON_INGREDIENT));
            String recipeResultName = GsonHelper.m_13906_((JsonObject)json, (String)SingleItemRecipe.JSON_RESULT);
            int recipeResultCount = GsonHelper.m_13927_((JsonObject)json, (String)SingleItemRecipe.JSON_COUNT);
            ItemStack recipeResult = new ItemStack((ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation(recipeResultName)), recipeResultCount);
            return this.recipeFactory.create(recipeId, recipeGroup, recipeIngredient, recipeResult);
        }

        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String recipeGroup = buffer.m_130136_(Short.MAX_VALUE);
            Ingredient recipeIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack recipeResult = buffer.m_130267_();
            return this.recipeFactory.create(recipeId, recipeGroup, recipeIngredient, recipeResult);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            buffer.m_130070_(((SingleItemRecipe)recipe).recipeGroup);
            ((SingleItemRecipe)recipe).recipeIngredient.m_43923_(buffer);
            buffer.m_130055_(((SingleItemRecipe)recipe).recipeResult);
        }

        @FunctionalInterface
        public static interface IRecipeFactory<T extends SingleItemRecipe> {
            public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4);
        }
    }
}

