/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.repack.com.tterrag.registrate.builders;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;
import xyz.apex.repack.com.tterrag.registrate.AbstractRegistrate;
import xyz.apex.repack.com.tterrag.registrate.builders.Builder;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateLangProvider;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateTagsProvider;
import xyz.apex.repack.com.tterrag.registrate.util.entry.LazyRegistryEntry;
import xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullBiFunction;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullSupplier;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public abstract class AbstractBuilder<O extends AbstractRegistrate<O>, R extends IForgeRegistryEntry<R>, T extends R, P, S extends AbstractBuilder<O, R, T, P, S>>
implements Builder<O, R, T, P, S> {
    private final O owner;
    private final P parent;
    private final String name;
    private final BuilderCallback<O> callback;
    private final ResourceKey<? extends Registry<R>> registryKey;
    private boolean registeredMappingsEvent = false;
    private final Map<String, Map<String, RegistryEvent.MissingMappings.Action>> mappings = Maps.newHashMap();
    private final Multimap<ProviderType<? extends RegistrateTagsProvider<?>>, TagKey<?>> tagsByType = HashMultimap.create();
    private final LazyRegistryEntry<T> safeSupplier = new LazyRegistryEntry(this);

    @Deprecated
    public AbstractBuilder(O owner, P parent, String name, BuilderCallback<O> callback, Class<? super R> registryType) {
        this(owner, parent, name, callback, ((AbstractRegistrate)owner).getRegistryKeyByClass(registryType));
    }

    @Override
    @Deprecated
    public Class<? super R> getRegistryType() {
        return RegistryManager.ACTIVE.getRegistry(this.registryKey).getRegistrySuperType();
    }

    @NonnullType
    protected abstract T createEntry();

    @Override
    public RegistryEntry<T> register() {
        return this.callback.accept(this.name, this.registryKey, this, this::createEntry, this::createEntryWrapper);
    }

    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new RegistryEntry<T>((AbstractRegistrate<?>)this.getOwner(), delegate);
    }

    @Override
    public NonNullSupplier<T> asSupplier() {
        return this.safeSupplier;
    }

    @SafeVarargs
    public final S tag(ProviderType<? extends RegistrateTagsProvider<R>> type, TagKey<R> ... tags) {
        if (!this.tagsByType.containsKey(type)) {
            this.setData(type, (ctx, prov) -> this.tagsByType.get((Object)type).stream().map(t -> t).map(prov::m_206424_).forEach(b -> b.m_126582_((Object)((IForgeRegistryEntry)this.asSupplier().get()))));
        }
        this.tagsByType.putAll(type, Arrays.asList(tags));
        return (S)this;
    }

    @SafeVarargs
    public final S removeTag(ProviderType<RegistrateTagsProvider<R>> type, TagKey<R> ... tags) {
        if (this.tagsByType.containsKey(type)) {
            for (TagKey<R> tag : tags) {
                this.tagsByType.remove(type, tag);
            }
        }
        return (S)this;
    }

    public S lang(NonNullFunction<T, String> langKeyProvider) {
        return this.lang(langKeyProvider, (RegistrateLangProvider p, NonNullSupplier<? extends T> t) -> p.getAutomaticName((NonNullSupplier<? extends IForgeRegistryEntry<?>>)t));
    }

    public S lang(NonNullFunction<T, String> langKeyProvider, String name) {
        return this.lang(langKeyProvider, (RegistrateLangProvider p, NonNullSupplier<? extends T> s) -> name);
    }

    private S lang(NonNullFunction<T, String> langKeyProvider, NonNullBiFunction<RegistrateLangProvider, NonNullSupplier<? extends T>, String> localizedNameProvider) {
        return (S)((AbstractBuilder)this.setData(ProviderType.LANG, (ctx, prov) -> prov.add((String)langKeyProvider.apply(ctx.getEntry()), (String)localizedNameProvider.apply((RegistrateLangProvider)prov, ctx::getEntry))));
    }

    public AbstractBuilder(O owner, P parent, String name, BuilderCallback<O> callback, ResourceKey<? extends Registry<R>> registryKey) {
        this.owner = owner;
        this.parent = parent;
        this.name = name;
        this.callback = callback;
        this.registryKey = registryKey;
    }

    @Override
    public O getOwner() {
        return this.owner;
    }

    @Override
    public P getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected BuilderCallback<O> getCallback() {
        return this.callback;
    }

    @Override
    public ResourceKey<? extends Registry<R>> getRegistryKey() {
        return this.registryKey;
    }
}

