/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.repack.com.tterrag.registrate.builders;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import xyz.apex.repack.com.tterrag.registrate.AbstractRegistrate;
import xyz.apex.repack.com.tterrag.registrate.providers.DataGenContext;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateProvider;
import xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullConsumer;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullFunction;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullSupplier;

public interface Builder<O extends AbstractRegistrate<O>, R extends IForgeRegistryEntry<R>, T extends R, P, S extends Builder<O, R, T, P, S>>
extends NonNullSupplier<RegistryEntry<T>> {
    public RegistryEntry<T> register();

    public O getOwner();

    public P getParent();

    public String getName();

    @Deprecated
    public Class<? super R> getRegistryType();

    default public ResourceKey<? extends Registry<R>> getRegistryKey() {
        return RegistryManager.ACTIVE.getRegistry(this.getRegistryType()).getRegistryKey();
    }

    @Override
    default public RegistryEntry<T> get() {
        return ((AbstractRegistrate)this.getOwner()).get(this.getName(), this.getRegistryKey());
    }

    default public T getEntry() {
        return ((RegistryEntry)this.get()).get();
    }

    public NonNullSupplier<T> asSupplier();

    default public <D extends RegistrateProvider> S setData(ProviderType<? extends D> type, NonNullBiConsumer<DataGenContext<R, T>, D> cons) {
        ((AbstractRegistrate)this.getOwner()).setDataGenerator(this, type, prov -> cons.accept(DataGenContext.from(this, this.getRegistryKey()), prov));
        return (S)this;
    }

    default public <D extends RegistrateProvider> S addMiscData(ProviderType<? extends D> type, NonNullConsumer<? extends D> cons) {
        ((AbstractRegistrate)this.getOwner()).addDataGenerator(type, cons);
        return (S)this;
    }

    default public S onRegister(NonNullConsumer<? super T> callback) {
        ((AbstractRegistrate)this.getOwner()).addRegisterCallback(this.getName(), this.getRegistryKey(), callback);
        return (S)this;
    }

    default public <OR extends IForgeRegistryEntry<OR>> S onRegisterAfter(ResourceKey<? extends Registry<OR>> dependencyType, NonNullConsumer<? super T> callback) {
        return this.onRegister(e -> {
            if (((AbstractRegistrate)this.getOwner()).isRegistered(dependencyType)) {
                callback.accept(e);
            } else {
                ((AbstractRegistrate)this.getOwner()).addRegisterCallback(dependencyType, () -> callback.accept(e));
            }
        });
    }

    @Deprecated
    default public <OR extends IForgeRegistryEntry<OR>> S onRegisterAfter(Class<? super OR> dependencyType, NonNullConsumer<? super T> callback) {
        return this.onRegisterAfter(((AbstractRegistrate)this.getOwner()).getRegistryKeyByClass(dependencyType), callback);
    }

    default public <R2 extends IForgeRegistryEntry<R2>, T2 extends R2, P2, S2 extends Builder<O, R2, T2, P2, S2>> S2 transform(NonNullFunction<S, S2> func) {
        return (S2)((Builder)func.apply(this));
    }

    default public P build() {
        this.register();
        return this.getParent();
    }
}

