/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.repack.com.tterrag.registrate.builders;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.RegistryObject;
import xyz.apex.repack.com.tterrag.registrate.AbstractRegistrate;
import xyz.apex.repack.com.tterrag.registrate.builders.AbstractBuilder;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.providers.DataGenContext;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateItemModelProvider;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateRecipeProvider;
import xyz.apex.repack.com.tterrag.registrate.util.OneTimeEventReceiver;
import xyz.apex.repack.com.tterrag.registrate.util.entry.ItemEntry;
import xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullFunction;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullSupplier;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullUnaryOperator;

public class ItemBuilder<O extends AbstractRegistrate<O>, T extends Item, P>
extends AbstractBuilder<O, Item, T, P, ItemBuilder<O, T, P>> {
    private final NonNullFunction<Item.Properties, T> factory;
    private NonNullSupplier<Item.Properties> initialProperties = Item.Properties::new;
    private NonNullFunction<Item.Properties, Item.Properties> propertiesCallback = NonNullUnaryOperator.identity();
    @Nullable
    private NonNullSupplier<Supplier<ItemColor>> colorHandler;

    public static <O extends AbstractRegistrate<O>, T extends Item, P> ItemBuilder<O, T, P> create(O owner, P parent, String name, BuilderCallback<O> callback, NonNullFunction<Item.Properties, T> factory) {
        return ItemBuilder.create(owner, parent, name, callback, factory, null);
    }

    public static <O extends AbstractRegistrate<O>, T extends Item, P> ItemBuilder<O, T, P> create(O owner, P parent, String name, BuilderCallback<O> callback, NonNullFunction<Item.Properties, T> factory, @Nullable NonNullSupplier<? extends CreativeModeTab> tab) {
        return new ItemBuilder<O, T, P>(owner, parent, name, callback, factory).defaultModel().defaultLang().transform(ib -> tab == null ? ib : ib.tab(tab));
    }

    protected ItemBuilder(O owner, P parent, String name, BuilderCallback<O> callback, NonNullFunction<Item.Properties, T> factory) {
        super(owner, parent, name, callback, Registry.f_122904_);
        this.factory = factory;
    }

    public ItemBuilder<O, T, P> properties(NonNullUnaryOperator<Item.Properties> func) {
        this.propertiesCallback = this.propertiesCallback.andThen(func);
        return this;
    }

    public ItemBuilder<O, T, P> initialProperties(NonNullSupplier<Item.Properties> properties) {
        this.initialProperties = properties;
        return this;
    }

    public ItemBuilder<O, T, P> tab(NonNullSupplier<? extends CreativeModeTab> tab) {
        return this.properties(p -> p.m_41491_((CreativeModeTab)tab.get()));
    }

    public ItemBuilder<O, T, P> color(NonNullSupplier<Supplier<ItemColor>> colorHandler) {
        if (this.colorHandler == null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::registerItemColor);
        }
        this.colorHandler = colorHandler;
        return this;
    }

    protected void registerItemColor() {
        OneTimeEventReceiver.addModListener(ColorHandlerEvent.Item.class, e -> {
            NonNullSupplier<Supplier<ItemColor>> colorHandler = this.colorHandler;
            if (colorHandler != null) {
                e.getItemColors().m_92689_(colorHandler.get().get(), new ItemLike[]{(ItemLike)this.getEntry()});
            }
        });
    }

    public ItemBuilder<O, T, P> defaultModel() {
        return this.model((ctx, prov) -> prov.generated(ctx::getEntry));
    }

    public ItemBuilder<O, T, P> model(NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> cons) {
        return (ItemBuilder)this.setData(ProviderType.ITEM_MODEL, cons);
    }

    public ItemBuilder<O, T, P> defaultLang() {
        return (ItemBuilder)this.lang(Item::m_5524_);
    }

    public ItemBuilder<O, T, P> lang(String name) {
        return (ItemBuilder)this.lang(Item::m_5524_, name);
    }

    public ItemBuilder<O, T, P> recipe(NonNullBiConsumer<DataGenContext<Item, T>, RegistrateRecipeProvider> cons) {
        return (ItemBuilder)this.setData(ProviderType.RECIPE, cons);
    }

    @SafeVarargs
    public final ItemBuilder<O, T, P> tag(TagKey<Item> ... tags) {
        return (ItemBuilder)this.tag(ProviderType.ITEM_TAGS, tags);
    }

    @Override
    protected T createEntry() {
        Item.Properties properties = this.initialProperties.get();
        properties = this.propertiesCallback.apply(properties);
        return (T)((Item)this.factory.apply(properties));
    }

    @Override
    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new ItemEntry<T>((AbstractRegistrate<?>)this.getOwner(), delegate);
    }

    @Override
    public ItemEntry<T> register() {
        return (ItemEntry)super.register();
    }

    public ItemBuilder<O, T, P> food(FoodProperties foodProperties) {
        return this.properties(properties -> properties.m_41489_(foodProperties));
    }

    public ItemBuilder<O, T, P> stacksTo(int stackSize) {
        return this.properties(properties -> properties.m_41487_(stackSize));
    }

    public ItemBuilder<O, T, P> defaultDurability(int durability) {
        return this.properties(properties -> properties.m_41499_(durability));
    }

    public ItemBuilder<O, T, P> durability(int durability) {
        return this.properties(properties -> properties.m_41503_(durability));
    }

    @Deprecated
    public ItemBuilder<O, T, P> craftRemainder(Item craftRemainderItem) {
        return this.properties(properties -> properties.m_41495_(craftRemainderItem));
    }

    public ItemBuilder<O, T, P> craftRemainder(NonNullSupplier<ItemLike> craftRemainderItem) {
        return this.properties(properties -> properties.m_41495_(((ItemLike)craftRemainderItem.get()).m_5456_()));
    }

    public ItemBuilder<O, T, P> rarity(Rarity rarity) {
        return this.properties(properties -> properties.m_41497_(rarity));
    }

    public ItemBuilder<O, T, P> fireResistant() {
        return this.properties(Item.Properties::m_41486_);
    }

    public ItemBuilder<O, T, P> setNoRepair() {
        return this.properties(Item.Properties::setNoRepair);
    }
}

