/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.infusedfoods.block.entity;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.entity.InventoryBlockEntity;

public final class InfusionStationBlockEntity
extends InventoryBlockEntity
implements ContainerData {
    public static final String NBT_INFUSION_TIME = "InfusionTime";
    public static final String NBT_BLAZE_FUEL = "BlazeFuel";
    public static final String NBT_INFUSION_FLUID = "InfusionFluid";
    public static final String NBT_EFFECT = "Effect";
    public static final String NBT_AMOUNT = "Amount";
    public static final String NBT_DURATION = "Duration";
    public static final String NBT_AMPLIFIER = "Amplifier";
    public static final int SLOT_COUNT = 5;
    public static final int SLOT_POTION = 0;
    public static final int SLOT_BLAZE = 1;
    public static final int SLOT_FOOD = 2;
    public static final int SLOT_RESULT = 3;
    public static final int SLOT_BOTTLE = 4;
    public static final int DATA_SLOT_COUNT = 6;
    public static final int DATA_SLOT_EFFECT_AMOUNT = 0;
    public static final int DATA_SLOT_EFFECT_AMPLIFIER = 1;
    public static final int DATA_SLOT_EFFECT_DURATION = 2;
    public static final int DATA_SLOT_EFFECT_ID = 3;
    public static final int DATA_SLOT_INFUSE_TIME = 4;
    public static final int DATA_SLOT_BLAZE_FUEL = 5;
    public static final int INFUSION_TIME = 400;
    private int infuseTime = 0;
    private int blazeFuel = 0;
    @Nullable
    private MobEffect effect;
    private int effectAmount;
    private int effectDuration;
    private int effectAmplifier;

    public InfusionStationBlockEntity(BlockEntityType<? extends InfusionStationBlockEntity> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState, 5);
    }

    @Nullable
    public MobEffect getEffect() {
        return this.effect;
    }

    public int getEffectAmount() {
        return this.effectAmount;
    }

    public int getEffectAmplifier() {
        return this.effectAmplifier;
    }

    public CompoundTag serializeData() {
        CompoundTag tagCompound = super.serializeData();
        if (this.infuseTime > 0) {
            tagCompound.m_128405_(NBT_INFUSION_TIME, this.infuseTime);
        }
        if (this.blazeFuel > 0) {
            tagCompound.m_128405_(NBT_BLAZE_FUEL, this.blazeFuel);
        }
        if (this.effect != null) {
            CompoundTag fluidTag = new CompoundTag();
            String effectRegistryName = Objects.requireNonNull(this.effect.getRegistryName()).toString();
            fluidTag.m_128359_(NBT_EFFECT, effectRegistryName);
            fluidTag.m_128405_(NBT_AMOUNT, this.effectAmount);
            fluidTag.m_128405_(NBT_DURATION, this.effectDuration);
            fluidTag.m_128405_(NBT_AMPLIFIER, this.effectAmplifier);
            tagCompound.m_128365_(NBT_INFUSION_FLUID, (Tag)fluidTag);
        }
        return tagCompound;
    }

    public void deserializeData(CompoundTag tagCompound) {
        if (tagCompound.m_128425_(NBT_INFUSION_TIME, 99)) {
            this.infuseTime = tagCompound.m_128451_(NBT_INFUSION_TIME);
        }
        if (tagCompound.m_128425_(NBT_BLAZE_FUEL, 99)) {
            this.blazeFuel = tagCompound.m_128451_(NBT_BLAZE_FUEL);
        }
        if (tagCompound.m_128425_(NBT_INFUSION_FLUID, 10)) {
            CompoundTag fluidTag = tagCompound.m_128469_(NBT_INFUSION_FLUID);
            ResourceLocation effectRegistryName = new ResourceLocation(fluidTag.m_128461_(NBT_EFFECT));
            this.effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectRegistryName);
            this.effectAmount = fluidTag.m_128451_(NBT_AMOUNT);
            this.effectDuration = fluidTag.m_128451_(NBT_DURATION);
            this.effectAmplifier = fluidTag.m_128451_(NBT_AMPLIFIER);
        }
        super.deserializeData(tagCompound);
    }

    private boolean canInfuse() {
        if (this.effect == null || this.effectAmount < 0) {
            return false;
        }
        ItemStack food = this.itemHandler.getStackInSlot(2);
        if (food.m_41619_()) {
            return false;
        }
        if (!PotionUtils.m_43571_((ItemStack)food).isEmpty()) {
            return false;
        }
        ItemStack result = this.itemHandler.getStackInSlot(3);
        if (result.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_41746_((ItemStack)result, (ItemStack)food)) {
            return false;
        }
        List resultEffects = PotionUtils.m_43571_((ItemStack)result);
        if (resultEffects.size() == 1) {
            MobEffectInstance effectInstance = (MobEffectInstance)resultEffects.get(0);
            if (!Objects.equals(this.effect, effectInstance.m_19544_())) {
                return false;
            }
            if (this.effectDuration != effectInstance.m_19557_()) {
                return false;
            }
            if (this.effectAmplifier != effectInstance.m_19564_()) {
                return false;
            }
        }
        return result.m_41613_() + 1 < food.m_41741_();
    }

    public static int getColor(@Nullable MobEffect effect, int amplifier) {
        if (effect != null) {
            int l = amplifier + 1;
            if (l == 0) {
                return 0;
            }
            int k = effect.m_19484_();
            float f = (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            float f1 = (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            float f2 = (float)(l * (k >> 0 & 0xFF)) / 255.0f;
            f = f / (float)l * 255.0f;
            f1 = f1 / (float)l * 255.0f;
            f2 = f2 / (float)l * 255.0f;
            return (int)f << 16 | (int)f1 << 8 | (int)f2;
        }
        return 3694022;
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, InfusionStationBlockEntity blockEntity) {
        Potion potion;
        List effects;
        ItemStack potionStack = blockEntity.itemHandler.getStackInSlot(0);
        ItemStack foodStack = blockEntity.itemHandler.getStackInSlot(2);
        ItemStack blazeStack = blockEntity.itemHandler.getStackInSlot(1);
        ItemStack resultStack = blockEntity.itemHandler.getStackInSlot(3);
        ItemStack bottleStack = blockEntity.itemHandler.getStackInSlot(4);
        boolean changed = false;
        if (blockEntity.blazeFuel <= 0 && !blazeStack.m_41619_()) {
            blockEntity.blazeFuel = 20;
            blazeStack.m_41774_(1);
            changed = true;
        }
        if (blockEntity.infuseTime > 0 && !blockEntity.canInfuse()) {
            blockEntity.infuseTime = 0;
            changed = true;
        }
        if (blockEntity.effect != null && blockEntity.effectAmount > 0) {
            if (blockEntity.canInfuse() && blockEntity.blazeFuel > 0) {
                if (blockEntity.infuseTime == 0) {
                    --blockEntity.blazeFuel;
                    blockEntity.infuseTime = 400;
                    changed = true;
                } else {
                    --blockEntity.infuseTime;
                    if (blockEntity.infuseTime == 0) {
                        if (resultStack.m_41619_()) {
                            ItemStack foodToInfuse = foodStack.m_41620_(1).m_41777_();
                            foodToInfuse.m_41764_(1);
                            PotionUtils.m_43552_((ItemStack)foodToInfuse, Collections.singletonList(new MobEffectInstance(blockEntity.effect, blockEntity.effectDuration, blockEntity.effectAmplifier)));
                            blockEntity.itemHandler.setStackInSlot(3, foodToInfuse);
                        } else {
                            foodStack.m_41774_(1);
                            resultStack.m_41769_(1);
                        }
                        --blockEntity.effectAmount;
                    }
                    changed = true;
                }
            }
        } else if (!potionStack.m_41619_() && (effects = (potion = PotionUtils.m_43579_((ItemStack)potionStack)).m_43488_()).size() == 1) {
            MobEffectInstance effectInstance = (MobEffectInstance)effects.get(0);
            blockEntity.effect = effectInstance.m_19544_();
            blockEntity.effectAmplifier = effectInstance.m_19564_();
            blockEntity.effectDuration = effectInstance.m_19557_();
            blockEntity.effectAmount = 5;
            blockEntity.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
            if (bottleStack.m_41619_()) {
                blockEntity.itemHandler.setStackInSlot(4, Items.f_42590_.m_7968_());
            } else {
                bottleStack.m_41769_(1);
            }
            blockEntity.infuseTime = 0;
            changed = true;
        }
        if (changed) {
            blockEntity.m_6596_();
        }
    }

    public int m_6413_(int slot) {
        return switch (slot) {
            case 1 -> this.effectAmplifier;
            case 0 -> this.effectAmount;
            case 2 -> this.effectDuration;
            case 3 -> {
                if (this.effect == null) {
                    yield -1;
                }
                yield Registry.f_122823_.m_7447_((Object)this.effect);
            }
            case 4 -> this.infuseTime;
            case 5 -> this.blazeFuel;
            default -> -1;
        };
    }

    public void m_8050_(int slot, int value) {
        switch (slot) {
            case 1: {
                this.effectAmplifier = value;
                break;
            }
            case 0: {
                this.effectAmount = value;
                break;
            }
            case 2: {
                this.effectDuration = value;
                break;
            }
            case 4: {
                this.infuseTime = value;
                break;
            }
            case 5: {
                this.blazeFuel = value;
                break;
            }
            case 3: {
                if (value >= 0) {
                    this.effect = Registry.f_122823_.m_203300_(value).map(Holder::m_203334_).orElse(null);
                    break;
                }
                this.effect = null;
                break;
            }
        }
    }

    public int m_6499_() {
        return 6;
    }
}

