/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.infusedfoods.client.renderer.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import xyz.apex.forge.infusedfoods.init.IFRegistry;

public final class InfusionStationModel
extends Model {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(IFRegistry.INSTANCE.id("infusion_station"), "main");
    private final ModelPart infusionStation;
    private int potionColor = 3694022;

    public InfusionStationModel(ModelPart root) {
        super(RenderType::m_110470_);
        this.infusionStation = root.m_171324_("infusion_station");
    }

    public InfusionStationModel(BlockEntityRendererProvider.Context ctx) {
        this(ctx.m_173582_(LAYER_LOCATION));
    }

    public void setUpForRender(boolean hasPotion, boolean hasBottle, boolean hasFluid, boolean hasFood, int potionColor) {
        this.potionColor = potionColor;
        this.infusionStation.f_104207_ = true;
        this.infusionStation.m_171331_().forEach(part -> {
            part.f_104207_ = true;
        });
        ModelPart potion = this.infusionStation.m_171324_("potion");
        ModelPart potionTint = this.infusionStation.m_171324_("potion_tint");
        ModelPart apple = this.infusionStation.m_171324_("apple");
        potion.f_104207_ = hasPotion || hasBottle || hasFluid;
        apple.f_104207_ = hasFood;
        potionTint.f_104207_ = false;
    }

    public void m_7695_(PoseStack pose, VertexConsumer builder, int packedLight, int packedOverlay, float r, float g, float b, float a) {
        this.renderToBufferTint(pose, builder, packedLight, packedOverlay, r, g, b, a, false);
    }

    public void renderToBufferTint(PoseStack pose, VertexConsumer builder, int packedLight, int packedOverlay, float r, float g, float b, float a, boolean tint) {
        if (tint) {
            ModelPart potion = this.infusionStation.m_171324_("potion");
            if (potion.f_104207_) {
                ModelPart potionTint = this.infusionStation.m_171324_("potion_tint");
                float pRed = (float)(this.potionColor >> 16 & 0xFF) / 255.0f;
                float pGreen = (float)(this.potionColor >> 8 & 0xFF) / 255.0f;
                float pBlue = (float)(this.potionColor & 0xFF) / 255.0f;
                potionTint.f_104207_ = true;
                potionTint.m_104306_(pose, builder, packedLight, packedOverlay, pRed, pGreen, pBlue, a);
            }
        } else {
            this.infusionStation.m_104306_(pose, builder, packedLight, packedOverlay, r, g, b, a);
        }
    }

    public static LayerDefinition createDefinition() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition infusion_station = partDefinition.m_171599_("infusion_station", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        PartDefinition base = infusion_station.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.0f, -1.0f, 0.0f, 12.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)8.0f, (float)-3.0f));
        PartDefinition blaze_rod = infusion_station.m_171599_("blaze_rod", CubeListBuilder.m_171558_().m_171514_(14, 13).m_171488_(-6.0f, -14.0f, 2.0f, 2.0f, 14.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)8.0f, (float)-3.0f));
        PartDefinition potion = infusion_station.m_171599_("potion", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.5f, -3.5f, 0.0f, 5.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 10).m_171488_(0.0f, -3.5f, -2.5f, 0.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)3.5f, (float)0.0f));
        PartDefinition spout = infusion_station.m_171599_("spout", CubeListBuilder.m_171558_().m_171514_(16, 7).m_171488_(-6.0f, -6.0f, 0.0f, 6.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 29).m_171488_(0.0f, -6.0f, 0.0f, 6.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)0.0f, (float)0.0f));
        PartDefinition apple = infusion_station.m_171599_("apple", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(-2.8543f, 0.3528f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.3543f, -0.6472f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.8543f, (float)2.6472f, (float)0.0f));
        PartDefinition apple_3_r1 = apple.m_171599_("apple_3_r1", CubeListBuilder.m_171558_().m_171514_(0, 1).m_171488_(0.0f, -1.5f, -0.5f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition potionTint = infusion_station.m_171599_("potion_tint", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.5f, -3.5f, 0.0f, 5.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 10).m_171488_(0.0f, -3.5f, -2.5f, 0.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)3.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }
}

