/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.infusedfoods.container;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.container.BaseMenu;
import xyz.apex.forge.infusedfoods.block.entity.InfusionStationBlockEntity;
import xyz.apex.forge.infusedfoods.init.IFElements;

public final class InfusionStationMenu
extends BaseMenu {
    public final Player player;
    public final IItemHandler itemHandler;
    private final DataSlot effectAmount;
    private final DataSlot effectAmplifier;
    private final DataSlot effectDuration;
    private final DataSlot effectId;
    private final DataSlot infuseTime;
    private final DataSlot blazeFuel;

    public InfusionStationMenu(MenuType<? extends InfusionStationMenu> menuType, int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        super(menuType, windowId, playerInventory, buffer);
        this.player = playerInventory.f_35978_;
        this.itemHandler = Objects.requireNonNull(this.getItemHandler());
        this.m_38897_((Slot)new PotionSlot());
        this.m_38897_((Slot)new BlazeSlot());
        this.m_38897_((Slot)new FoodSlot());
        this.m_38897_((Slot)new ResultSlot());
        this.m_38897_((Slot)new BottleSlot());
        InfusionStationMenu.bindPlayerInventory((BaseMenu)this, (int)8, (int)84);
        InfusionStationBlockEntity blockEntity = (InfusionStationBlockEntity)((Object)IFElements.INFUSION_STATION_BLOCK_ENTITY.get((BlockGetter)this.player.f_19853_, this.pos).orElseThrow());
        this.effectAmount = this.m_38895_(DataSlot.m_39403_((ContainerData)blockEntity, (int)0));
        this.effectAmplifier = this.m_38895_(DataSlot.m_39403_((ContainerData)blockEntity, (int)1));
        this.effectDuration = this.m_38895_(DataSlot.m_39403_((ContainerData)blockEntity, (int)2));
        this.effectId = this.m_38895_(DataSlot.m_39403_((ContainerData)blockEntity, (int)3));
        this.infuseTime = this.m_38895_(DataSlot.m_39403_((ContainerData)blockEntity, (int)4));
        this.blazeFuel = this.m_38895_(DataSlot.m_39403_((ContainerData)blockEntity, (int)5));
    }

    public int getEffectAmount() {
        return this.effectAmount.m_6501_();
    }

    public int getEffectAmplifier() {
        return this.effectAmplifier.m_6501_();
    }

    public int getEffectDuration() {
        return this.effectDuration.m_6501_();
    }

    public int getInfuseTime() {
        return this.infuseTime.m_6501_();
    }

    public int getBlazeFuel() {
        return this.blazeFuel.m_6501_();
    }

    @Nullable
    public MobEffect getEffect() {
        int effectId = this.effectId.m_6501_();
        return effectId < 0 ? null : (MobEffect)Registry.f_122823_.m_203300_(effectId).map(Holder::m_203334_).orElse(null);
    }

    @Nullable
    public IItemHandler getItemHandler() {
        BlockEntity blockEntity = Objects.requireNonNull(this.player.f_19853_.m_7702_(this.pos));
        return InfusionStationMenu.getItemHandlerFromBlockEntity((BlockEntity)blockEntity).resolve().orElse(null);
    }

    protected void onInventoryChanges() {
        super.onInventoryChanges();
        this.setBlockEntityChanged();
    }

    private final class PotionSlot
    extends SlotItemHandler {
        private PotionSlot() {
            super(InfusionStationMenu.this.itemHandler, 0, 27, 8);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            if (stack.m_41720_() != Items.f_42589_) {
                return false;
            }
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            return potion.m_43488_().size() == 1;
        }
    }

    private final class BlazeSlot
    extends SlotItemHandler {
        private BlazeSlot() {
            super(InfusionStationMenu.this.itemHandler, 1, 46, 8);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return stack.m_41720_() == Items.f_42593_;
        }
    }

    private final class FoodSlot
    extends SlotItemHandler {
        private FoodSlot() {
            super(InfusionStationMenu.this.itemHandler, 2, 90, 22);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            if (!stack.m_41614_()) {
                return false;
            }
            List customEffects = PotionUtils.m_43571_((ItemStack)stack);
            return customEffects.isEmpty();
        }
    }

    private final class ResultSlot
    extends SlotItemHandler {
        private ResultSlot() {
            super(InfusionStationMenu.this.itemHandler, 3, 134, 22);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }
    }

    private final class BottleSlot
    extends SlotItemHandler {
        private BottleSlot() {
            super(InfusionStationMenu.this.itemHandler, 4, 8, 51);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }
    }
}

