/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.BaseMultiBlock;
import xyz.apex.forge.apexcore.lib.block.IMultiBlock;

@Mod.EventBusSubscriber(modid="apexcore", value={Dist.CLIENT})
public final class MultiBlockVisualizer {
    @Nullable
    private static MultiBufferSource.BufferSource ghostBuffers = null;
    private static boolean renderOutline = false;

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelLastEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (player != null && level != null) {
            PoseStack pose = event.getPoseStack();
            for (InteractionHand hand : InteractionHand.values()) {
                if (MultiBlockVisualizer.renderBlockFromHand(mc, pose, level, hand, player)) break;
            }
        }
    }

    private static boolean renderBlockFromHand(Minecraft mc, PoseStack pose, ClientLevel level, InteractionHand hand, LocalPlayer player) {
        ItemStack stack = player.m_21120_(hand);
        Block block = Block.m_49814_((Item)stack.m_41720_());
        if (block instanceof IMultiBlock) {
            IMultiBlock multiBlock = (IMultiBlock)block;
            HitResult hitResult = mc.f_91077_;
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult result = (BlockHitResult)hitResult;
                BlockPos blockPos = result.m_82425_();
                if (level.m_46859_(blockPos)) {
                    return false;
                }
                BlockPos renderPos = blockPos.m_121945_(result.m_82434_());
                BlockPlaceContext placeContext = new BlockPlaceContext((Level)level, (Player)player, hand, stack, result);
                BlockState placeState = block.m_5573_(placeContext);
                if (placeState == null) {
                    Direction direction;
                    Direction horizontalFacing = placeContext.m_8125_().m_122424_();
                    if (block instanceof BaseMultiBlock) {
                        BaseMultiBlock base = (BaseMultiBlock)block;
                        direction = base.getFourWayFacing(placeContext);
                    } else {
                        direction = horizontalFacing;
                    }
                    Direction facing = direction;
                    facing = facing == null ? horizontalFacing : facing;
                    placeState = block.m_49966_();
                    placeState = BaseMultiBlock.setFacing(placeState, facing);
                    placeState = multiBlock.setMultiBlockIndex(placeState, 0);
                }
                placeState = BaseMultiBlock.setWaterLogged(placeState, false);
                Vec3 position = mc.m_91290_().f_114358_.m_90583_();
                MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
                RenderType type = RenderType.m_110504_();
                if (ghostBuffers == null) {
                    ghostBuffers = MultiBlockVisualizer.initBuffers(buffers);
                }
                pose.m_85836_();
                pose.m_85837_(-position.f_82479_, -position.f_82480_, -position.f_82481_);
                if (renderOutline) {
                    VertexConsumer consumer = buffers.m_6299_(type);
                    MultiBlockVisualizer.renderBlockWithOutline(mc, pose, ghostBuffers, consumer, level, renderPos, placeState, multiBlock);
                    buffers.m_109912_(type);
                } else {
                    MultiBlockVisualizer.renderBlockWithoutOutline(mc, pose, ghostBuffers, level, renderPos, placeState, multiBlock);
                }
                ghostBuffers.m_109911_();
                pose.m_85849_();
                return true;
            }
        }
        return false;
    }

    private static void renderBlockWithOutline(Minecraft mc, PoseStack pose, MultiBufferSource.BufferSource bufferSource, VertexConsumer vertexConsumer, ClientLevel level, BlockPos pos, BlockState blockState, IMultiBlock multiBlock) {
        BlockPos origin = multiBlock.getMultiBlockOriginPos(blockState, pos);
        List<BlockPos> localPositions = multiBlock.getMultiBlockLocalPositions();
        boolean isValid = true;
        for (int i = 0; i < localPositions.size(); ++i) {
            BlockPos localPos = localPositions.get(i);
            BlockPos worldPos = multiBlock.getMultiBlockWorldSpaceFromLocalSpace(blockState, origin, localPos);
            BlockState renderState = multiBlock.setMultiBlockIndex(blockState, i);
            BlockState worldState = level.m_8055_(worldPos);
            if (multiBlock.getMultiBlockPattern().passesPlacementTests(multiBlock, (LevelReader)level, worldPos, renderState, worldState)) continue;
            isValid = false;
            break;
        }
        int overlay = isValid ? OverlayTexture.f_118083_ : OverlayTexture.m_118093_((int)0, (int)3);
        for (int i = 0; i < localPositions.size(); ++i) {
            BlockPos localPos = localPositions.get(i);
            BlockPos worldPos = multiBlock.getMultiBlockWorldSpaceFromLocalSpace(blockState, origin, localPos);
            BlockState renderState = multiBlock.setMultiBlockIndex(blockState, i);
            MultiBlockVisualizer.renderBlockStateWithOutline(mc, pose, bufferSource, vertexConsumer, level, overlay, worldPos, renderState, multiBlock);
        }
    }

    private static void renderBlockWithoutOutline(Minecraft mc, PoseStack pose, MultiBufferSource.BufferSource bufferSource, ClientLevel level, BlockPos pos, BlockState blockState, IMultiBlock multiBlock) {
        BlockPos origin = multiBlock.getMultiBlockOriginPos(blockState, pos);
        List<BlockPos> localPositions = multiBlock.getMultiBlockLocalPositions();
        boolean isValid = true;
        for (int i = 0; i < localPositions.size(); ++i) {
            BlockPos localPos = localPositions.get(i);
            BlockPos worldPos = multiBlock.getMultiBlockWorldSpaceFromLocalSpace(blockState, origin, localPos);
            BlockState renderState = multiBlock.setMultiBlockIndex(blockState, i);
            BlockState worldState = level.m_8055_(worldPos);
            if (multiBlock.getMultiBlockPattern().passesPlacementTests(multiBlock, (LevelReader)level, worldPos, renderState, worldState)) continue;
            isValid = false;
            break;
        }
        int overlay = isValid ? OverlayTexture.f_118083_ : OverlayTexture.m_118093_((int)0, (int)3);
        for (int i = 0; i < localPositions.size(); ++i) {
            BlockPos localPos = localPositions.get(i);
            BlockPos worldPos = multiBlock.getMultiBlockWorldSpaceFromLocalSpace(blockState, origin, localPos);
            BlockState renderState = multiBlock.setMultiBlockIndex(blockState, i);
            MultiBlockVisualizer.renderBlockStateWithoutOutline(mc, pose, bufferSource, overlay, worldPos, renderState);
        }
    }

    private static void renderBlockStateWithOutline(Minecraft mc, PoseStack pose, MultiBufferSource.BufferSource bufferSource, VertexConsumer vertexConsumer, ClientLevel level, int overlay, BlockPos pos, BlockState blockState, IMultiBlock multiBlock) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (multiBlock.isMultiBlockOrigin(blockState)) {
            pose.m_85836_();
            MultiBlockVisualizer.renderHitOutline(pose, vertexConsumer, level, pos, blockState, 0.0f, 0.0f, 0.0f, 0.4f);
            pose.m_85849_();
        }
        pose.m_85837_((double)x, (double)y, (double)z);
        if (blockState.m_60799_() == RenderShape.MODEL) {
            pose.m_85836_();
            mc.m_91289_().renderSingleBlock(blockState, pose, (MultiBufferSource)bufferSource, 240, overlay, ModelData.EMPTY, null);
            pose.m_85849_();
        }
        pose.m_85837_((double)(-x), (double)(-y), (double)(-z));
    }

    private static void renderBlockStateWithoutOutline(Minecraft mc, PoseStack pose, MultiBufferSource.BufferSource bufferSource, int overlay, BlockPos pos, BlockState blockState) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        pose.m_85837_((double)x, (double)y, (double)z);
        if (blockState.m_60799_() == RenderShape.MODEL) {
            pose.m_85836_();
            mc.m_91289_().renderSingleBlock(blockState, pose, (MultiBufferSource)bufferSource, 240, overlay, ModelData.EMPTY, null);
            pose.m_85849_();
        }
        pose.m_85837_((double)(-x), (double)(-y), (double)(-z));
    }

    private static MultiBufferSource.BufferSource initBuffers(MultiBufferSource.BufferSource original) {
        Object2ObjectLinkedOpenHashMap remapped = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry entry : original.f_109905_.entrySet()) {
            remapped.put((Object)GhostRenderLayer.remap((RenderType)entry.getKey()), (Object)((BufferBuilder)entry.getValue()));
        }
        return new GhostBuffers(original.f_109904_, (Map<RenderType, BufferBuilder>)remapped);
    }

    private static void renderHitOutline(PoseStack pose, VertexConsumer consumer, ClientLevel level, BlockPos pos, BlockState blockState, float r, float g, float b, float a) {
        PoseStack.Pose last = pose.m_85850_();
        blockState.m_60808_((BlockGetter)level, pos).m_83224_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            float f = (float)(maxX - minX);
            float f1 = (float)(maxY - minY);
            float f2 = (float)(maxZ - minZ);
            float f3 = Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
            consumer.m_85982_(last.m_85861_(), (float)(minX + (double)pos.m_123341_()), (float)(minY + (double)pos.m_123342_()), (float)(minZ + (double)pos.m_123343_())).m_85950_(r, g, b, a).m_85977_(last.m_85864_(), f /= f3, f1 /= f3, f2 /= f3).m_5752_();
            consumer.m_85982_(last.m_85861_(), (float)(maxX + (double)pos.m_123341_()), (float)(maxY + (double)pos.m_123342_()), (float)(maxZ + (double)pos.m_123343_())).m_85950_(r, g, b, a).m_85977_(last.m_85864_(), f, f1, f2).m_5752_();
        });
    }

    private static final class GhostRenderLayer
    extends RenderType {
        private static final Map<RenderType, RenderType> remappedTypes = new IdentityHashMap<RenderType, RenderType>();

        public GhostRenderLayer(RenderType original) {
            super("%s_%s_ghost".formatted(original, "apexcore"), original.m_110508_(), original.m_173186_(), original.m_110507_(), original.m_110405_(), true, () -> {
                original.m_110185_();
                RenderSystem.m_69465_();
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.65f);
            }, () -> {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_69461_();
                RenderSystem.m_69482_();
                original.m_110188_();
            });
        }

        public static RenderType remap(RenderType in) {
            if (in instanceof GhostRenderLayer) {
                return in;
            }
            return remappedTypes.computeIfAbsent(in, GhostRenderLayer::new);
        }
    }

    private static final class GhostBuffers
    extends MultiBufferSource.BufferSource {
        private GhostBuffers(BufferBuilder fallback, Map<RenderType, BufferBuilder> buffers) {
            super(fallback, buffers);
        }

        public VertexConsumer m_6299_(RenderType renderType) {
            return super.m_6299_(GhostRenderLayer.remap(renderType));
        }
    }
}

