/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.entity.BaseBlockEntity;

public abstract class InventoryBlockEntity
extends BaseBlockEntity.WithCustomName {
    public static final String NBT_INVENTORY = "Inventory";
    protected final ItemStackHandler itemHandler;
    private final LazyOptional<IItemHandler> itemHandlerCapability = LazyOptional.of(this::getItemHandler);

    protected InventoryBlockEntity(BlockEntityType<? extends InventoryBlockEntity> blockEntityType, BlockPos pos, BlockState blockState, int slotCount) {
        super((BlockEntityType<? extends BaseBlockEntity.WithCustomName>)blockEntityType, pos, blockState);
        this.itemHandler = new ItemStackHandler(slotCount);
    }

    @Override
    @MustBeInvokedByOverriders
    public CompoundTag serializeData() {
        CompoundTag tagCompound = super.serializeData();
        tagCompound.m_128365_(NBT_INVENTORY, (Tag)this.serializeInventory());
        return tagCompound;
    }

    @Override
    @MustBeInvokedByOverriders
    public void deserializeData(CompoundTag tagCompound) {
        if (tagCompound.m_128425_(NBT_INVENTORY, 10)) {
            this.deserializeInventory(tagCompound.m_128469_(NBT_INVENTORY));
        }
        super.deserializeData(tagCompound);
    }

    @MustBeInvokedByOverriders
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    @MustBeInvokedByOverriders
    public void m_7651_() {
        this.itemHandlerCapability.invalidate();
        super.m_7651_();
    }

    public final IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    private CompoundTag serializeInventory() {
        return this.itemHandler.serializeNBT();
    }

    private void deserializeInventory(CompoundTag tagCompound) {
        this.itemHandler.deserializeNBT(tagCompound);
    }

    public void writeContainerSyncData(FriendlyByteBuf buffer) {
    }

    public void readContainerSyncData(FriendlyByteBuf buffer) {
    }
}

