/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.infusedfoods;

import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.util.EventBusHelper;
import xyz.apex.forge.infusedfoods.client.renderer.model.InfusionStationModel;
import xyz.apex.forge.infusedfoods.init.IFRegistry;

@Mod(value="infusedfoods")
public final class InfusedFoods {
    public InfusedFoods() {
        IFRegistry.bootstrap();
        EventBusHelper.addListener(LivingEntityUseItemEvent.Finish.class, this::onItemUseFinish);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Client::new);
    }

    private void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        LivingEntity entity = event.getEntity();
        ItemStack stack = event.getResultStack();
        if (entity.f_19853_.m_5776_()) {
            return;
        }
        if (InfusedFoods.isValidFood(stack)) {
            List effects = PotionUtils.m_43571_((ItemStack)stack);
            for (MobEffectInstance effectInstance : effects) {
                MobEffect effect = effectInstance.m_19544_();
                if (effect.m_8093_()) {
                    effect.m_19461_((Entity)entity, (Entity)entity, entity, effectInstance.m_19564_(), 1.0);
                    continue;
                }
                if (entity.m_21023_(effect)) {
                    entity.m_21195_(effect);
                }
                entity.m_7292_(effectInstance);
            }
        }
    }

    public static boolean isValidFood(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41614_();
    }

    public static void appendPotionEffectTooltips(@Nullable MobEffect effect, int amplifier, int duration, List<Component> tooltip) {
        if (effect != null) {
            MutableComponent potionName = Component.m_237115_((String)effect.m_19481_());
            if (amplifier > 0) {
                potionName = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{potionName, Component.m_237115_((String)("potion.potency." + amplifier))});
            }
            if (duration > 20) {
                int i = Mth.m_14143_((float)duration);
                String durationFormat = StringUtil.m_14404_((int)i);
                potionName = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{potionName, durationFormat});
            }
            tooltip.add((Component)potionName.m_130940_(effect.m_19483_().m_19497_()));
            Map attributeModifiers = effect.m_19485_();
            if (!attributeModifiers.isEmpty()) {
                tooltip.add((Component)Component.m_237119_());
                tooltip.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
                attributeModifiers.forEach((attribute, attributeModifier) -> {
                    AttributeModifier mod = attributeModifier;
                    AttributeModifier mod1 = new AttributeModifier(mod.m_22214_(), effect.m_7048_(amplifier, mod), mod.m_22217_());
                    double d0 = mod1.m_22218_();
                    AttributeModifier.Operation operation = mod1.m_22217_();
                    double d1 = operation != AttributeModifier.Operation.MULTIPLY_BASE && operation != AttributeModifier.Operation.MULTIPLY_TOTAL ? d0 : d0 * 100.0;
                    if (d0 > 0.0) {
                        tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + operation.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)attribute.m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    } else if (d0 < 0.0) {
                        tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.take." + operation.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)attribute.m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    }
                });
            }
        }
    }

    public static void appendPotionEffectTooltips(ItemStack stack, List<Component> tooltip) {
        CompoundTag apexTag;
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag != null && stackTag.m_128425_("ApexData", 10) && (apexTag = stackTag.m_128469_("ApexData")).m_128425_("InfusionFluid", 10)) {
            CompoundTag fluidTag = apexTag.m_128469_("InfusionFluid");
            ResourceLocation effectRegistryName = new ResourceLocation(fluidTag.m_128461_("Effect"));
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectRegistryName);
            int effectDuration = fluidTag.m_128451_("Duration");
            int effectAmplifier = fluidTag.m_128451_("Amplifier");
            InfusedFoods.appendPotionEffectTooltips(effect, effectAmplifier, effectDuration, tooltip);
        }
    }

    private static final class Client {
        private Client() {
            EventBusHelper.addListener(ItemTooltipEvent.class, this::onItemTooltip);
            EventBusHelper.addListener(EntityRenderersEvent.RegisterLayerDefinitions.class, event -> event.registerLayerDefinition(InfusionStationModel.LAYER_LOCATION, InfusionStationModel::createDefinition));
        }

        private void onItemTooltip(ItemTooltipEvent event) {
            List effects;
            ItemStack stack = event.getItemStack();
            List tooltip = event.getToolTip();
            if (InfusedFoods.isValidFood(stack) && !(effects = PotionUtils.m_43571_((ItemStack)stack)).isEmpty()) {
                PotionUtils.m_43555_((ItemStack)stack, (List)tooltip, (float)1.0f);
            }
        }
    }
}

