/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.infusedfoods.container;

import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.container.BaseMenu;

public final class InfusionStationMenu
extends BaseMenu {
    public final Player player;
    public final IItemHandler itemHandler = Objects.requireNonNull(this.getItemHandler());

    public InfusionStationMenu(MenuType<? extends InfusionStationMenu> menuType, int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        super(menuType, windowId, playerInventory, buffer);
        this.player = playerInventory.f_35978_;
        this.m_38897_((Slot)new PotionSlot());
        this.m_38897_((Slot)new BlazeSlot());
        this.m_38897_((Slot)new FoodSlot());
        this.m_38897_((Slot)new ResultSlot());
        this.m_38897_((Slot)new BottleSlot());
        InfusionStationMenu.bindPlayerInventory((BaseMenu)this, (int)8, (int)84);
    }

    @Nullable
    public IItemHandler getItemHandler() {
        BlockEntity blockEntity = Objects.requireNonNull(this.player.f_19853_.m_7702_(this.pos));
        return InfusionStationMenu.getItemHandlerFromBlockEntity((BlockEntity)blockEntity).resolve().orElse(null);
    }

    protected void onInventoryChanges() {
        super.onInventoryChanges();
        this.setBlockEntityChanged();
    }

    private final class PotionSlot
    extends SlotItemHandler {
        private PotionSlot() {
            super(InfusionStationMenu.this.itemHandler, 0, 27, 8);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            if (stack.m_41720_() != Items.f_42589_) {
                return false;
            }
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            return potion.m_43488_().size() == 1;
        }
    }

    private final class BlazeSlot
    extends SlotItemHandler {
        private BlazeSlot() {
            super(InfusionStationMenu.this.itemHandler, 1, 46, 8);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return stack.m_41720_() == Items.f_42593_;
        }
    }

    private final class FoodSlot
    extends SlotItemHandler {
        private FoodSlot() {
            super(InfusionStationMenu.this.itemHandler, 2, 90, 22);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            if (!stack.m_41614_()) {
                return false;
            }
            List customEffects = PotionUtils.m_43571_((ItemStack)stack);
            return customEffects.isEmpty();
        }
    }

    private final class ResultSlot
    extends SlotItemHandler {
        private ResultSlot() {
            super(InfusionStationMenu.this.itemHandler, 3, 134, 22);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }
    }

    private final class BottleSlot
    extends SlotItemHandler {
        private BottleSlot() {
            super(InfusionStationMenu.this.itemHandler, 4, 8, 51);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }
    }
}

