/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.instant;

import com.slymask3.instantblocks.block.BlockInstant;
import com.slymask3.instantblocks.reference.GuiID;
import com.slymask3.instantblocks.tileentity.TileEntitySchematic;
import com.slymask3.instantblocks.util.BuildHelper;
import com.slymask3.instantblocks.util.SchematicHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockInstantSchematic
extends BlockInstant {
    public static IIcon top;
    public static IIcon side;

    public BlockInstantSchematic() {
        super("instantSchematic", Material.field_151575_d, Block.field_149766_f, 1.5f);
        this.func_149658_d("instantblocks:harvest_side_0");
        this.setGuiID(GuiID.SCHEMATIC);
    }

    @Override
    public void func_149651_a(IIconRegister ir) {
        top = ir.func_94245_a("instantblocks:schematic_top");
        side = ir.func_94245_a("instantblocks:schematic_side");
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0) {
            return Blocks.field_150344_f.func_149691_a(0, 5);
        }
        if (side == 1) {
            return top;
        }
        return BlockInstantSchematic.side;
    }

    @Override
    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntitySchematic();
    }

    public boolean build(World world, int x, int y, int z, String schematicName, boolean center, boolean ignoreAir) {
        SchematicHelper.Schematic schematic = SchematicHelper.readSchematic(schematicName);
        if (schematic != null) {
            BuildHelper.setBlock(world, x, y, z, Blocks.field_150350_a);
            BlockInstantSchematic.buildSchematic(world, x, y, z, schematic, center, ignoreAir);
            return true;
        }
        return false;
    }

    public static void buildSchematic(World world, int X, int Y, int Z, SchematicHelper.Schematic schematic, boolean center, boolean ignoreAir) {
        int width = schematic.width;
        int height = schematic.height;
        int length = schematic.length;
        byte[] block = schematic.blocks;
        byte[] meta = schematic.data;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index = y * width * length + z * width + x;
                    if ((block[index] & 0xFF) != 0 && ignoreAir) {
                        if (center) {
                            BuildHelper.setBlock(world, x + X - width / 2, y + Y, z + Z - length / 2, Block.func_149729_e((int)(block[index] & 0xFF)), meta[index], 2);
                            continue;
                        }
                        BuildHelper.setBlock(world, x + X, y + Y, z + Z, Block.func_149729_e((int)(block[index] & 0xFF)), meta[index], 2);
                        continue;
                    }
                    if (ignoreAir) continue;
                    if (center) {
                        BuildHelper.setBlock(world, x + X - width / 2, y + Y, z + Z - length / 2, Block.func_149729_e((int)(block[index] & 0xFF)), meta[index], 2);
                        continue;
                    }
                    BuildHelper.setBlock(world, x + X, y + Y, z + Z, Block.func_149729_e((int)(block[index] & 0xFF)), meta[index], 2);
                }
            }
        }
    }
}

