/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.instant;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.slymask3.instantblocks.block.BlockInstant;
import com.slymask3.instantblocks.reference.GuiID;
import com.slymask3.instantblocks.tileentity.TileEntityStatue;
import com.slymask3.instantblocks.util.BuildHelper;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockInstantStatue
extends BlockInstant {
    public static IIcon bottom;
    public static IIcon top;
    public static IIcon sidel;
    public static IIcon sider;
    public static IIcon front;
    public static IIcon back;

    public BlockInstantStatue() {
        super("instantStatue", Material.field_151575_d, Block.field_149766_f, 1.5f);
        this.func_149658_d("instantblocks:statue_front");
        this.setGuiID(GuiID.STATUE);
    }

    @Override
    public void func_149651_a(IIconRegister ir) {
        bottom = ir.func_94245_a("instantblocks:statue_bottom");
        top = ir.func_94245_a("instantblocks:statue_top");
        sidel = ir.func_94245_a("instantblocks:statue_side_l");
        sider = ir.func_94245_a("instantblocks:statue_side_r");
        front = ir.func_94245_a("instantblocks:statue_front");
        back = ir.func_94245_a("instantblocks:statue_back");
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 2 || meta == 6) {
            if (side == 0) {
                return bottom;
            }
            if (side == 1) {
                return top;
            }
            if (side == 2) {
                return front;
            }
            if (side == 3) {
                return back;
            }
            if (side == 4) {
                return sidel;
            }
            if (side == 5) {
                return sider;
            }
        } else if (meta == 0 || meta == 4) {
            if (side == 0) {
                return bottom;
            }
            if (side == 1) {
                return top;
            }
            if (side == 2) {
                return back;
            }
            if (side == 3) {
                return front;
            }
            if (side == 4) {
                return sider;
            }
            if (side == 5) {
                return sidel;
            }
        } else if (meta == 1 || meta == 5) {
            if (side == 0) {
                return bottom;
            }
            if (side == 1) {
                return top;
            }
            if (side == 2) {
                return sider;
            }
            if (side == 3) {
                return sidel;
            }
            if (side == 4) {
                return front;
            }
            if (side == 5) {
                return back;
            }
        } else if (meta == 3 || meta == 7) {
            if (side == 0) {
                return bottom;
            }
            if (side == 1) {
                return top;
            }
            if (side == 2) {
                return sidel;
            }
            if (side == 3) {
                return sider;
            }
            if (side == 4) {
                return back;
            }
            if (side == 5) {
                return front;
            }
        }
        return this.field_149761_L;
    }

    @Override
    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityStatue();
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack is) {
        int meta = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        world.func_72921_c(x, y, z, meta, 2);
    }

    public Skin getSkin(String username) {
        if (!username.equalsIgnoreCase("")) {
            try {
                JsonObject metadata;
                GsonBuilder builder = new GsonBuilder();
                builder.setPrettyPrinting();
                Gson gson = builder.create();
                String user_api_contents = BlockInstantStatue.get_contents("https://api.mojang.com/users/profiles/minecraft/" + username);
                JsonObject user_json = (JsonObject)gson.fromJson(user_api_contents, JsonObject.class);
                String uuid = user_json.get("id").getAsString();
                String uuid_api_contents = BlockInstantStatue.get_contents("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid);
                JsonObject uuid_json = (JsonObject)gson.fromJson(uuid_api_contents, JsonObject.class);
                String base64 = uuid_json.get("properties").getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString();
                String base64_decoded = new String(Base64.getDecoder().decode(base64));
                JsonObject image_json = (JsonObject)gson.fromJson(base64_decoded, JsonObject.class);
                JsonObject skin_json = image_json.get("textures").getAsJsonObject().get("SKIN").getAsJsonObject();
                String image_url = skin_json.get("url").getAsString();
                Skin skin = new Skin(ImageIO.read(new URL(image_url)));
                if (skin_json.has("metadata") && (metadata = skin_json.get("metadata").getAsJsonObject()).has("model") && metadata.get("model").getAsString().equalsIgnoreCase("slim")) {
                    skin.setSlim(true);
                }
                return skin;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean build(World world, int x, int y, int z, EntityPlayer player, String username, boolean head, boolean body, boolean armLeft, boolean armRight, boolean legLeft, boolean legRight, boolean rgb) {
        int meta = world.func_72805_g(x, y, z);
        Skin skin = this.getSkin(username);
        if (skin != null) {
            BufferedImage img = skin.getImage();
            BuildHelper.setBlock(world, x, y, z, Blocks.field_150350_a);
            BlockInstantStatue.buildHead(world, x, y, z, img, meta, head, rgb);
            BlockInstantStatue.buildBody(world, x, y, z, img, meta, body, rgb);
            BlockInstantStatue.buildLegs(world, x, y, z, img, meta, legLeft, legRight, rgb);
            if (skin.isSlim()) {
                BlockInstantStatue.buildArmsSlim(world, x, y, z, img, meta, armLeft, armRight, rgb);
            } else {
                BlockInstantStatue.buildArms(world, x, y, z, img, meta, armLeft, armRight, rgb);
            }
            return true;
        }
        return false;
    }

    private static String get_contents(String url_string) {
        StringBuilder content = new StringBuilder();
        try {
            String line;
            URL url = new URL(url_string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                content.append(line + "\n");
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content.toString();
    }

    private static void buildHead(World world, int x, int y, int z, BufferedImage img, int meta, boolean build, boolean rgb) {
        if (build) {
            int ytimes;
            int xtimes;
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 31, z, img, 8 + xtimes, 0 + ytimes, meta, -5 + ytimes, -4 + xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 24, z, img, 16 + xtimes, 0 + ytimes, meta, -5 + ytimes, -4 + xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 31 - ytimes, z, img, 0 + xtimes, 8 + ytimes, meta, -5 + xtimes, -4, rgb);
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 31 - ytimes, z, img, 16 + xtimes, 8 + ytimes, meta, 2 - xtimes, 3, rgb);
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 31 - ytimes, z, img, 8 + xtimes, 8 + ytimes, meta, 2, -4 + xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 31 - ytimes, z, img, 24 + xtimes, 8 + ytimes, meta, -5, 3 - xtimes, rgb);
                }
            }
        }
    }

    private static void buildBody(World world, int x, int y, int z, BufferedImage img, int meta, boolean build, boolean rgb) {
        if (build) {
            int ytimes;
            int xtimes;
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23, z, img, 20 + xtimes, 16 + ytimes, meta, -3 + ytimes, -4 + xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 12, z, img, 28 + xtimes, 16 + ytimes, meta, -ytimes, -4 + xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 16 + xtimes, 20 + ytimes, meta, -3 + xtimes, -4, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 28 + xtimes, 20 + ytimes, meta, -xtimes, 3, rgb);
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 20 + xtimes, 20 + ytimes, meta, 0, -4 + xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 32 + xtimes, 20 + ytimes, meta, -3, 3 - xtimes, rgb);
                }
            }
        }
    }

    private static void buildArms(World world, int x, int y, int z, BufferedImage img, int meta, boolean buildLeft, boolean buildRight, boolean rgb) {
        int ytimes;
        int xtimes;
        if (buildLeft) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 48 + xtimes, 20 + ytimes, meta, -xtimes, 4, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 40 + xtimes, 20 + ytimes, meta, -3 + xtimes, 7, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23, z, img, 44 + xtimes, 16 + ytimes, meta, -3 + ytimes, 4 + xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 12, z, img, 48 + xtimes, 16 + ytimes, meta, -3 + ytimes, 4 + xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 44 + xtimes, 20 + ytimes, meta, 0, 7 - xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 52 + xtimes, 20 + ytimes, meta, -3, 4 + xtimes, rgb);
                }
            }
        }
        if (buildRight) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 48 + xtimes, 20 + ytimes, meta, -xtimes, -5, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 40 + xtimes, 20 + ytimes, meta, -3 + xtimes, -8, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23, z, img, 44 + xtimes, 16 + ytimes, meta, -3 + ytimes, -5 - xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 12, z, img, 48 + xtimes, 16 + ytimes, meta, -3 + ytimes, -5 - xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 44 + xtimes, 20 + ytimes, meta, 0, -8 + xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 52 + xtimes, 20 + ytimes, meta, -3, -5 - xtimes, rgb);
                }
            }
        }
    }

    private static void buildArmsSlim(World world, int x, int y, int z, BufferedImage img, int meta, boolean buildLeft, boolean buildRight, boolean rgb) {
        int ytimes;
        int xtimes;
        if (buildLeft) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 47 + xtimes, 20 + ytimes, meta, -xtimes, 4, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 40 + xtimes, 20 + ytimes, meta, -3 + xtimes, 6, rgb);
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23, z, img, 44 + xtimes, 16 + ytimes, meta, -3 + ytimes, 4 + xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 12, z, img, 47 + xtimes, 16 + ytimes, meta, -3 + ytimes, 4 + xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 44 + xtimes, 20 + ytimes, meta, 0, 6 - xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 51 + xtimes, 20 + ytimes, meta, -3, 4 + xtimes, rgb);
                }
            }
        }
        if (buildRight) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 48 + xtimes, 20 + ytimes, meta, -xtimes, -5, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 40 + xtimes, 20 + ytimes, meta, -3 + xtimes, -7, rgb);
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23, z, img, 44 + xtimes, 16 + ytimes, meta, -3 + ytimes, -5 - xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 12, z, img, 47 + xtimes, 16 + ytimes, meta, -3 + ytimes, -5 - xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 44 + xtimes, 20 + ytimes, meta, 0, -7 + xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 23 - ytimes, z, img, 51 + xtimes, 20 + ytimes, meta, -3, -5 - xtimes, rgb);
                }
            }
        }
    }

    private static void buildLegs(World world, int x, int y, int z, BufferedImage img, int meta, boolean buildLeft, boolean buildRight, boolean rgb) {
        int ytimes;
        int xtimes;
        if (buildLeft) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 11, z, img, 4 + xtimes, 16 + ytimes, meta, -3 + ytimes, xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y, z, img, 8 + xtimes, 16 + ytimes, meta, -3 + ytimes, xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 11 - ytimes, z, img, 8 + xtimes, 20 + ytimes, meta, -xtimes, 3, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 11 - ytimes, z, img, 0 + xtimes, 20 + ytimes, meta, -3 + xtimes, 0, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 11 - ytimes, z, img, 4 + xtimes, 20 + ytimes, meta, 0, xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 11 - ytimes, z, img, 12 + xtimes, 20 + ytimes, meta, -3, 3 - xtimes, rgb);
                }
            }
        }
        if (buildRight) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 11, z, img, 4 + xtimes, 16 + ytimes, meta, -3 + ytimes, -4 + xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y, z, img, 8 + xtimes, 16 + ytimes, meta, -3 + ytimes, -4 + xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 11 - ytimes, z, img, 8 + xtimes, 20 + ytimes, meta, -xtimes, -1, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 11 - ytimes, z, img, 0 + xtimes, 20 + ytimes, meta, -3 + xtimes, -4, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 11 - ytimes, z, img, 4 + xtimes, 20 + ytimes, meta, 0, -1 - xtimes, rgb);
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    BuildHelper.setColorBlockComplex(world, x, y + 11 - ytimes, z, img, 12 + xtimes, 20 + ytimes, meta, -3, -4 + xtimes, rgb);
                }
            }
        }
    }

    public static class Skin {
        private final BufferedImage image;
        private boolean slim;

        public Skin(BufferedImage image) {
            this.image = image;
            this.slim = false;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public boolean isSlim() {
            return this.slim;
        }

        public void setSlim(boolean slim) {
            this.slim = slim;
        }
    }
}

