/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.gui.instant;

import com.slymask3.instantblocks.InstantBlocks;
import com.slymask3.instantblocks.block.instant.BlockInstantSchematic;
import com.slymask3.instantblocks.gui.GuiInstant;
import com.slymask3.instantblocks.gui.module.GuiSchematicSlot;
import com.slymask3.instantblocks.network.PacketSchematic;
import com.slymask3.instantblocks.tileentity.TileEntitySchematic;
import com.slymask3.instantblocks.util.BuildHelper;
import com.slymask3.instantblocks.util.IBHelper;
import com.slymask3.instantblocks.util.SchematicHelper;
import cpw.mods.fml.client.config.GuiCheckBox;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class GuiSchematic
extends GuiInstant {
    private final TileEntitySchematic tileEntity;
    private GuiSchematicSlot schematicList;
    private int selected = -1;
    private ArrayList<String> schematics;
    private GuiTextField input;
    private GuiCheckBox center;
    private GuiCheckBox ignoreAir;

    public GuiSchematic(EntityPlayer player, TileEntitySchematic entity, World world, int x, int y, int z) {
        super(player, world, x, y, z);
        this.tileEntity = entity;
    }

    @Override
    public void init() {
        this.center = new GuiCheckBox(this.getID(), this.field_146294_l / 2 - 4 - 150, this.field_146295_m / 4 + 4 + 12, "Generate the schematic from the center.", false);
        this.field_146292_n.add(this.center);
        this.ignoreAir = new GuiCheckBox(this.getID(), this.field_146294_l / 2 - 4 - 150, this.field_146295_m / 4 + 14 + 12, "Ignore generating air. (Could prevent lag)", false);
        this.field_146292_n.add(this.ignoreAir);
        this.input = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 4 - 150, 50, 308, 20);
        this.input.func_146180_a("");
        this.input.func_146195_b(true);
        this.schematicList = new GuiSchematicSlot(this, this.schematics, this.field_146294_l / 2 - 4 - 150, this.field_146295_m / 4 + 42 + 12, 308, 62);
        this.schematicList.registerScrollButtons(this.field_146292_n, 7, 8);
        this.done.field_146124_l = false;
    }

    public void func_73876_c() {
        this.input.func_146178_a();
    }

    @Override
    public void typed(char character, int key) {
        if ("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ^&'@{}[],$=!-#()%.+~_ ".indexOf(character) >= 0 || key == 14) {
            this.input.func_146201_a(character, key);
        }
        File f = new File("schematics/" + this.input.func_146179_b() + ".schematic");
        this.done.field_146124_l = f.isFile();
    }

    protected void func_73864_a(int x, int y, int click) {
        super.func_73864_a(x, y, click);
        this.input.func_146192_a(x, y, click);
    }

    @Override
    public void draw(int par1, int par2, float par3) {
        this.func_73732_a(this.field_146289_q, "Instant Schematic Block", this.field_146294_l / 2, 20, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "Enter a Schematic File Name:", this.field_146294_l / 2 - 4 - 150, 37, 0xA0A0A0);
        this.schematics = new ArrayList();
        ArrayList<File> all = new ArrayList<File>();
        this.addTree(new File("schematics/"), all);
        Object[] schems = all.toArray();
        for (int i = 0; i < all.size(); ++i) {
            String schem = schems[i].toString().replaceAll("schematics", "").replaceAll("\\\\", "").replaceAll(".schematic", "");
            this.schematics.add(schem);
        }
        this.schematicList.updateFiles(this.schematics);
        this.schematicList.drawScreen(par1, par2, par3);
        GuiSchematic.func_73734_a((int)(this.field_146294_l / 2 - 4 - 150), (int)(this.field_146295_m / 4 + 29 + 12), (int)(this.field_146294_l / 2 - 4 - 150 + 308), (int)(this.field_146295_m / 4 + 29 + 12 + 13), (int)-16777216);
        GuiSchematic.func_73734_a((int)(this.field_146294_l / 2 - 4 - 150), (int)(this.field_146295_m / 4 + 29 + 12 + 75), (int)(this.field_146294_l / 2 - 4 - 150 + 308), (int)(this.field_146295_m / 4 + 29 + 12 + 88), (int)-16777216);
        File f = new File("schematics/" + this.input.func_146179_b() + ".schematic");
        if (f.isFile()) {
            this.func_73731_b(this.field_146289_q, "File: '.minecraft/schematics/" + this.input.func_146179_b() + ".schematic'", this.field_146294_l / 2 - 2 - 150, this.field_146295_m / 4 + 41 + 12 + 65, 65280);
        } else {
            this.func_73731_b(this.field_146289_q, "File: '.minecraft/schematics/" + this.input.func_146179_b() + ".schematic'", this.field_146294_l / 2 - 2 - 150, this.field_146295_m / 4 + 41 + 12 + 65, 0xAA0000);
        }
        this.func_73731_b(this.field_146289_q, "Found " + all.size() + " schematic files:", this.field_146294_l / 2 - 2 - 150, this.field_146295_m / 4 + 31 + 12, 0xFFFFFF);
        if (all.size() == 0) {
            this.func_73731_b(this.field_146289_q, "Put .schematic files into the 'schematics' folder in .minecraft.", this.field_146294_l / 2 - 3 - 150, this.field_146295_m / 4 + 60 + 12, 0xAA0000);
            this.func_73731_b(this.field_146289_q, "If the 'schematics' folder doesn't exit, create it.", this.field_146294_l / 2 - 3 - 150, this.field_146295_m / 4 + 70 + 12, 0xAA0000);
            this.func_73731_b(this.field_146289_q, "Files will update here right away, no need to restart.", this.field_146294_l / 2 - 3 - 150, this.field_146295_m / 4 + 80 + 12, 0xAA0000);
        }
        this.input.func_146194_f();
        this.done.field_146124_l = f.isFile();
    }

    private void addTree(File file, Collection<File> all) {
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                all.add(child);
                this.addTree(child, all);
            }
        }
    }

    @Override
    public void sendInfo() {
        InstantBlocks.packetPipeline.sendToServer(new PacketSchematic(this.world, this.x, this.y, this.z, this.input.func_146179_b(), this.center.isChecked(), this.ignoreAir.isChecked()));
        BlockInstantSchematic block = (BlockInstantSchematic)BuildHelper.getBlock(this.world, this.x, this.y, this.z);
        if (SchematicHelper.readSchematic(this.input.func_146179_b()) != null) {
            block.setCreateMessage("Instant Schematic created from the file %schematic%.".replace("%schematic%", this.input.func_146179_b()));
            block.afterBuild(this.world, this.x, this.y, this.z, this.player);
        } else {
            IBHelper.msg(this.player, "Error creating schematic from the file %schematic%.".replace("%schematic%", this.input.func_146179_b()), "\u00a7c");
        }
    }

    public void selectSchematicIndex(int index) {
        this.selected = index;
        if (index >= 0 && index <= this.schematics.size()) {
            this.input.func_146180_a(this.schematics.get(this.selected));
        }
        File f = new File("schematics/" + this.input.func_146179_b() + ".schematic");
        this.done.field_146124_l = f.isFile();
    }

    public boolean schematicIndexSelected(int var1) {
        return var1 == this.selected;
    }
}

