/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.util;

import com.slymask3.instantblocks.block.instant.BlockInstantHouseWood;
import com.slymask3.instantblocks.init.ModBlocks;
import com.slymask3.instantblocks.tileentity.TileEntityColor;
import com.slymask3.instantblocks.util.Colors;
import com.slymask3.instantblocks.util.IBHelper;
import com.slymask3.instantblocks.util.LogHelper;
import java.awt.image.BufferedImage;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BuildHelper {
    public static void setBlock(World world, int x, int y, int z, Block block) {
        BuildHelper.setBlock(world, x, y, z, block, 0, 2);
    }

    public static void setBlock(World world, int x, int y, int z, Block block, int meta, int flag) {
        if (BuildHelper.getBlock(world, x, y, z) != Blocks.field_150357_h) {
            world.func_147465_d(x, y, z, block, meta, flag);
        }
    }

    public static void setColorBlock(World world, int x, int y, int z, int color) {
        BuildHelper.setBlock(world, x, y, z, ModBlocks.color);
        try {
            ((TileEntityColor)world.func_147438_o((int)x, (int)y, (int)z)).color = color;
        }
        catch (Exception e) {
            LogHelper.info(e);
        }
        world.func_147471_g(x, y, z);
    }

    public static Block getBlock(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z);
    }

    public static void build(World world, int x, int y, int z, Block block, int xTimesTotal, int yTimesTotal, int zTimesTotal) {
        BuildHelper.build(world, x, y, z, block, 0, 2, xTimesTotal, yTimesTotal, zTimesTotal);
    }

    public static void build(World world, int x, int y, int z, Block block, int meta, int xTimesTotal, int yTimesTotal, int zTimesTotal) {
        BuildHelper.build(world, x, y, z, block, meta, 2, xTimesTotal, yTimesTotal, zTimesTotal);
    }

    public static void build(World world, int x, int y, int z, Block block, int meta, int flag, int xTimesTotal, int yTimesTotal, int zTimesTotal) {
        int z2 = z;
        int x2 = x;
        for (int yTimes = 0; yTimes < yTimesTotal; ++yTimes) {
            for (int zTimes = 0; zTimes < zTimesTotal; ++zTimes) {
                for (int xTimes = 0; xTimes < xTimesTotal; ++xTimes) {
                    BuildHelper.setBlock(world, x2, y, z2, block, meta, flag);
                    ++z2;
                }
                z2 = z;
                ++x2;
            }
            x2 = x;
            ++y;
        }
    }

    public static void ifNoBlockThenStop(World world, int x, int y, int z, Block block, EntityPlayer player, String blockName) {
        if (BuildHelper.getBlock(world, x, y, z) != block) {
            IBHelper.msg(player, "Missing: %block% at (%x%x, %y%y, %z%z).".replace("%block%", blockName).replace("%x%", String.valueOf(x)).replace("%y%", String.valueOf(y)).replace("%z%", String.valueOf(z)), "\u00a7c");
            BlockInstantHouseWood.notThere = true;
        }
    }

    public static void setBlockDirectional(World world, int x, int y, int z, Block block, int metaDirection, int forward, int back, int left, int right) {
        BuildHelper.setBlockDirectional(world, x, y, z, block, metaDirection, forward, back, left, right, 0, 1);
    }

    public static void setBlockDirectional(World world, int x, int y, int z, Block block, int metaDirection, int forward, int back, int left, int right, int meta, int flag) {
        if (metaDirection == 0) {
            BuildHelper.setBlock(world, x - left + right, y, z - forward + back, block, meta, flag);
        } else if (metaDirection == 1) {
            BuildHelper.setBlock(world, x + forward - back, y, z - left + right, block, meta, flag);
        } else if (metaDirection == 2) {
            BuildHelper.setBlock(world, x + left - right, y, z + forward - back, block, meta, flag);
        } else if (metaDirection == 3) {
            BuildHelper.setBlock(world, x - forward + back, y, z + left - right, block, meta, flag);
        }
    }

    public static void buildDirectional(World world, int x, int y, int z, Block block, int metaDirection, int forward, int back, int left, int right, int forwardX, int backX, int leftX, int rightX, int upX, int downX) {
        BuildHelper.buildDirectional(world, x, y, z, block, metaDirection, forward, back, left, right, forwardX, backX, leftX, rightX, upX, downX, 0, 1);
    }

    public static void buildDirectional(World world, int x, int y, int z, Block block, int metaDirection, int forward, int back, int left, int right, int forwardX, int backX, int leftX, int rightX, int upX, int downX, int meta, int flag) {
        int x1 = x;
        int z1 = z;
        int x2 = x;
        int z2 = z;
        int y1 = y;
        int y2 = y1 + upX - downX;
        if (metaDirection == 0) {
            x1 = x - left + right;
            z1 = z - forward + back;
            x2 = x1 - leftX + rightX;
            z2 = z1 - forwardX + backX;
        } else if (metaDirection == 1) {
            x1 = x + forward - back;
            z1 = z - left + right;
            x2 = x1 + forwardX - backX;
            z2 = z1 - leftX + rightX;
        } else if (metaDirection == 2) {
            x1 = x + left - right;
            z1 = z + forward - back;
            x2 = x1 + leftX - rightX;
            z2 = z1 + forwardX - backX;
        } else if (metaDirection == 3) {
            x1 = x - forward + back;
            z1 = z + left - right;
            x2 = x1 - forwardX + backX;
            z2 = z1 + leftX - rightX;
        }
        int xDif = IBHelper.toPositive(x1 - x2);
        int yDif = IBHelper.toPositive(y1 - y2);
        int zDif = IBHelper.toPositive(z1 - z2);
        int x_cur = x1;
        int y_cur = y1;
        int z_cur = z1;
        int bx = x1;
        int bz = z1;
        for (int i = 0; i < yDif + 1; ++i) {
            for (int j = 0; j < zDif + 1; ++j) {
                for (int k = 0; k < xDif + 1; ++k) {
                    BuildHelper.setBlock(world, x_cur, y_cur, z_cur, block, meta, flag);
                    if (IBHelper.isPositive(x1 - x2)) {
                        --x_cur;
                        continue;
                    }
                    ++x_cur;
                }
                x_cur = bx;
                if (IBHelper.isPositive(z1 - z2)) {
                    --z_cur;
                    continue;
                }
                ++z_cur;
            }
            z_cur = bz;
            if (IBHelper.isPositive(y1 - y2)) {
                --y_cur;
                continue;
            }
            ++y_cur;
        }
    }

    public static void setColorBlockComplex(World world, int x, int y, int z, BufferedImage img, int imgx, int imgy, int metaDirection, int forwardBack, int leftRight, boolean rgb) {
        if (rgb) {
            int left;
            int right;
            int forward;
            int back;
            if (IBHelper.isPositive(forwardBack)) {
                back = forwardBack;
                forward = 0;
            } else {
                back = 0;
                forward = IBHelper.toPositive(forwardBack);
            }
            if (IBHelper.isPositive(leftRight)) {
                right = 0;
                left = leftRight;
            } else {
                right = IBHelper.toPositive(leftRight);
                left = 0;
            }
            if (metaDirection == 0) {
                BuildHelper.setBlock(world, x + left - right, y, z - forward + back, ModBlocks.color);
                ((TileEntityColor)world.func_147438_o((int)(x + left - right), (int)y, (int)(z - forward + back))).color = img.getRGB(imgx, imgy);
                world.func_147471_g(x + left - right, y, z - forward + back);
            } else if (metaDirection == 1) {
                BuildHelper.setBlock(world, x + forward - back, y, z + left - right, ModBlocks.color);
                ((TileEntityColor)world.func_147438_o((int)(x + forward - back), (int)y, (int)(z + left - right))).color = img.getRGB(imgx, imgy);
                world.func_147471_g(x + forward - back, y, z + left - right);
            } else if (metaDirection == 2) {
                BuildHelper.setBlock(world, x - left + right, y, z + forward - back, ModBlocks.color);
                ((TileEntityColor)world.func_147438_o((int)(x - left + right), (int)y, (int)(z + forward - back))).color = img.getRGB(imgx, imgy);
                world.func_147471_g(x - left + right, y, z + forward - back);
            } else if (metaDirection == 3) {
                BuildHelper.setBlock(world, x - forward + back, y, z - left + right, ModBlocks.color);
                ((TileEntityColor)world.func_147438_o((int)(x - forward + back), (int)y, (int)(z - left + right))).color = img.getRGB(imgx, imgy);
                world.func_147471_g(x - forward + back, y, z - left + right);
            }
        } else {
            int left;
            int right;
            int forward;
            int back;
            if (IBHelper.isPositive(forwardBack)) {
                back = forwardBack;
                forward = 0;
            } else {
                back = 0;
                forward = IBHelper.toPositive(forwardBack);
            }
            if (IBHelper.isPositive(leftRight)) {
                right = 0;
                left = leftRight;
            } else {
                right = IBHelper.toPositive(leftRight);
                left = 0;
            }
            if (metaDirection == 0) {
                BuildHelper.setBlock(world, x + left - right, y, z - forward + back, Blocks.field_150325_L, Colors.getWoolColor(Colors.getColorAt(img, imgx, imgy)), 2);
            } else if (metaDirection == 1) {
                BuildHelper.setBlock(world, x + forward - back, y, z + left - right, Blocks.field_150325_L, Colors.getWoolColor(Colors.getColorAt(img, imgx, imgy)), 2);
            } else if (metaDirection == 2) {
                BuildHelper.setBlock(world, x - left + right, y, z + forward - back, Blocks.field_150325_L, Colors.getWoolColor(Colors.getColorAt(img, imgx, imgy)), 2);
            } else if (metaDirection == 3) {
                BuildHelper.setBlock(world, x - forward + back, y, z - left + right, Blocks.field_150325_L, Colors.getWoolColor(Colors.getColorAt(img, imgx, imgy)), 2);
            }
        }
    }

    public static TileEntity getTileEntityDirectional(World world, int x, int y, int z, int metaDirection, int forward, int back, int left, int right) {
        if (metaDirection == 0) {
            return world.func_147438_o(x - left + right, y, z - forward + back);
        }
        if (metaDirection == 1) {
            return world.func_147438_o(x + forward - back, y, z + left - right);
        }
        if (metaDirection == 2) {
            return world.func_147438_o(x + left - right, y, z + forward - back);
        }
        if (metaDirection == 3) {
            return world.func_147438_o(x - forward + back, y, z - left + right);
        }
        return null;
    }
}

