/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.util;

import com.slymask3.instantblocks.handler.Config;
import com.slymask3.instantblocks.item.ItemInstantWand;
import com.slymask3.instantblocks.util.BuildHelper;
import com.slymask3.instantblocks.util.Colors;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class IBHelper {
    public static boolean isClient(World world) {
        return world.field_72995_K;
    }

    public static boolean isServer(World world) {
        return !world.field_72995_K;
    }

    public static void xp(World world, EntityPlayer player, int xpAmount) {
        if (IBHelper.isServer(world) && xpAmount > 0) {
            EntityXPOrb xp = new EntityXPOrb(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, xpAmount);
            world.func_72838_d((Entity)xp);
        }
    }

    public static void sound(World world, String sound, int x, int y, int z) {
        world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, sound, 2.0f, 1.0f, false);
    }

    public static void effectFull(World world, String particle, int x, int y, int z) {
        if (Config.SHOW_EFFECTS) {
            for (double i = 0.0; i <= 1.0; i += 0.1) {
                for (double n = 0.0; n <= 1.0; n += 0.1) {
                    for (double v = 0.0; v <= 1.0; v += 0.1) {
                        world.func_72869_a(particle, (double)x + i, (double)y + v, (double)z + n, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public static void msg(EntityPlayer player, String msg, String color) {
        World world;
        if (Config.SHOW_MESSAGES && IBHelper.isClient(world = player.field_70170_p)) {
            player.func_145747_a((IChatComponent)new ChatComponentText("\u00a78[\u00a73InstantBlocks\u00a78] " + Colors.colorEveryWord(msg, color)));
        }
    }

    public static void keepBlocks(World world, int x, int y, int z, Block block) {
        if (Config.KEEP_BLOCKS) {
            BuildHelper.setBlock(world, x, y, z, block);
        }
    }

    public static void teleport(World world, EntityPlayer player, int x, int y, int z, boolean allow) {
        if (IBHelper.isServer(world) && allow) {
            IBHelper.sound(world, "portal.trigger", x, y, z);
            player.func_70634_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        }
    }

    public static void addItemsToChest(TileEntityChest chest, Block block, int amount, int meta) {
        IBHelper.addItemsToChest(chest, Item.func_150898_a((Block)block), amount, meta);
    }

    public static void addItemsToChest(TileEntityChest chest, Item item, int amount, int meta) {
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            ItemStack is = new ItemStack(item, amount, meta);
            if (chest.func_70301_a(i) != null && chest.func_70301_a(i).func_77973_b() == is.func_77973_b() && chest.func_70301_a(i).func_77960_j() == is.func_77960_j() && chest.func_70301_a((int)i).field_77994_a < 64) {
                chest.func_70299_a(i, new ItemStack(item, amount + chest.func_70301_a((int)i).field_77994_a, meta));
                break;
            }
            if (chest.func_70301_a(i) != null && chest.func_70301_a(i).func_77973_b() == is.func_77973_b() && chest.func_70301_a(i).func_77960_j() == is.func_77960_j() && chest.func_70301_a((int)i).field_77994_a > 64) {
                chest.func_70299_a(i + 1, new ItemStack(item, amount, meta));
                break;
            }
            if (chest.func_70301_a(i) != null) continue;
            chest.func_70299_a(i, new ItemStack(item, amount, meta));
            break;
        }
    }

    public static boolean isWand(ItemStack is) {
        return is != null && is.func_77973_b() instanceof ItemInstantWand;
    }

    public static boolean isPositive(int i) {
        if (i == 0) {
            return true;
        }
        return i >> 31 == 0;
    }

    public static int toPositive(int i) {
        if (i < 0) {
            return -i;
        }
        return i;
    }

    public static boolean isDoubleChest(TileEntityChest chest) {
        chest.func_145979_i();
        return chest.field_145991_k != null || chest.field_145990_j != null || chest.field_145992_i != null || chest.field_145988_l != null;
    }
}

