/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.util;

import com.slymask3.instantblocks.util.LogHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class SchematicHelper {
    public static Schematic readSchematic(String schematicName) {
        try {
            File file = new File("schematics/" + schematicName + ".schematic");
            FileInputStream fis = new FileInputStream(file);
            NBTTagCompound nbtdata = CompressedStreamTools.func_74796_a((InputStream)fis);
            short width = nbtdata.func_74765_d("Width");
            short height = nbtdata.func_74765_d("Height");
            short length = nbtdata.func_74765_d("Length");
            byte[] blocks = nbtdata.func_74770_j("Blocks");
            byte[] data = nbtdata.func_74770_j("Data");
            fis.close();
            return new Schematic(width, height, length, blocks, data);
        }
        catch (Exception e) {
            LogHelper.info("Couldn't read schematic.");
            return null;
        }
    }

    public static void createSchematicsDir() {
        File dir = new File("schematics");
        if (!dir.exists()) {
            try {
                dir.mkdir();
                LogHelper.info("created schematics directory");
            }
            catch (SecurityException se) {
                LogHelper.error("failed to create schematics directory: " + se.getMessage());
            }
        }
    }

    public static class Schematic {
        public short width;
        public short height;
        public short length;
        public byte[] blocks;
        public byte[] data;

        public Schematic(short width, short height, short length, byte[] blocks, byte[] data) {
            this.width = width;
            this.height = height;
            this.length = length;
            this.blocks = blocks;
            this.data = data;
        }
    }
}

