/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.instant;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.block.entity.SkydiveBlockEntity;
import com.slymask3.instantblocks.core.ModBlocks;
import com.slymask3.instantblocks.util.Builder;
import com.slymask3.instantblocks.util.ClientHelper;
import com.slymask3.instantblocks.util.ColorHelper;
import com.slymask3.instantblocks.util.Helper;
import java.awt.Color;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3614;
import net.minecraft.class_4970;

public class InstantSkydiveBlock
extends InstantBlock
implements class_2343 {
    public InstantSkydiveBlock() {
        super(class_4970.class_2251.method_9637((class_3614)class_3614.field_15931).method_9632(0.8f).method_9626(class_2498.field_11543));
        this.setScreen(ClientHelper.Screen.SKYDIVE);
        this.setCreateMessage("ib.message.create.skydive");
        this.setDirectional(true);
    }

    @Override
    public boolean isEnabled() {
        return Common.CONFIG.ENABLE_SKYDIVE();
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SkydiveBlockEntity(pos, state);
    }

    @Override
    public boolean build(class_1937 world, int x, int y, int z, class_1657 player) {
        int i;
        SkydiveBlockEntity blockEntity = (SkydiveBlockEntity)world.method_8321(new class_2338(x, y, z));
        int[] selectedColors = blockEntity.colorCode;
        int radius = blockEntity.radius;
        if (selectedColors.length == 0) {
            Helper.sendMessage(player, "ib.message.error.no_colors");
            return false;
        }
        class_2350 direction = (class_2350)world.method_8320(new class_2338(x, y, z)).method_11654((class_2769)FACING);
        ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(class_2246.field_10124)).build();
        int index = 0;
        Color[] colors = new Color[selectedColors.length * 10];
        for (i = 0; i < selectedColors.length; ++i) {
            Color base;
            Color after = i + 1 < selectedColors.length ? new Color(selectedColors[i + 1]) : new Color(selectedColors[0]);
            colors[index] = base = new Color(selectedColors[i]);
            colors[++index] = ColorHelper.getColorBetween(base, after, 90, 10);
            colors[++index] = ColorHelper.getColorBetween(base, after, 80, 20);
            colors[++index] = ColorHelper.getColorBetween(base, after, 70, 30);
            colors[++index] = ColorHelper.getColorBetween(base, after, 60, 40);
            colors[++index] = ColorHelper.getColorBetween(base, after, 50, 50);
            colors[++index] = ColorHelper.getColorBetween(base, after, 40, 60);
            colors[++index] = ColorHelper.getColorBetween(base, after, 30, 70);
            colors[++index] = ColorHelper.getColorBetween(base, after, 20, 80);
            colors[++index] = ColorHelper.getColorBetween(base, after, 10, 90);
            ++index;
        }
        i = 0;
        int min = Helper.getMinSkydive(world);
        int max = Helper.getMaxSkydive(world);
        int water = Common.CONFIG.SKYDIVE_WATER();
        for (int c = max; c >= min; --c) {
            if (i >= colors.length) {
                i = 0;
            }
            int color = colors[i].getRGB();
            if (c == min) {
                Builder.Circle.setup(world, x, c, z, radius).setBlock(Builder.BlockType.color(color)).build();
            } else if (c < min + water + 1) {
                Builder.Circle.setup(world, x, c, z, radius).setInner(Builder.BlockType.block(class_2246.field_10382)).setOuter(Builder.BlockType.color(color)).build();
            } else {
                Builder.Circle.setup(world, x, c, z, radius).setInner(Builder.BlockType.block(class_2246.field_10124)).setOuter(Builder.BlockType.color(color)).build();
            }
            if (c == min + water + 1) {
                ((Builder.Single)Builder.Single.setup(world, x + radius, c, z).setBlock(Builder.BlockType.color(color, ModBlocks.SKYDIVE_TP))).build();
                ((Builder.Single)Builder.Single.setup(world, x - radius, c, z).setBlock(Builder.BlockType.color(color, ModBlocks.SKYDIVE_TP))).build();
                ((Builder.Single)Builder.Single.setup(world, x, c, z + radius).setBlock(Builder.BlockType.color(color, ModBlocks.SKYDIVE_TP))).build();
                ((Builder.Single)Builder.Single.setup(world, x, c, z - radius).setBlock(Builder.BlockType.color(color, ModBlocks.SKYDIVE_TP))).build();
            }
            ++i;
        }
        if (blockEntity.teleport) {
            if (direction == class_2350.field_11035) {
                Helper.teleport(world, player, x, max + 1, z + radius);
            } else if (direction == class_2350.field_11039) {
                Helper.teleport(world, player, x - radius, max + 1, z);
            } else if (direction == class_2350.field_11043) {
                Helper.teleport(world, player, x, max + 1, z - radius);
            } else if (direction == class_2350.field_11034) {
                Helper.teleport(world, player, x + radius, max + 1, z);
            }
        }
        return true;
    }
}

