/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.gui.screens;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.entity.TreeBlockEntity;
import com.slymask3.instantblocks.block.instant.InstantTreeBlock;
import com.slymask3.instantblocks.gui.components.SelectionList;
import com.slymask3.instantblocks.gui.screens.InstantScreen;
import com.slymask3.instantblocks.network.packet.TreePacket;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4280;
import net.minecraft.class_4286;
import net.minecraft.class_4587;

public class TreeScreen
extends InstantScreen {
    private int selected = -1;
    private final int[] trees = new int[]{0, 1, 2, 3, 4, 5, 6};
    private class_4286 hollowLogs;
    private class_4286 hollowLeaves;
    private class_4286 airInside;
    private TreeList treeList;

    public TreeScreen(class_1657 player, class_1937 world, class_2338 pos) {
        super(player, world, pos, "ib.gui.tree.title");
    }

    @Override
    public void method_25426() {
        super.method_25426();
        TreeBlockEntity blockEntity = (TreeBlockEntity)this.world.method_8321(this.pos);
        this.hollowLogs = new class_4286(this.field_22789 / 2 + 4, 50, 150, 20, (class_2561)new class_2588("ib.gui.tree.logs"), blockEntity.hollowLogs);
        this.hollowLeaves = new class_4286(this.field_22789 / 2 + 4, 72, 150, 20, (class_2561)new class_2588("ib.gui.tree.leaves"), blockEntity.hollowLeaves);
        this.airInside = new class_4286(this.field_22789 / 2 + 4, 94, 150, 20, (class_2561)new class_2588("ib.gui.tree.air"), blockEntity.airInside);
        this.treeList = new TreeList(this.field_22789 / 2 - 4 - 150, 50, 144, this.field_22790 / 4 + 70);
        this.method_25429((class_364)this.treeList);
        this.method_37063((class_364)this.hollowLogs);
        this.method_37063((class_364)this.hollowLeaves);
        this.method_37063((class_364)this.airInside);
        this.method_37063((class_364)this.treeList);
        this.setSelected(blockEntity.type);
    }

    @Override
    protected void renderLabels(class_4587 poseStack, int mouseX, int mouseY) {
        this.field_22793.method_30883(poseStack, (class_2561)new class_2588("ib.gui.tree.options"), (float)(this.field_22789 / 2 + 4), 40.0f, 0xA0A0A0);
        this.field_22793.method_30883(poseStack, (class_2561)new class_2588("ib.gui.tree.type"), (float)(this.field_22789 / 2 - 2 - 150), 40.0f, 0xA0A0A0);
    }

    @Override
    public void sendInfo(boolean activate) {
        Common.NETWORK.sendToServer(new TreePacket(activate, this.pos, this.selected, this.hollowLogs.method_20372(), this.hollowLeaves.method_20372(), this.airInside.method_20372()));
    }

    public void setSelected(int index) {
        this.selected = index;
        this.treeList.setSelectedTree(index);
        this.done.field_22763 = index >= 0 && index < this.trees.length;
    }

    public int getSelected() {
        return this.selected;
    }

    class TreeList
    extends SelectionList<Entry> {
        public TreeList(int x, int y, int width, int height) {
            super(TreeScreen.this.field_22787, x, y, width, height, 18);
            for (int tree : TreeScreen.this.trees) {
                Entry entry = new Entry(tree);
                this.method_25321((class_350.class_351)entry);
            }
            if (this.method_25334() != null) {
                this.method_25324((class_350.class_351)((Entry)this.method_25334()));
            }
        }

        protected boolean method_25316() {
            return TreeScreen.this.method_25399() == this;
        }

        public void setSelectedTree(int index) {
            if (index > 0 && index < TreeScreen.this.trees.length) {
                this.method_25313((class_350.class_351)((Entry)this.method_25326(index)));
                this.method_25324((class_350.class_351)((Entry)this.method_25334()));
            } else {
                this.method_25313(null);
            }
        }

        class Entry
        extends class_4280.class_4281<Entry> {
            final int index;

            public Entry(int index) {
                this.index = index;
            }

            public void method_25343(class_4587 poseStack, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTick) {
                int entry_y = top + 4;
                if (entry_y > TreeList.this.field_19085 - 5 && entry_y + entryHeight < TreeList.this.field_19086 + 5) {
                    String string = InstantTreeBlock.treeToString(this.index, (class_1657)class_310.method_1551().field_1724);
                    TreeScreen.this.field_22793.method_29342(poseStack, string, (float)(left + entryWidth / 2 - TreeScreen.this.field_22793.method_1727(string) / 2), (float)entry_y, TreeScreen.this.getSelected() == this.index ? 43520 : 0xFFFFFF, true);
                }
            }

            public boolean method_25402(double p_96122_, double p_96123_, int p_96124_) {
                if (p_96124_ == 0) {
                    TreeScreen.this.setSelected(this.index);
                    return true;
                }
                return false;
            }

            public class_2561 method_37006() {
                return new class_2588("narrator.select", new Object[]{InstantTreeBlock.treeToString(this.index, (class_1657)class_310.method_1551().field_1724)});
            }
        }
    }
}

