/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2248;

public class ColorHelper {
    public static final VanillaColor[] VANILLA_COLORS = new VanillaColor[]{new VanillaColor(new Color(221, 221, 221), class_2246.field_10446), new VanillaColor(new Color(219, 125, 62), class_2246.field_10095), new VanillaColor(new Color(179, 80, 188), class_2246.field_10215), new VanillaColor(new Color(107, 138, 201), class_2246.field_10294), new VanillaColor(new Color(177, 166, 39), class_2246.field_10490), new VanillaColor(new Color(65, 174, 56), class_2246.field_10028), new VanillaColor(new Color(208, 132, 153), class_2246.field_10459), new VanillaColor(new Color(64, 64, 64), class_2246.field_10423), new VanillaColor(new Color(154, 161, 161), class_2246.field_10222), new VanillaColor(new Color(46, 110, 137), class_2246.field_10619), new VanillaColor(new Color(126, 61, 181), class_2246.field_10259), new VanillaColor(new Color(46, 56, 141), class_2246.field_10514), new VanillaColor(new Color(79, 50, 31), class_2246.field_10113), new VanillaColor(new Color(53, 70, 27), class_2246.field_10170), new VanillaColor(new Color(150, 52, 48), class_2246.field_10314), new VanillaColor(new Color(25, 22, 22), class_2246.field_10146)};

    public static class_2248 getWoolColor(Color color) {
        VanillaColor inputColor = new VanillaColor(color);
        VanillaColor woolColor = null;
        float diff_lowest = -1.0f;
        for (VanillaColor vanillaColor : VANILLA_COLORS) {
            float diff = vanillaColor.diff(inputColor);
            if (diff_lowest != -1.0f && !(diff < diff_lowest)) continue;
            diff_lowest = diff;
            woolColor = vanillaColor;
        }
        return woolColor.getBlock();
    }

    public static Color getColorAt(BufferedImage img, int x, int y) {
        int rgb = img.getRGB(x, y);
        int red = (rgb & 0xFF0000) >> 16;
        int green = (rgb & 0xFF00) >> 8;
        int blue = rgb & 0xFF;
        return new Color(red, green, blue);
    }

    public static int hsvToRgb(int hue, float saturation, float value) {
        float b;
        float g;
        float r;
        float s = saturation / 100.0f;
        float v = value / 100.0f;
        float c = v * s;
        float h = (float)(hue %= 360) / 60.0f;
        float x = c * (1.0f - Math.abs(h % 2.0f - 1.0f));
        switch (hue / 60) {
            case 0: {
                r = c;
                g = x;
                b = 0.0f;
                break;
            }
            case 1: {
                r = x;
                g = c;
                b = 0.0f;
                break;
            }
            case 2: {
                r = 0.0f;
                g = c;
                b = x;
                break;
            }
            case 3: {
                r = 0.0f;
                g = x;
                b = c;
                break;
            }
            case 4: {
                r = x;
                g = 0.0f;
                b = c;
                break;
            }
            case 5: {
                r = c;
                g = 0.0f;
                b = x;
                break;
            }
            default: {
                return 0;
            }
        }
        float m = v - c;
        return (int)((r + m) * 255.0f) << 16 | (int)((g + m) * 255.0f) << 8 | (int)((b + m) * 255.0f);
    }

    public static Color getColorBetween(Color one, Color two, int per1, int per2) {
        double p1 = (double)per1 / 100.0;
        double p2 = (double)per2 / 100.0;
        return new Color((int)Math.floor((double)one.getRed() * p1 + (double)two.getRed() * p2), (int)Math.floor((double)one.getGreen() * p1 + (double)two.getGreen() * p2), (int)Math.floor((double)one.getBlue() * p1 + (double)two.getBlue() * p2));
    }

    public static Color generateRandomColor() {
        Random rand = new Random();
        int hue = rand.nextInt(360);
        int color = ColorHelper.hsvToRgb(hue, 100.0f, 100.0f);
        return new Color(color);
    }

    public static Color textToColor(String input) {
        int color;
        if (input.equalsIgnoreCase("red")) {
            color = 0xFF0000;
        } else if (input.equalsIgnoreCase("orange")) {
            color = 0xFF8000;
        } else if (input.equalsIgnoreCase("yellow")) {
            color = 0xFFFF00;
        } else if (input.equalsIgnoreCase("lime")) {
            color = 0x80FF00;
        } else if (input.equalsIgnoreCase("green")) {
            color = 65280;
        } else if (input.equalsIgnoreCase("cyan")) {
            color = 65535;
        } else if (input.equalsIgnoreCase("light blue") || input.equalsIgnoreCase("lightblue")) {
            color = 33023;
        } else if (input.equalsIgnoreCase("blue")) {
            color = 255;
        } else if (input.equalsIgnoreCase("purple")) {
            color = 0x8000FF;
        } else if (input.equalsIgnoreCase("magenta")) {
            color = 0xFF00FF;
        } else if (input.equalsIgnoreCase("pink")) {
            color = 0xFF0080;
        } else if (input.equalsIgnoreCase("white")) {
            color = 0xFFFFFF;
        } else if (input.equalsIgnoreCase("gray") || input.equalsIgnoreCase("grey")) {
            color = 0x808080;
        } else if (input.equalsIgnoreCase("light gray") || input.equalsIgnoreCase("lightgray") || input.equalsIgnoreCase("light grey") || input.equalsIgnoreCase("lightgrey")) {
            color = 0xC0C0C0;
        } else if (input.equalsIgnoreCase("brown")) {
            color = 0x663300;
        } else if (input.equalsIgnoreCase("black")) {
            color = 0;
        } else {
            try {
                color = (int)Long.parseLong(input, 16);
            }
            catch (Exception e) {
                color = 0xFFFFFF;
            }
        }
        return new Color(color);
    }

    public static String indexRainbowToString(int index) {
        return switch (index) {
            case 0 -> "red";
            case 1 -> "orange";
            case 2 -> "yellow";
            case 3 -> "lime";
            case 4 -> "green";
            case 5 -> "cyan";
            case 6 -> "light blue";
            case 7 -> "blue";
            case 8 -> "purple";
            case 9 -> "magenta";
            case 10 -> "pink";
            default -> "white";
        };
    }

    public static class VanillaColor {
        private float hue;
        private float saturation;
        private float value;
        private final Color color;
        private final class_2248 block;

        public VanillaColor(float hue, float saturation, float value, class_2248 block) {
            this.hue = hue;
            this.saturation = saturation;
            this.value = value;
            this.color = Color.getHSBColor(hue, saturation, value);
            this.block = block;
        }

        public VanillaColor(Color color, class_2248 block) {
            this.color = color;
            this.block = block;
            this.setHsvFromColor(color);
        }

        public VanillaColor(Color color) {
            this(color, null);
        }

        public float getHue() {
            return this.hue;
        }

        public float getSaturation() {
            return this.saturation;
        }

        public float getValue() {
            return this.value;
        }

        public Color getColor() {
            return this.color;
        }

        public class_2248 getBlock() {
            return this.block != null ? this.block : class_2246.field_10446;
        }

        public float diff(VanillaColor other) {
            float hue_diff = Math.abs(this.hue - other.getHue()) / 360.0f * 0.475f;
            float saturation_diff = Math.abs(this.saturation - other.getSaturation()) / 100.0f * 0.2875f;
            float value_diff = Math.abs(this.value - other.getValue()) / 100.0f * 0.2375f;
            return hue_diff + saturation_diff + value_diff;
        }

        private void setHsvFromColor(Color color) {
            double r = color.getRed();
            double g = color.getGreen();
            double b = color.getBlue();
            double cmax = Math.max(r /= 255.0, Math.max(g /= 255.0, b /= 255.0));
            double cmin = Math.min(r, Math.min(g, b));
            double diff = cmax - cmin;
            double h = -1.0;
            double s = -1.0;
            if (cmax == cmin) {
                h = 0.0;
            } else if (cmax == r) {
                h = (60.0 * ((g - b) / diff) + 360.0) % 360.0;
            } else if (cmax == g) {
                h = (60.0 * ((b - r) / diff) + 120.0) % 360.0;
            } else if (cmax == b) {
                h = (60.0 * ((r - g) / diff) + 240.0) % 360.0;
            }
            s = cmax == 0.0 ? 0.0 : diff / cmax * 100.0;
            double v = cmax * 100.0;
            this.hue = (float)h;
            this.saturation = (float)s;
            this.value = (float)v;
        }
    }
}

