/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.util;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.util.Helper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2680;

public class SchematicHelper {
    public static final String SCHEMATICS_DIR = "schematics";
    public static ArrayList<String> SCHEMATICS_LIST = new ArrayList();

    public static Schematic readSchematic(String schematicName) {
        try {
            File file = new File("schematics/" + schematicName);
            FileInputStream fis = new FileInputStream(file);
            class_2487 tag = class_2507.method_10629((InputStream)fis);
            fis.close();
            return new Schematic(tag);
        }
        catch (Exception e) {
            Common.LOG.info("Failed to read schematic: " + e.getMessage());
            return null;
        }
    }

    public static void createSchematicsDir() {
        File dir = new File(SCHEMATICS_DIR);
        if (!dir.exists()) {
            try {
                dir.mkdir();
            }
            catch (SecurityException se) {
                Common.LOG.error("Failed to create schematics directory: " + se.getMessage());
            }
        }
    }

    public static ArrayList<String> getSchematics() {
        ArrayList<String> schematics = new ArrayList<String>();
        File dir = new File("schematics/");
        File[] files = dir.listFiles(file -> file.isFile() && (file.getName().toLowerCase().endsWith(".schematic") || file.getName().toLowerCase().endsWith(".schem")));
        if (files != null) {
            for (File file2 : files) {
                schematics.add(file2.getName());
            }
        }
        return schematics;
    }

    public static class Schematic {
        public final short width;
        public final short height;
        public final short length;
        public final byte[] blocks;
        private final HashMap<Integer, class_2680> map;
        private final HashMap<class_2338, class_2487> blockEntities;
        private final ArrayList<class_2487> entities;

        public Schematic(class_2487 tag) {
            this.width = tag.method_10568("Width");
            this.height = tag.method_10568("Height");
            this.length = tag.method_10568("Length");
            this.blocks = tag.method_10547("BlockData");
            this.map = new HashMap();
            class_2487 palette = tag.method_10562("Palette");
            for (Object blockStateString : palette.method_10541()) {
                int key = palette.method_10550((String)blockStateString);
                class_2680 state = Helper.readBlockState((String)blockStateString);
                this.map.put(key, state);
            }
            this.blockEntities = new HashMap();
            class_2499 blockEntities = tag.method_10554("BlockEntities", 10);
            for (class_2520 entity : blockEntities) {
                class_2487 entityTag = (class_2487)entity;
                int[] pos = entityTag.method_10561("Pos");
                this.blockEntities.put(new class_2338(pos[0], pos[1], pos[2]), entityTag);
            }
            this.entities = new ArrayList();
            class_2499 entities = tag.method_10554("Entities", 10);
            for (class_2520 entity : entities) {
                class_2487 entityTag = (class_2487)entity;
                this.entities.add(entityTag);
            }
        }

        public class_2680 getBlockState(int index) {
            return this.map.get(this.blocks[index]);
        }

        public class_2487 getBlockEntityTag(int x, int y, int z) {
            return this.blockEntities.get(new class_2338(x, y, z));
        }

        public ArrayList<class_2487> getEntityTags() {
            return this.entities;
        }
    }
}

