/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.instant;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.block.entity.SchematicBlockEntity;
import com.slymask3.instantblocks.util.Builder;
import com.slymask3.instantblocks.util.ClientHelper;
import com.slymask3.instantblocks.util.Helper;
import com.slymask3.instantblocks.util.SchematicHelper;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import net.minecraft.class_4970;

public class InstantSchematicBlock
extends InstantBlock
implements class_2343 {
    public InstantSchematicBlock() {
        super(class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9632(1.5f).method_9626(class_2498.field_11547));
        this.setScreen(ClientHelper.Screen.SCHEMATIC);
    }

    @Override
    public boolean isEnabled() {
        return Common.CONFIG.ENABLE_SCHEMATIC();
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SchematicBlockEntity(pos, state);
    }

    @Override
    public boolean build(class_1937 world, int x, int y, int z, class_1657 player) {
        SchematicBlockEntity blockEntity = (SchematicBlockEntity)world.method_8321(new class_2338(x, y, z));
        SchematicHelper.Schematic schematic = SchematicHelper.readSchematic(blockEntity.schematic);
        if (schematic != null) {
            ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(class_2246.field_10124)).build();
            InstantSchematicBlock.buildSchematic(world, x, y, z, schematic, blockEntity.center, blockEntity.ignoreAir);
            this.setCreateMessage("ib.message.create.schematic", blockEntity.schematic);
            return true;
        }
        Helper.sendMessage(player, "ib.message.error.schematic", class_124.field_1061 + blockEntity.schematic);
        return false;
    }

    public static void buildSchematic(class_1937 world, int X, int Y, int Z, SchematicHelper.Schematic schematic, boolean center, boolean ignoreAir) {
        int width = schematic.width;
        int height = schematic.height;
        int length = schematic.length;
        int x_offset = 0;
        int z_offset = 0;
        if (center) {
            x_offset = width / 2;
            z_offset = length / 2;
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index = y * width * length + z * width + x;
                    class_2680 state = schematic.getBlockState(index);
                    class_2338 pos = new class_2338(x + X - x_offset, y + Y, z + Z - z_offset);
                    if (ignoreAir && state.method_26204() == class_2246.field_10124) continue;
                    ((Builder.Single)Builder.Single.setup(world, pos).setBlock(state)).build();
                    class_2487 tag = schematic.getBlockEntityTag(x, y, z);
                    class_2586 entity = world.method_8321(pos);
                    if (tag == null || entity == null) continue;
                    entity.method_11014(tag);
                }
            }
        }
        for (class_2487 entityTag : schematic.getEntityTags()) {
            Optional optional = class_1299.method_5892((class_2487)entityTag, (class_1937)world);
            if (!optional.isPresent()) continue;
            class_1297 entity = (class_1297)optional.get();
            world.method_8649(entity);
        }
    }
}

