/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.instant;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.block.entity.StatueBlockEntity;
import com.slymask3.instantblocks.util.Builder;
import com.slymask3.instantblocks.util.ClientHelper;
import com.slymask3.instantblocks.util.Helper;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3614;
import net.minecraft.class_4970;

public class InstantStatueBlock
extends InstantBlock
implements class_2343 {
    public InstantStatueBlock() {
        super(class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9632(1.5f).method_9626(class_2498.field_11547));
        this.setScreen(ClientHelper.Screen.STATUE);
        this.setDirectional(true);
    }

    @Override
    public boolean isEnabled() {
        return Common.CONFIG.ENABLE_STATUE();
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new StatueBlockEntity(pos, state);
    }

    public Skin getSkin(String username) {
        if (!username.equalsIgnoreCase("")) {
            try {
                JsonObject metadata;
                GsonBuilder builder = new GsonBuilder();
                builder.setPrettyPrinting();
                Gson gson = builder.create();
                String user_api_contents = InstantStatueBlock.get_contents("https://api.mojang.com/users/profiles/minecraft/" + username);
                JsonObject user_json = (JsonObject)gson.fromJson(user_api_contents, JsonObject.class);
                String uuid = user_json.get("id").getAsString();
                String uuid_api_contents = InstantStatueBlock.get_contents("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid);
                JsonObject uuid_json = (JsonObject)gson.fromJson(uuid_api_contents, JsonObject.class);
                String base64 = uuid_json.get("properties").getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString();
                String base64_decoded = new String(Base64.getDecoder().decode(base64));
                JsonObject image_json = (JsonObject)gson.fromJson(base64_decoded, JsonObject.class);
                JsonObject skin_json = image_json.get("textures").getAsJsonObject().get("SKIN").getAsJsonObject();
                String image_url = skin_json.get("url").getAsString();
                Skin skin = new Skin(ImageIO.read(new URL(image_url)));
                if (skin_json.has("metadata") && (metadata = skin_json.get("metadata").getAsJsonObject()).has("model") && metadata.get("model").getAsString().equalsIgnoreCase("slim")) {
                    skin.setSlim(true);
                }
                return skin;
            }
            catch (Exception e) {
                Common.LOG.error(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public boolean build(class_1937 world, int x, int y, int z, class_1657 player) {
        StatueBlockEntity blockEntity = (StatueBlockEntity)world.method_8321(new class_2338(x, y, z));
        class_2350 direction = (class_2350)world.method_8320(new class_2338(x, y, z)).method_11654((class_2769)FACING);
        Skin skin = this.getSkin(blockEntity.username);
        if (skin != null) {
            BufferedImage img = skin.getImage();
            ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(class_2246.field_10124)).build();
            InstantStatueBlock.buildHead(world, x, y, z, img, direction, blockEntity.head, blockEntity.rgb);
            InstantStatueBlock.buildBody(world, x, y, z, img, direction, blockEntity.body, blockEntity.rgb);
            InstantStatueBlock.buildLegs(world, x, y, z, img, direction, blockEntity.legLeft, blockEntity.legRight, blockEntity.rgb);
            if (skin.isSlim()) {
                InstantStatueBlock.buildArmsSlim(world, x, y, z, img, direction, blockEntity.armLeft, blockEntity.armRight, blockEntity.rgb);
            } else {
                InstantStatueBlock.buildArms(world, x, y, z, img, direction, blockEntity.armLeft, blockEntity.armRight, blockEntity.rgb);
            }
            this.setCreateMessage("ib.message.create.statue", blockEntity.username);
            return true;
        }
        Helper.sendMessage(player, "ib.message.error.statue", class_124.field_1061 + blockEntity.username);
        return false;
    }

    private static String get_contents(String url_string) {
        StringBuilder content = new StringBuilder();
        try {
            String line;
            URL url = new URL(url_string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                content.append(line).append("\n");
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content.toString();
    }

    private static void buildHead(class_1937 world, int x, int y, int z, BufferedImage img, class_2350 direction, boolean build, boolean rgb) {
        if (build) {
            int ytimes;
            int xtimes;
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 31, z).offset(direction, -5 + ytimes, -4 + xtimes).setImageColor(img, 8 + xtimes, ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 24, z).offset(direction, -5 + ytimes, -4 + xtimes).setImageColor(img, 16 + xtimes, ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 31 - ytimes, z).offset(direction, -5 + xtimes, -4).setImageColor(img, xtimes, 8 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 31 - ytimes, z).offset(direction, 2 - xtimes, 3).setImageColor(img, 16 + xtimes, 8 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 31 - ytimes, z).offset(direction, 2, -4 + xtimes).setImageColor(img, 8 + xtimes, 8 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 31 - ytimes, z).offset(direction, -5, 3 - xtimes).setImageColor(img, 24 + xtimes, 8 + ytimes, rgb)).build();
                }
            }
        }
    }

    private static void buildBody(class_1937 world, int x, int y, int z, BufferedImage img, class_2350 direction, boolean build, boolean rgb) {
        if (build) {
            int ytimes;
            int xtimes;
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23, z).offset(direction, -3 + ytimes, -4 + xtimes).setImageColor(img, 20 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 12, z).offset(direction, -ytimes, -4 + xtimes).setImageColor(img, 28 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3 + xtimes, -4).setImageColor(img, 16 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -xtimes, 3).setImageColor(img, 28 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, 0, -4 + xtimes).setImageColor(img, 20 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3, 3 - xtimes).setImageColor(img, 32 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
        }
    }

    private static void buildArms(class_1937 world, int x, int y, int z, BufferedImage img, class_2350 direction, boolean buildLeft, boolean buildRight, boolean rgb) {
        int ytimes;
        int xtimes;
        if (buildLeft) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -xtimes, 4).setImageColor(img, 48 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3 + xtimes, 7).setImageColor(img, 40 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23, z).offset(direction, -3 + ytimes, 4 + xtimes).setImageColor(img, 44 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 12, z).offset(direction, -3 + ytimes, 4 + xtimes).setImageColor(img, 48 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, 0, 7 - xtimes).setImageColor(img, 44 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3, 4 + xtimes).setImageColor(img, 52 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
        }
        if (buildRight) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -xtimes, -5).setImageColor(img, 48 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3 + xtimes, -8).setImageColor(img, 40 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23, z).offset(direction, -3 + ytimes, -5 - xtimes).setImageColor(img, 44 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 12, z).offset(direction, -3 + ytimes, -5 - xtimes).setImageColor(img, 48 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, 0, -8 + xtimes).setImageColor(img, 44 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3, -5 - xtimes).setImageColor(img, 52 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
        }
    }

    private static void buildArmsSlim(class_1937 world, int x, int y, int z, BufferedImage img, class_2350 direction, boolean buildLeft, boolean buildRight, boolean rgb) {
        int ytimes;
        int xtimes;
        if (buildLeft) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -xtimes, 4).setImageColor(img, 47 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3 + xtimes, 6).setImageColor(img, 40 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23, z).offset(direction, -3 + ytimes, 4 + xtimes).setImageColor(img, 44 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 12, z).offset(direction, -3 + ytimes, 4 + xtimes).setImageColor(img, 47 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, 0, 6 - xtimes).setImageColor(img, 44 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3, 4 + xtimes).setImageColor(img, 51 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
        }
        if (buildRight) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -xtimes, -5).setImageColor(img, 48 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3 + xtimes, -7).setImageColor(img, 40 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23, z).offset(direction, -3 + ytimes, -5 - xtimes).setImageColor(img, 44 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 12, z).offset(direction, -3 + ytimes, -5 - xtimes).setImageColor(img, 47 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, 0, -7 + xtimes).setImageColor(img, 44 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3, -5 - xtimes).setImageColor(img, 51 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
        }
    }

    private static void buildLegs(class_1937 world, int x, int y, int z, BufferedImage img, class_2350 direction, boolean buildLeft, boolean buildRight, boolean rgb) {
        int ytimes;
        int xtimes;
        if (buildLeft) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11, z).offset(direction, -3 + ytimes, xtimes).setImageColor(img, 4 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y, z).offset(direction, -3 + ytimes, xtimes).setImageColor(img, 8 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, -xtimes, 3).setImageColor(img, 8 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, -3 + xtimes, 0).setImageColor(img, xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, 0, xtimes).setImageColor(img, 4 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, -3, 3 - xtimes).setImageColor(img, 12 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
        }
        if (buildRight) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11, z).offset(direction, -3 + ytimes, -4 + xtimes).setImageColor(img, 4 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y, z).offset(direction, -3 + ytimes, -4 + xtimes).setImageColor(img, 8 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, -xtimes, -1).setImageColor(img, 8 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, -3 + xtimes, -4).setImageColor(img, xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, 0, -1 - xtimes).setImageColor(img, 4 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, -3, -4 + xtimes).setImageColor(img, 12 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
        }
    }

    private static class Skin {
        private final BufferedImage image;
        private boolean slim;

        public Skin(BufferedImage image) {
            this.image = image;
            this.slim = false;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public boolean isSlim() {
            return this.slim;
        }

        public void setSlim(boolean slim) {
            this.slim = slim;
        }
    }
}

