/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.network;

import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.block.entity.HarvestBlockEntity;
import com.slymask3.instantblocks.block.entity.SchematicBlockEntity;
import com.slymask3.instantblocks.block.entity.SkydiveBlockEntity;
import com.slymask3.instantblocks.block.entity.StatueBlockEntity;
import com.slymask3.instantblocks.block.entity.TreeBlockEntity;
import com.slymask3.instantblocks.network.packet.ClientPacket;
import com.slymask3.instantblocks.network.packet.HarvestPacket;
import com.slymask3.instantblocks.network.packet.InstantPacket;
import com.slymask3.instantblocks.network.packet.SchematicPacket;
import com.slymask3.instantblocks.network.packet.SchematicUpdatePacket;
import com.slymask3.instantblocks.network.packet.SkydivePacket;
import com.slymask3.instantblocks.network.packet.StatuePacket;
import com.slymask3.instantblocks.network.packet.TreePacket;
import com.slymask3.instantblocks.util.ClientHelper;
import com.slymask3.instantblocks.util.Helper;
import com.slymask3.instantblocks.util.SchematicHelper;
import net.minecraft.class_1657;
import net.minecraft.class_1937;

public class PacketHelper {
    private static void activate(InstantPacket message, class_1937 world, class_1657 player) {
        if (message.activate) {
            InstantBlock block = (InstantBlock)Helper.getBlock(world, message.pos);
            block.activate(world, message.pos, player);
        }
    }

    public static void handleClient(ClientPacket message, class_1657 player) {
        if (message.particles != ClientHelper.Particles.NONE.ordinal()) {
            class_1937 world = player.method_37908();
            ClientHelper.playSound(world, message.pos, ClientHelper.Particles.values()[message.particles]);
            ClientHelper.showParticles(world, message.pos, ClientHelper.Particles.values()[message.particles]);
        }
        if (!message.message.isEmpty()) {
            ClientHelper.sendMessage(player, message.message, message.variable);
        }
    }

    public static void handleSkydive(SkydivePacket message, class_1657 player) {
        class_1937 world = player.method_37908();
        SkydiveBlockEntity blockEntity = (SkydiveBlockEntity)world.method_8321(message.pos);
        if (blockEntity != null) {
            blockEntity.update(message._colors, message._radius, message._tp);
            PacketHelper.activate(message, world, player);
        }
    }

    public static void handleStatue(StatuePacket message, class_1657 player) {
        class_1937 world = player.method_37908();
        StatueBlockEntity blockEntity = (StatueBlockEntity)world.method_8321(message.pos);
        if (blockEntity != null) {
            blockEntity.update(message._username, message._head, message._body, message._armLeft, message._armRight, message._legLeft, message._legRight, message._rgb);
            PacketHelper.activate(message, world, player);
        }
    }

    public static void handleHarvest(HarvestPacket message, class_1657 player) {
        class_1937 world = player.method_37908();
        HarvestBlockEntity blockEntity = (HarvestBlockEntity)world.method_8321(message.pos);
        if (blockEntity != null) {
            blockEntity.update(message._logOak, message._logSpruce, message._logBirch, message._logJungle, message._logAcacia, message._logDark, message._wheat, message._carrot, message._potato, message._cactus, message._pumpkin, message._melon, message._sugarcane, message._cocoa, message._mushroom, message._netherwart, message._replant);
            PacketHelper.activate(message, world, player);
        }
    }

    public static void handleTree(TreePacket message, class_1657 player) {
        class_1937 world = player.method_37908();
        TreeBlockEntity blockEntity = (TreeBlockEntity)world.method_8321(message.pos);
        if (blockEntity != null) {
            blockEntity.update(message.type, message.hollowLogs, message.hollowLeaves, message.airInside);
            PacketHelper.activate(message, world, player);
        }
    }

    public static void handleSchematic(SchematicPacket message, class_1657 player) {
        class_1937 world = player.method_37908();
        SchematicBlockEntity blockEntity = (SchematicBlockEntity)world.method_8321(message.pos);
        if (blockEntity != null) {
            blockEntity.update(message._schematic, message._center, message._air);
            PacketHelper.activate(message, world, player);
        }
    }

    public static void handleSchematicUpdate(SchematicUpdatePacket message, class_1657 player) {
        SchematicHelper.SCHEMATICS_LIST = message.schematics;
        ClientHelper.showScreen(ClientHelper.Screen.SCHEMATIC, player, player.method_37908(), message.pos);
    }

    public static enum PacketID {
        CLIENT,
        SKYDIVE,
        STATUE,
        HARVEST,
        TREE,
        SCHEMATIC,
        SCHEMATIC_UPDATE;

    }
}

