/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.util;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.block.entity.ColorBlockEntity;
import com.slymask3.instantblocks.core.ModBlocks;
import com.slymask3.instantblocks.util.ColorHelper;
import com.slymask3.instantblocks.util.Helper;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2310;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2745;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3965;
import net.minecraft.class_5321;

public class Builder {

    public static class Context
    extends class_1750 {
        public Context(class_1937 world, class_2338 pos) {
            super(world, null, class_1268.field_5808, class_1799.field_8037, new class_3965(class_243.field_1353, class_2350.field_11033, pos, false));
        }
    }

    public static class Sphere
    extends Base<Sphere> {
        final int radius;
        BlockType outerBlockType;
        BlockType innerBlockType;
        boolean half;

        private Sphere(class_1937 world, int x, int y, int z, int radius) {
            super(world, x, y, z);
            this.radius = radius;
            this.half = false;
        }

        public static Sphere setup(class_1937 world, int x, int y, int z, int radius) {
            return new Sphere(world, x, y, z, radius);
        }

        @Override
        public Sphere setBlock(BlockType type) {
            this.outerBlockType = type;
            this.innerBlockType = type;
            return this;
        }

        public Sphere setOuter(BlockType type) {
            this.outerBlockType = type;
            return this;
        }

        public Sphere setInner(BlockType type) {
            this.innerBlockType = type;
            return this;
        }

        public Sphere setHalf() {
            this.half = true;
            return this;
        }

        @Override
        public void build() {
            for (int xc = 0; xc <= 2 * this.radius; ++xc) {
                for (int zc = 0; zc <= 2 * this.radius; ++zc) {
                    for (int yc = 0; yc <= 2 * this.radius; ++yc) {
                        double distance = Math.sqrt((xc - this.radius) * (xc - this.radius) + (zc - this.radius) * (zc - this.radius) + (yc - this.radius) * (yc - this.radius));
                        int y_pos = this.y + yc - this.radius;
                        if (y_pos < this.y && this.half) continue;
                        if (distance > (double)this.radius - 0.4 && distance < (double)this.radius + 0.5) {
                            ((Single)Single.setup(this.world, this.x + xc - this.radius, this.y + yc - this.radius, this.z + zc - this.radius).setBlock(this.outerBlockType)).build();
                            continue;
                        }
                        if (!(distance < (double)this.radius - 0.3)) continue;
                        ((Single)Single.setup(this.world, this.x + xc - this.radius, this.y + yc - this.radius, this.z + zc - this.radius).setBlock(this.innerBlockType)).build();
                    }
                }
            }
        }
    }

    public static class Circle
    extends Base<Circle> {
        BlockType outerBlockType;
        BlockType innerBlockType;
        final int radius;

        private Circle(class_1937 world, int x, int y, int z, int radius) {
            super(world, x, y, z);
            this.radius = radius;
        }

        public static Circle setup(class_1937 world, int x, int y, int z, int radius) {
            return new Circle(world, x, y, z, radius);
        }

        @Override
        public Circle setBlock(BlockType type) {
            this.outerBlockType = type;
            this.innerBlockType = type;
            return this;
        }

        public Circle setOuter(BlockType type) {
            this.outerBlockType = type;
            return this;
        }

        public Circle setInner(BlockType type) {
            this.innerBlockType = type;
            return this;
        }

        @Override
        public void build() {
            for (int row = 0; row <= 2 * this.radius; ++row) {
                for (int col = 0; col <= 2 * this.radius; ++col) {
                    double distance = Math.sqrt((row - this.radius) * (row - this.radius) + (col - this.radius) * (col - this.radius));
                    if (distance > (double)this.radius - 0.4 && distance < (double)this.radius + 0.5) {
                        ((Single)Single.setup(this.world, this.x + row - this.radius, this.y, this.z + col - this.radius).setBlock(this.outerBlockType)).build();
                        continue;
                    }
                    if (!(distance < (double)this.radius - 0.3)) continue;
                    ((Single)Single.setup(this.world, this.x + row - this.radius, this.y, this.z + col - this.radius).setBlock(this.innerBlockType)).build();
                }
            }
        }
    }

    public static class Multiple
    extends Base<Multiple> {
        final int x1;
        final int y1;
        final int z1;
        final int x2;
        final int y2;
        final int z2;

        private Multiple(class_1937 world, int x, int y, int z, int x1, int y1, int z1, int x2, int y2, int z2) {
            super(world, x, y, z);
            this.x1 = x1;
            this.y1 = y1;
            this.z1 = z1;
            this.x2 = x2;
            this.y2 = y2;
            this.z2 = z2;
        }

        public static Multiple setup(class_1937 world, int x, int y, int z, class_2350 direction, int forward, int back, int left, int right, int forwardX, int backX, int leftX, int rightX, int upX, int downX) {
            int x1 = x;
            int z1 = z;
            int x2 = x;
            int z2 = z;
            int y2 = y + upX - downX;
            if (direction == class_2350.field_11035) {
                x1 = x - left + right;
                z1 = z - forward + back;
                x2 = x1 - leftX + rightX;
                z2 = z1 - forwardX + backX;
            } else if (direction == class_2350.field_11039) {
                x1 = x + forward - back;
                z1 = z - left + right;
                x2 = x1 + forwardX - backX;
                z2 = z1 - leftX + rightX;
            } else if (direction == class_2350.field_11043) {
                x1 = x + left - right;
                z1 = z + forward - back;
                x2 = x1 + leftX - rightX;
                z2 = z1 + forwardX - backX;
            } else if (direction == class_2350.field_11034) {
                x1 = x - forward + back;
                z1 = z + left - right;
                x2 = x1 - forwardX + backX;
                z2 = z1 + leftX - rightX;
            }
            return new Multiple(world, x, y, z, x1, y, z1, x2, y2, z2);
        }

        public static Multiple setup(class_1937 world, int x_start, int y_start, int z_start, int x_times, int y_times, int z_times) {
            return new Multiple(world, x_start, y_start, z_start, x_start, y_start, z_start, x_start + x_times - 1, y_start + y_times - 1, z_start + z_times - 1);
        }

        @Override
        public void build() {
            boolean x_dir = Helper.isPositive(this.x1 - this.x2);
            boolean y_dir = Helper.isPositive(this.y1 - this.y2);
            boolean z_dir = Helper.isPositive(this.z1 - this.z2);
            int y_cur = this.y1;
            while (y_dir ? y_cur >= this.y2 : y_cur <= this.y2) {
                int z_cur = this.z1;
                while (z_dir ? z_cur >= this.z2 : z_cur <= this.z2) {
                    int x_cur = this.x1;
                    while (x_dir ? x_cur >= this.x2 : x_cur <= this.x2) {
                        ((Single)((Single)Single.setup(this.world, x_cur, y_cur, z_cur).setBlock(this.blockType)).setDirection(this.direction)).build();
                        x_cur += x_dir ? -1 : 1;
                    }
                    z_cur += z_dir ? -1 : 1;
                }
                y_cur += y_dir ? -1 : 1;
            }
        }
    }

    public static class Single
    extends Base<Single> {
        private Single(class_1937 world, int x, int y, int z) {
            super(world, x, y, z);
        }

        public Single offset(class_2350 direction, int forwardBack, int leftRight) {
            int forward = Helper.isPositive(forwardBack) ? 0 : Math.abs(forwardBack);
            int back = Helper.isPositive(forwardBack) ? forwardBack : 0;
            int left = Helper.isPositive(leftRight) ? leftRight : 0;
            int right = Helper.isPositive(leftRight) ? 0 : Math.abs(leftRight);
            return this.offset(direction, forward, back, left, right, 0, 0);
        }

        public Single offset(class_2350 direction, int forward, int back, int left, int right) {
            return this.offset(direction, forward, back, left, right, 0, 0);
        }

        public Single offset(class_2350 direction, int forward, int back, int left, int right, int up, int down) {
            this.y = this.y + up - down;
            if (direction == class_2350.field_11035) {
                this.x = this.x - left + right;
                this.z = this.z - forward + back;
            } else if (direction == class_2350.field_11039) {
                this.x = this.x + forward - back;
                this.z = this.z - left + right;
            } else if (direction == class_2350.field_11043) {
                this.x = this.x + left - right;
                this.z = this.z + forward - back;
            } else if (direction == class_2350.field_11034) {
                this.x = this.x - forward + back;
                this.z = this.z + left - right;
            }
            return this;
        }

        public static Single setup(class_1937 world, int x, int y, int z) {
            return new Single(world, x, y, z);
        }

        public static Single setup(class_1937 world, class_2338 pos) {
            return new Single(world, pos.method_10263(), pos.method_10264(), pos.method_10260());
        }

        @Override
        public void build() {
            class_2680 state = this.blockType.getBlockState(this.world, this.y);
            class_2248 block = this.blockType.getBlock(this.world, this.y);
            class_2248 getBlock = this.getBlock();
            if (Common.CONFIG.KEEP_BLOCKS() && getBlock instanceof InstantBlock) {
                return;
            }
            if (this.world.method_27983().equals(class_1937.field_25180) && block.equals(class_2246.field_10382) && !Common.CONFIG.ALLOW_WATER_IN_NETHER()) {
                state = class_2246.field_10124.method_9564();
            }
            if (this.canSet(getBlock)) {
                Context context;
                if (block instanceof class_2310 && (state = block.method_9605((class_1750)(context = new Context(this.world, new class_2338(this.x, this.y, this.z))))) == null) {
                    return;
                }
                if (block instanceof class_2482 && this.direction == class_2350.field_11036) {
                    this.direction = null;
                    state = (class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
                }
                if (this.direction != null && state.method_28498((class_2769)class_2741.field_12481)) {
                    state = (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)this.direction);
                }
                if (block == class_2246.field_10362) {
                    state = (class_2680)state.method_11657((class_2769)class_2344.field_11009, (Comparable)Integer.valueOf(7));
                }
                if (block instanceof class_2244 && this.direction != null) {
                    state = (class_2680)state.method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.field_12560);
                }
                if (block instanceof class_2397) {
                    state = (class_2680)state.method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.TRUE);
                }
                if (block instanceof class_2281 && this.direction != null) {
                    class_2338 left_pos = new class_2338(this.x, this.y, this.z).method_10079(this.direction.method_10160(), 1);
                    class_2338 right_pos = new class_2338(this.x, this.y, this.z).method_10079(this.direction.method_10170(), 1);
                    class_2680 left = this.world.method_8320(left_pos);
                    class_2680 right = this.world.method_8320(right_pos);
                    if (left.method_26204() == class_2246.field_10034 && left.method_11654((class_2769)class_2281.field_10770) == class_2745.field_12569 && left.method_11654((class_2769)class_2281.field_10768) == this.direction) {
                        this.world.method_8652(left_pos, (class_2680)state.method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12574), this.flag);
                        state = (class_2680)state.method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12571);
                    } else if (right.method_26204() == class_2246.field_10034 && right.method_11654((class_2769)class_2281.field_10770) == class_2745.field_12569 && right.method_11654((class_2769)class_2281.field_10768) == this.direction) {
                        this.world.method_8652(left_pos, (class_2680)state.method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12571), this.flag);
                        state = (class_2680)state.method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12574);
                    }
                }
                this.world.method_8652(new class_2338(this.x, this.y, this.z), state, this.flag);
                if (block instanceof class_2323) {
                    this.world.method_8652(new class_2338(this.x, this.y, this.z).method_10084(), (class_2680)state.method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12609), 3);
                }
                if (block instanceof class_2244 && this.direction != null) {
                    this.world.method_8652(new class_2338(this.x, this.y, this.z).method_10079(this.direction.method_10153(), 1), (class_2680)state.method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.field_12557), 3);
                }
                if (this.blockType.isColor()) {
                    try {
                        ColorBlockEntity entity = (ColorBlockEntity)this.world.method_8321(new class_2338(this.x, this.y, this.z));
                        if (entity != null) {
                            entity.color = this.blockType.getColor();
                        }
                    }
                    catch (Exception e) {
                        Common.LOG.info(e.getMessage());
                    }
                }
            }
        }

        private boolean canSet(class_2248 block) {
            return block.method_36555() >= 0.0f || block.equals(class_2246.field_10124);
        }

        public class_2248 getBlock() {
            return this.world.method_8320(new class_2338(this.x, this.y, this.z)).method_26204();
        }

        public class_2586 getBlockEntity() {
            return this.world.method_8321(new class_2338(this.x, this.y, this.z));
        }
    }

    public static abstract class Base<T extends Base<T>> {
        final class_1937 world;
        int x;
        int y;
        int z;
        BlockType blockType;
        class_2350 direction;
        final int flag;

        private Base(class_1937 world, int x, int y, int z) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.flag = 2;
        }

        public T setBlock(BlockType blockType) {
            this.blockType = blockType;
            return (T)this;
        }

        public T setBlock(class_2248 block) {
            return this.setBlock(block.method_9564());
        }

        public T setBlock(class_2680 state) {
            return this.setBlock(BlockType.block(state));
        }

        public T setColor(int color) {
            return this.setBlock(BlockType.color(color));
        }

        public T setImageColor(BufferedImage image, int x, int y, boolean useRGB) {
            return useRGB ? this.setColor(image.getRGB(x, y)) : this.setBlock(ColorHelper.getWoolColor(ColorHelper.getColorAt(image, x, y)));
        }

        public T setStone() {
            return this.setBlock(BlockType.stone());
        }

        public T setDirection(class_2350 direction) {
            this.direction = direction;
            return (T)this;
        }

        public void build() {
        }
    }

    public static class BlockType {
        final Type type;
        final class_2680 state;
        final int color;

        private BlockType(Type type, class_2680 state, int color) {
            this.type = type;
            this.state = state;
            this.color = color;
        }

        public static BlockType block(class_2248 block) {
            return BlockType.block(block.method_9564());
        }

        public static BlockType block(class_2680 state) {
            return new BlockType(Type.BLOCK, state, 0);
        }

        public static BlockType color(int color) {
            return BlockType.color(color, ModBlocks.COLOR);
        }

        public static BlockType color(int color, class_2248 block) {
            return new BlockType(Type.COLOR, block.method_9564(), color);
        }

        public static BlockType stone() {
            return new BlockType(Type.STONE, null, 0);
        }

        public Type getType() {
            return this.type;
        }

        public boolean isColor() {
            return this.type == Type.COLOR;
        }

        public class_2248 getBlock(class_1937 world, int y) {
            return this.getBlockState(world, y).method_26204();
        }

        public class_2680 getBlockState(class_1937 world, int y) {
            if (this.type == Type.STONE) {
                class_2680 state;
                class_5321 dimension = world.method_27983();
                if (dimension.equals(class_1937.field_25179)) {
                    if (y > 8) {
                        state = class_2246.field_10340.method_9564();
                    } else if (y < 0) {
                        state = class_2246.field_28888.method_9564();
                    } else {
                        ArrayList<Helper.WeightedBlock> blocks = new ArrayList<Helper.WeightedBlock>();
                        blocks.add(new Helper.WeightedBlock(class_2246.field_10340, y + 1));
                        blocks.add(new Helper.WeightedBlock(class_2246.field_28888, 10 - y + 1));
                        state = Helper.getRandomBlock(blocks).method_9564();
                    }
                } else {
                    state = dimension.equals(class_1937.field_25180) ? class_2246.field_10515.method_9564() : (dimension.equals(class_1937.field_25181) ? class_2246.field_10471.method_9564() : class_2246.field_10340.method_9564());
                }
                return state;
            }
            return this.state;
        }

        public int getColor() {
            return this.color;
        }

        static enum Type {
            BLOCK,
            COLOR,
            STONE;

        }
    }
}

