/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.util;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.item.InstantWandItem;
import com.slymask3.instantblocks.network.packet.ClientPacket;
import com.slymask3.instantblocks.util.Builder;
import com.slymask3.instantblocks.util.ClientHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class Helper {
    public static boolean isServer(class_1937 world) {
        return !world.method_8608();
    }

    public static boolean isClient(class_1937 world) {
        return world.method_8608();
    }

    public static void giveExp(class_1937 world, class_1657 player, int amount) {
        if (amount > 0 && Helper.isServer(world)) {
            player.method_7255(amount);
        }
    }

    public static void teleport(class_1937 world, class_1657 player, int x, int y, int z) {
        if (Helper.isServer(world)) {
            player.method_5859((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        }
    }

    public static void addToChest(class_2595 chest, class_2248 block, int amount) {
        Helper.addToChest(chest, block.method_8389(), amount);
    }

    public static void addToChest(class_2595 chest, class_1792 item, int amount) {
        if (chest != null) {
            class_1799 itemStack = new class_1799((class_1935)item, amount);
            for (int i = 0; i < chest.method_5439(); ++i) {
                class_1799 itemStackSlot = chest.method_5438(i);
                if (itemStackSlot.method_7962(itemStack) && itemStackSlot.method_7947() < itemStackSlot.method_7914()) {
                    chest.method_5447(i, new class_1799((class_1935)item, itemStackSlot.method_7947() + amount));
                    break;
                }
                if (chest.method_5438(i) != class_1799.field_8037) continue;
                chest.method_5447(i, new class_1799((class_1935)item, amount));
                break;
            }
        }
    }

    public static boolean isWand(class_1799 is) {
        return is.method_7909() instanceof InstantWandItem;
    }

    public static int wandDamage(class_2248 block) {
        return switch (block.method_9539().substring("instantblocks".length() + 7)) {
            case "instant_wood_house" -> Common.CONFIG.DAMAGE_WOODEN_HOUSE();
            case "instant_mining_ladder" -> Common.CONFIG.DAMAGE_MINING_LADDER();
            case "instant_glass_dome" -> Common.CONFIG.DAMAGE_GLASS_DOME();
            case "instant_farm" -> Common.CONFIG.DAMAGE_FARM();
            case "instant_skydive" -> Common.CONFIG.DAMAGE_SKYDIVE();
            case "instant_grinder" -> Common.CONFIG.DAMAGE_GRINDER();
            case "instant_pool" -> Common.CONFIG.DAMAGE_POOL();
            case "instant_escape_ladder" -> Common.CONFIG.DAMAGE_ESCAPE_LADDER();
            case "instant_water" -> Common.CONFIG.DAMAGE_WATER();
            case "instant_lava" -> Common.CONFIG.DAMAGE_LAVA();
            case "instant_suction" -> Common.CONFIG.DAMAGE_SUCTION();
            case "instant_rail" -> Common.CONFIG.DAMAGE_RAIL();
            case "instant_statue" -> Common.CONFIG.DAMAGE_STATUE();
            case "instant_harvest" -> Common.CONFIG.DAMAGE_HARVEST();
            case "instant_light" -> Common.CONFIG.DAMAGE_LIGHT();
            case "instant_schematic" -> Common.CONFIG.DAMAGE_SCHEMATIC();
            case "instant_tree" -> Common.CONFIG.DAMAGE_TREE();
            default -> 1;
        };
    }

    public static boolean isPositive(int i) {
        if (i == 0) {
            return true;
        }
        return i >> 31 == 0;
    }

    public static boolean isDoubleChest(class_2595 chest) {
        return chest.method_5439() == 54;
    }

    public static int getMinSkydive(class_1937 world) {
        int min = Common.CONFIG.SKYDIVE_MIN();
        if (min < world.method_31607() - 4) {
            min = world.method_31607() - 5;
        }
        return min;
    }

    public static int getMaxSkydive(class_1937 world) {
        int max = Common.CONFIG.SKYDIVE_MAX();
        if (max > world.method_31600() - 3) {
            max = world.method_31600() - 4;
        }
        return max;
    }

    public static void sendMessage(class_1657 player, String message) {
        Helper.sendMessage(player, message, "", class_2338.field_10980, ClientHelper.Particles.NONE);
    }

    public static void sendMessage(class_1657 player, String message, String variable) {
        Helper.sendMessage(player, message, variable, class_2338.field_10980, ClientHelper.Particles.NONE);
    }

    public static void sendMessage(class_1657 player, String message, String variable, class_2338 pos) {
        Helper.sendMessage(player, message, variable, pos, ClientHelper.Particles.GENERATE);
    }

    public static void sendMessage(class_1657 player, String message, String variable, class_2338 pos, ClientHelper.Particles particles) {
        if (Helper.isServer(player.method_37908())) {
            Common.NETWORK.sendToClient((class_3222)player, new ClientPacket(message, variable, pos, particles.ordinal()));
        }
    }

    public static class_2248 getBlock(class_1937 world, int x, int y, int z) {
        return Helper.getBlock(world, new class_2338(x, y, z));
    }

    public static class_2248 getBlock(class_1937 world, class_2338 pos) {
        return Builder.Single.setup(world, pos).getBlock();
    }

    public static class_2248 getRandomBlock(List<WeightedBlock> blocks) {
        Random random = new Random();
        int total = 0;
        for (WeightedBlock block : blocks) {
            total += block.getWeight();
        }
        int r = random.nextInt(total) + 1;
        int count = 0;
        for (WeightedBlock block : blocks) {
            if ((count += block.getWeight()) < r) continue;
            return block.getBlock();
        }
        return blocks.get(0).getBlock();
    }

    public static class_2248 readBlock(String string, class_2248 fallback) {
        return Helper.readBlockState(string, fallback.method_9564()).method_26204();
    }

    public static class_2680 readBlockState(String string) {
        return Helper.readBlockState(string, class_2246.field_10124.method_9564());
    }

    public static class_2680 readBlockState(String string, class_2680 fallback) {
        class_2680 state;
        class_2487 tag = new class_2487();
        String[] split = string.split("\\[", 2);
        tag.method_10582("Name", split[0]);
        if (split.length == 2) {
            String[] properties;
            class_2487 propertiesTag = new class_2487();
            for (String property : properties = split[1].replace("]", "").split(",")) {
                String[] values = property.split("=");
                if (values.length != 2) continue;
                propertiesTag.method_10582(values[0], values[1]);
            }
            tag.method_10566("Properties", (class_2520)propertiesTag);
        }
        if ((state = class_2512.method_10681((class_2487)tag)).method_26204().equals(class_2246.field_10124)) {
            return fallback;
        }
        return state;
    }

    public static class WeightedBlock {
        private final class_2248 block;
        private final int weight;

        public WeightedBlock(class_2248 block, int weight) {
            this.block = block;
            this.weight = weight;
        }

        public class_2248 getBlock() {
            return this.block;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

